/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.DeviceSafety;

public class DeviceSafetyEnumFactory
implements EnumFactory<DeviceSafety> {
    @Override
    public DeviceSafety fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("contains-latex".equals(codeString)) {
            return DeviceSafety.CONTAINSLATEX;
        }
        if ("latex-free".equals(codeString)) {
            return DeviceSafety.LATEXFREE;
        }
        if ("latex-unknown".equals(codeString)) {
            return DeviceSafety.LATEXUNKNOWN;
        }
        if ("mr-safe".equals(codeString)) {
            return DeviceSafety.MRSAFE;
        }
        if ("mr-unsafe".equals(codeString)) {
            return DeviceSafety.MRUNSAFE;
        }
        if ("mr-conditional".equals(codeString)) {
            return DeviceSafety.MRCONDITIONAL;
        }
        if ("mr-unknown".equals(codeString)) {
            return DeviceSafety.MRUNKNOWN;
        }
        throw new IllegalArgumentException("Unknown DeviceSafety code '" + codeString + "'");
    }

    @Override
    public String toCode(DeviceSafety code) {
        if (code == DeviceSafety.CONTAINSLATEX) {
            return "contains-latex";
        }
        if (code == DeviceSafety.LATEXFREE) {
            return "latex-free";
        }
        if (code == DeviceSafety.LATEXUNKNOWN) {
            return "latex-unknown";
        }
        if (code == DeviceSafety.MRSAFE) {
            return "mr-safe";
        }
        if (code == DeviceSafety.MRUNSAFE) {
            return "mr-unsafe";
        }
        if (code == DeviceSafety.MRCONDITIONAL) {
            return "mr-conditional";
        }
        if (code == DeviceSafety.MRUNKNOWN) {
            return "mr-unknown";
        }
        return "?";
    }

    @Override
    public String toSystem(DeviceSafety code) {
        return code.getSystem();
    }
}

