/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ConsentAction {
    COLLECT,
    ACCESS,
    USE,
    DISCLOSE,
    CORRECT,
    NULL;


    public static ConsentAction fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("collect".equals(codeString)) {
            return COLLECT;
        }
        if ("access".equals(codeString)) {
            return ACCESS;
        }
        if ("use".equals(codeString)) {
            return USE;
        }
        if ("disclose".equals(codeString)) {
            return DISCLOSE;
        }
        if ("correct".equals(codeString)) {
            return CORRECT;
        }
        throw new FHIRException("Unknown ConsentAction code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case COLLECT: {
                return "collect";
            }
            case ACCESS: {
                return "access";
            }
            case USE: {
                return "use";
            }
            case DISCLOSE: {
                return "disclose";
            }
            case CORRECT: {
                return "correct";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/consentaction";
    }

    public String getDefinition() {
        switch (this) {
            case COLLECT: {
                return "Gather/acquire information by an entity to achieve a stated purpose";
            }
            case ACCESS: {
                return "Provide an entity access to information to achieve a stated purpose";
            }
            case USE: {
                return "Use of stored information by an entity fo the stated purpose";
            }
            case DISCLOSE: {
                return "Release / transfer of information to an entity ";
            }
            case CORRECT: {
                return "Allowing an entity to correct a patient's information";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case COLLECT: {
                return "Collect";
            }
            case ACCESS: {
                return "Access";
            }
            case USE: {
                return "Use";
            }
            case DISCLOSE: {
                return "Disclose";
            }
            case CORRECT: {
                return "Access and Correct";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

