/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.ClaimUse;

public class ClaimUseEnumFactory
implements EnumFactory<ClaimUse> {
    @Override
    public ClaimUse fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("complete".equals(codeString)) {
            return ClaimUse.COMPLETE;
        }
        if ("proposed".equals(codeString)) {
            return ClaimUse.PROPOSED;
        }
        if ("exploratory".equals(codeString)) {
            return ClaimUse.EXPLORATORY;
        }
        if ("other".equals(codeString)) {
            return ClaimUse.OTHER;
        }
        throw new IllegalArgumentException("Unknown ClaimUse code '" + codeString + "'");
    }

    @Override
    public String toCode(ClaimUse code) {
        if (code == ClaimUse.COMPLETE) {
            return "complete";
        }
        if (code == ClaimUse.PROPOSED) {
            return "proposed";
        }
        if (code == ClaimUse.EXPLORATORY) {
            return "exploratory";
        }
        if (code == ClaimUse.OTHER) {
            return "other";
        }
        return "?";
    }

    @Override
    public String toSystem(ClaimUse code) {
        return code.getSystem();
    }
}

