/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.List;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DecimalType;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="Quantity")
public class Quantity
extends Type
implements ICompositeType {
    @Child(name="value", type={DecimalType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Numerical value (with implicit precision)", formalDefinition="The value of the measured amount. The value includes an implicit precision in the presentation of the value.")
    protected DecimalType value;
    @Child(name="comparator", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="< | <= | >= | > - how to understand the value", formalDefinition="How the value should be understood and represented - whether the actual value is greater or less than the stated value due to measurement issues; e.g. if the comparator is \"<\" , then the real value is < stated value.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/quantity-comparator")
    protected Enumeration<QuantityComparator> comparator;
    @Child(name="unit", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Unit representation", formalDefinition="A human-readable form of the unit.")
    protected StringType unit;
    @Child(name="system", type={UriType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="System that defines coded unit form", formalDefinition="The identification of the system that provides the coded form of the unit.")
    protected UriType system;
    @Child(name="code", type={CodeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Coded form of the unit", formalDefinition="A computer processable form of the unit in some unit representation system.")
    protected CodeType code;
    private static final long serialVersionUID = 1069574054L;

    public Quantity() {
    }

    public Quantity(double theValue) {
        this.setValue(theValue);
    }

    public Quantity(long theValue) {
        this.setValue(theValue);
    }

    public Quantity(QuantityComparator theComparator, double theValue, String theSystem, String theCode, String theUnit) {
        this.setValue(theValue);
        this.setComparator(theComparator);
        this.setSystem(theSystem);
        this.setCode(theCode);
        this.setUnit(theUnit);
    }

    public Quantity(QuantityComparator theComparator, long theValue, String theSystem, String theCode, String theUnit) {
        this.setValue(theValue);
        this.setComparator(theComparator);
        this.setSystem(theSystem);
        this.setCode(theCode);
        this.setUnit(theUnit);
    }

    public DecimalType getValueElement() {
        if (this.value == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Quantity.value");
            }
            if (Configuration.doAutoCreate()) {
                this.value = new DecimalType();
            }
        }
        return this.value;
    }

    public boolean hasValueElement() {
        return this.value != null && !this.value.isEmpty();
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public Quantity setValueElement(DecimalType value) {
        this.value = value;
        return this;
    }

    public BigDecimal getValue() {
        return this.value == null ? null : (BigDecimal)this.value.getValue();
    }

    public Quantity setValue(BigDecimal value) {
        if (value == null) {
            this.value = null;
        } else {
            if (this.value == null) {
                this.value = new DecimalType();
            }
            this.value.setValue(value);
        }
        return this;
    }

    public Quantity setValue(long value) {
        this.value = new DecimalType();
        this.value.setValue(value);
        return this;
    }

    public Quantity setValue(double value) {
        this.value = new DecimalType();
        this.value.setValue(value);
        return this;
    }

    public Enumeration<QuantityComparator> getComparatorElement() {
        if (this.comparator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Quantity.comparator");
            }
            if (Configuration.doAutoCreate()) {
                this.comparator = new Enumeration<QuantityComparator>(new QuantityComparatorEnumFactory());
            }
        }
        return this.comparator;
    }

    public boolean hasComparatorElement() {
        return this.comparator != null && !this.comparator.isEmpty();
    }

    public boolean hasComparator() {
        return this.comparator != null && !this.comparator.isEmpty();
    }

    public Quantity setComparatorElement(Enumeration<QuantityComparator> value) {
        this.comparator = value;
        return this;
    }

    public QuantityComparator getComparator() {
        return this.comparator == null ? null : (QuantityComparator)((Object)this.comparator.getValue());
    }

    public Quantity setComparator(QuantityComparator value) {
        if (value == null) {
            this.comparator = null;
        } else {
            if (this.comparator == null) {
                this.comparator = new Enumeration<QuantityComparator>(new QuantityComparatorEnumFactory());
            }
            this.comparator.setValue((Object)value);
        }
        return this;
    }

    public StringType getUnitElement() {
        if (this.unit == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Quantity.unit");
            }
            if (Configuration.doAutoCreate()) {
                this.unit = new StringType();
            }
        }
        return this.unit;
    }

    public boolean hasUnitElement() {
        return this.unit != null && !this.unit.isEmpty();
    }

    public boolean hasUnit() {
        return this.unit != null && !this.unit.isEmpty();
    }

    public Quantity setUnitElement(StringType value) {
        this.unit = value;
        return this;
    }

    public String getUnit() {
        return this.unit == null ? null : (String)this.unit.getValue();
    }

    public Quantity setUnit(String value) {
        if (Utilities.noString((String)value)) {
            this.unit = null;
        } else {
            if (this.unit == null) {
                this.unit = new StringType();
            }
            this.unit.setValue(value);
        }
        return this;
    }

    public UriType getSystemElement() {
        if (this.system == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Quantity.system");
            }
            if (Configuration.doAutoCreate()) {
                this.system = new UriType();
            }
        }
        return this.system;
    }

    public boolean hasSystemElement() {
        return this.system != null && !this.system.isEmpty();
    }

    public boolean hasSystem() {
        return this.system != null && !this.system.isEmpty();
    }

    public Quantity setSystemElement(UriType value) {
        this.system = value;
        return this;
    }

    public String getSystem() {
        return this.system == null ? null : (String)this.system.getValue();
    }

    public Quantity setSystem(String value) {
        if (Utilities.noString((String)value)) {
            this.system = null;
        } else {
            if (this.system == null) {
                this.system = new UriType();
            }
            this.system.setValue(value);
        }
        return this;
    }

    public CodeType getCodeElement() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Quantity.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeType();
            }
        }
        return this.code;
    }

    public boolean hasCodeElement() {
        return this.code != null && !this.code.isEmpty();
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public Quantity setCodeElement(CodeType value) {
        this.code = value;
        return this;
    }

    public String getCode() {
        return this.code == null ? null : (String)this.code.getValue();
    }

    public Quantity setCode(String value) {
        if (Utilities.noString((String)value)) {
            this.code = null;
        } else {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("value", "decimal", "The value of the measured amount. The value includes an implicit precision in the presentation of the value.", 0, 1, this.value));
        children.add(new Property("comparator", "code", "How the value should be understood and represented - whether the actual value is greater or less than the stated value due to measurement issues; e.g. if the comparator is \"<\" , then the real value is < stated value.", 0, 1, this.comparator));
        children.add(new Property("unit", "string", "A human-readable form of the unit.", 0, 1, this.unit));
        children.add(new Property("system", "uri", "The identification of the system that provides the coded form of the unit.", 0, 1, this.system));
        children.add(new Property("code", "code", "A computer processable form of the unit in some unit representation system.", 0, 1, this.code));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 111972721: {
                return new Property("value", "decimal", "The value of the measured amount. The value includes an implicit precision in the presentation of the value.", 0, 1, this.value);
            }
            case -844673834: {
                return new Property("comparator", "code", "How the value should be understood and represented - whether the actual value is greater or less than the stated value due to measurement issues; e.g. if the comparator is \"<\" , then the real value is < stated value.", 0, 1, this.comparator);
            }
            case 3594628: {
                return new Property("unit", "string", "A human-readable form of the unit.", 0, 1, this.unit);
            }
            case -887328209: {
                return new Property("system", "uri", "The identification of the system that provides the coded form of the unit.", 0, 1, this.system);
            }
            case 3059181: {
                return new Property("code", "code", "A computer processable form of the unit in some unit representation system.", 0, 1, this.code);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 111972721: {
                Base[] baseArray;
                if (this.value == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.value;
                }
                return baseArray;
            }
            case -844673834: {
                Base[] baseArray;
                if (this.comparator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.comparator;
                }
                return baseArray;
            }
            case 3594628: {
                Base[] baseArray;
                if (this.unit == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.unit;
                }
                return baseArray;
            }
            case -887328209: {
                Base[] baseArray;
                if (this.system == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.system;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.code;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 111972721: {
                this.value = this.castToDecimal(value);
                return value;
            }
            case -844673834: {
                value = new QuantityComparatorEnumFactory().fromType(this.castToCode(value));
                this.comparator = value;
                return value;
            }
            case 3594628: {
                this.unit = this.castToString(value);
                return value;
            }
            case -887328209: {
                this.system = this.castToUri(value);
                return value;
            }
            case 3059181: {
                this.code = this.castToCode(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("value")) {
            this.value = this.castToDecimal(value);
        } else if (name.equals("comparator")) {
            value = new QuantityComparatorEnumFactory().fromType(this.castToCode(value));
            this.comparator = value;
        } else if (name.equals("unit")) {
            this.unit = this.castToString(value);
        } else if (name.equals("system")) {
            this.system = this.castToUri(value);
        } else if (name.equals("code")) {
            this.code = this.castToCode(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 111972721: {
                return this.getValueElement();
            }
            case -844673834: {
                return this.getComparatorElement();
            }
            case 3594628: {
                return this.getUnitElement();
            }
            case -887328209: {
                return this.getSystemElement();
            }
            case 3059181: {
                return this.getCodeElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 111972721: {
                return new String[]{"decimal"};
            }
            case -844673834: {
                return new String[]{"code"};
            }
            case 3594628: {
                return new String[]{"string"};
            }
            case -887328209: {
                return new String[]{"uri"};
            }
            case 3059181: {
                return new String[]{"code"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("value")) {
            throw new FHIRException("Cannot call addChild on a primitive type Quantity.value");
        }
        if (name.equals("comparator")) {
            throw new FHIRException("Cannot call addChild on a primitive type Quantity.comparator");
        }
        if (name.equals("unit")) {
            throw new FHIRException("Cannot call addChild on a primitive type Quantity.unit");
        }
        if (name.equals("system")) {
            throw new FHIRException("Cannot call addChild on a primitive type Quantity.system");
        }
        if (name.equals("code")) {
            throw new FHIRException("Cannot call addChild on a primitive type Quantity.code");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Quantity";
    }

    @Override
    public Quantity copy() {
        Quantity dst = new Quantity();
        this.copyValues(dst);
        dst.value = this.value == null ? null : this.value.copy();
        dst.comparator = this.comparator == null ? null : this.comparator.copy();
        dst.unit = this.unit == null ? null : this.unit.copy();
        dst.system = this.system == null ? null : this.system.copy();
        dst.code = this.code == null ? null : this.code.copy();
        return dst;
    }

    @Override
    protected Quantity typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Quantity)) {
            return false;
        }
        Quantity o = (Quantity)other_;
        return Quantity.compareDeep(this.value, o.value, true) && Quantity.compareDeep(this.comparator, o.comparator, true) && Quantity.compareDeep(this.unit, o.unit, true) && Quantity.compareDeep(this.system, o.system, true) && Quantity.compareDeep(this.code, o.code, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Quantity)) {
            return false;
        }
        Quantity o = (Quantity)other_;
        return Quantity.compareValues(this.value, o.value, true) && Quantity.compareValues(this.comparator, o.comparator, true) && Quantity.compareValues(this.unit, o.unit, true) && Quantity.compareValues(this.system, o.system, true) && Quantity.compareValues(this.code, o.code, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.value, this.comparator, this.unit, this.system, this.code});
    }

    public static class QuantityComparatorEnumFactory
    implements EnumFactory<QuantityComparator> {
        @Override
        public QuantityComparator fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("<".equals(codeString)) {
                return QuantityComparator.LESS_THAN;
            }
            if ("<=".equals(codeString)) {
                return QuantityComparator.LESS_OR_EQUAL;
            }
            if (">=".equals(codeString)) {
                return QuantityComparator.GREATER_OR_EQUAL;
            }
            if (">".equals(codeString)) {
                return QuantityComparator.GREATER_THAN;
            }
            throw new IllegalArgumentException("Unknown QuantityComparator code '" + codeString + "'");
        }

        public Enumeration<QuantityComparator> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<QuantityComparator>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("<".equals(codeString)) {
                return new Enumeration<QuantityComparator>(this, QuantityComparator.LESS_THAN);
            }
            if ("<=".equals(codeString)) {
                return new Enumeration<QuantityComparator>(this, QuantityComparator.LESS_OR_EQUAL);
            }
            if (">=".equals(codeString)) {
                return new Enumeration<QuantityComparator>(this, QuantityComparator.GREATER_OR_EQUAL);
            }
            if (">".equals(codeString)) {
                return new Enumeration<QuantityComparator>(this, QuantityComparator.GREATER_THAN);
            }
            throw new FHIRException("Unknown QuantityComparator code '" + codeString + "'");
        }

        @Override
        public String toCode(QuantityComparator code) {
            if (code == QuantityComparator.LESS_THAN) {
                return "<";
            }
            if (code == QuantityComparator.LESS_OR_EQUAL) {
                return "<=";
            }
            if (code == QuantityComparator.GREATER_OR_EQUAL) {
                return ">=";
            }
            if (code == QuantityComparator.GREATER_THAN) {
                return ">";
            }
            return "?";
        }

        @Override
        public String toSystem(QuantityComparator code) {
            return code.getSystem();
        }
    }

    public static enum QuantityComparator {
        LESS_THAN,
        LESS_OR_EQUAL,
        GREATER_OR_EQUAL,
        GREATER_THAN,
        NULL;


        public static QuantityComparator fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("<".equals(codeString)) {
                return LESS_THAN;
            }
            if ("<=".equals(codeString)) {
                return LESS_OR_EQUAL;
            }
            if (">=".equals(codeString)) {
                return GREATER_OR_EQUAL;
            }
            if (">".equals(codeString)) {
                return GREATER_THAN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown QuantityComparator code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case LESS_THAN: {
                    return "<";
                }
                case LESS_OR_EQUAL: {
                    return "<=";
                }
                case GREATER_OR_EQUAL: {
                    return ">=";
                }
                case GREATER_THAN: {
                    return ">";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case LESS_THAN: {
                    return "http://hl7.org/fhir/quantity-comparator";
                }
                case LESS_OR_EQUAL: {
                    return "http://hl7.org/fhir/quantity-comparator";
                }
                case GREATER_OR_EQUAL: {
                    return "http://hl7.org/fhir/quantity-comparator";
                }
                case GREATER_THAN: {
                    return "http://hl7.org/fhir/quantity-comparator";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case LESS_THAN: {
                    return "The actual value is less than the given value.";
                }
                case LESS_OR_EQUAL: {
                    return "The actual value is less than or equal to the given value.";
                }
                case GREATER_OR_EQUAL: {
                    return "The actual value is greater than or equal to the given value.";
                }
                case GREATER_THAN: {
                    return "The actual value is greater than the given value.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case LESS_THAN: {
                    return "Less than";
                }
                case LESS_OR_EQUAL: {
                    return "Less or Equal to";
                }
                case GREATER_OR_EQUAL: {
                    return "Greater or Equal to";
                }
                case GREATER_THAN: {
                    return "Greater than";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

