/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.InstantType;
import org.hl7.fhir.dstu3.model.OperationOutcome;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="MessageHeader", profile="http://hl7.org/fhir/Profile/MessageHeader")
public class MessageHeader
extends DomainResource {
    @Child(name="event", type={Coding.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Code for the event this message represents", formalDefinition="Code that identifies the event this message represents and connects it with its definition. Events defined as part of the FHIR specification have the system value \"http://hl7.org/fhir/message-events\".")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/message-events")
    protected Coding event;
    @Child(name="destination", type={}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Message destination application(s)", formalDefinition="The destination application which the message is intended for.")
    protected List<MessageDestinationComponent> destination;
    @Child(name="receiver", type={Practitioner.class, Organization.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Intended \"real-world\" recipient for the data", formalDefinition="Allows data conveyed by a message to be addressed to a particular person or department when routing to a specific application isn't sufficient.")
    protected Reference receiver;
    protected Resource receiverTarget;
    @Child(name="sender", type={Practitioner.class, Organization.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Real world sender of the message", formalDefinition="Identifies the sending system to allow the use of a trust relationship.")
    protected Reference sender;
    protected Resource senderTarget;
    @Child(name="timestamp", type={InstantType.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Time that the message was sent", formalDefinition="The time that the message was sent.")
    protected InstantType timestamp;
    @Child(name="enterer", type={Practitioner.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The source of the data entry", formalDefinition="The person or device that performed the data entry leading to this message. When there is more than one candidate, pick the most proximal to the message. Can provide other enterers in extensions.")
    protected Reference enterer;
    protected Practitioner entererTarget;
    @Child(name="author", type={Practitioner.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The source of the decision", formalDefinition="The logical author of the message - the person or device that decided the described event should happen. When there is more than one candidate, pick the most proximal to the MessageHeader. Can provide other authors in extensions.")
    protected Reference author;
    protected Practitioner authorTarget;
    @Child(name="source", type={}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Message source application", formalDefinition="The source application from which this message originated.")
    protected MessageSourceComponent source;
    @Child(name="responsible", type={Practitioner.class, Organization.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Final responsibility for event", formalDefinition="The person or organization that accepts overall responsibility for the contents of the message. The implication is that the message event happened under the policies of the responsible party.")
    protected Reference responsible;
    protected Resource responsibleTarget;
    @Child(name="reason", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Cause of event", formalDefinition="Coded indication of the cause for the event - indicates  a reason for the occurrence of the event that is a focus of this message.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/message-reason-encounter")
    protected CodeableConcept reason;
    @Child(name="response", type={}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If this is a reply to prior message", formalDefinition="Information about the message that this message is a response to.  Only present if this message is a response.")
    protected MessageHeaderResponseComponent response;
    @Child(name="focus", type={Reference.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The actual content of the message", formalDefinition="The actual data of the message - a reference to the root/focus class of the event.")
    protected List<Reference> focus;
    protected List<Resource> focusTarget;
    private static final long serialVersionUID = 1142547869L;
    @SearchParamDefinition(name="code", path="MessageHeader.response.code", description="ok | transient-error | fatal-error", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="receiver", path="MessageHeader.receiver", description="Intended \"real-world\" recipient for the data", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Organization.class, Practitioner.class})
    public static final String SP_RECEIVER = "receiver";
    public static final ReferenceClientParam RECEIVER = new ReferenceClientParam("receiver");
    public static final Include INCLUDE_RECEIVER = new Include("MessageHeader:receiver").toLocked();
    @SearchParamDefinition(name="author", path="MessageHeader.author", description="The source of the decision", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Practitioner.class})
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("MessageHeader:author").toLocked();
    @SearchParamDefinition(name="destination", path="MessageHeader.destination.name", description="Name of system", type="string")
    public static final String SP_DESTINATION = "destination";
    public static final StringClientParam DESTINATION = new StringClientParam("destination");
    @SearchParamDefinition(name="focus", path="MessageHeader.focus", description="The actual content of the message", type="reference")
    public static final String SP_FOCUS = "focus";
    public static final ReferenceClientParam FOCUS = new ReferenceClientParam("focus");
    public static final Include INCLUDE_FOCUS = new Include("MessageHeader:focus").toLocked();
    @SearchParamDefinition(name="source", path="MessageHeader.source.name", description="Name of system", type="string")
    public static final String SP_SOURCE = "source";
    public static final StringClientParam SOURCE = new StringClientParam("source");
    @SearchParamDefinition(name="target", path="MessageHeader.destination.target", description="Particular delivery destination within the destination", type="reference", providesMembershipIn={@Compartment(name="Device")}, target={Device.class})
    public static final String SP_TARGET = "target";
    public static final ReferenceClientParam TARGET = new ReferenceClientParam("target");
    public static final Include INCLUDE_TARGET = new Include("MessageHeader:target").toLocked();
    @SearchParamDefinition(name="destination-uri", path="MessageHeader.destination.endpoint", description="Actual destination address or id", type="uri")
    public static final String SP_DESTINATION_URI = "destination-uri";
    public static final UriClientParam DESTINATION_URI = new UriClientParam("destination-uri");
    @SearchParamDefinition(name="source-uri", path="MessageHeader.source.endpoint", description="Actual message source address or id", type="uri")
    public static final String SP_SOURCE_URI = "source-uri";
    public static final UriClientParam SOURCE_URI = new UriClientParam("source-uri");
    @SearchParamDefinition(name="sender", path="MessageHeader.sender", description="Real world sender of the message", type="reference", target={Organization.class, Practitioner.class})
    public static final String SP_SENDER = "sender";
    public static final ReferenceClientParam SENDER = new ReferenceClientParam("sender");
    public static final Include INCLUDE_SENDER = new Include("MessageHeader:sender").toLocked();
    @SearchParamDefinition(name="responsible", path="MessageHeader.responsible", description="Final responsibility for event", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Organization.class, Practitioner.class})
    public static final String SP_RESPONSIBLE = "responsible";
    public static final ReferenceClientParam RESPONSIBLE = new ReferenceClientParam("responsible");
    public static final Include INCLUDE_RESPONSIBLE = new Include("MessageHeader:responsible").toLocked();
    @SearchParamDefinition(name="enterer", path="MessageHeader.enterer", description="The source of the data entry", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Practitioner.class})
    public static final String SP_ENTERER = "enterer";
    public static final ReferenceClientParam ENTERER = new ReferenceClientParam("enterer");
    public static final Include INCLUDE_ENTERER = new Include("MessageHeader:enterer").toLocked();
    @SearchParamDefinition(name="response-id", path="MessageHeader.response.identifier", description="Id of original message", type="token")
    public static final String SP_RESPONSE_ID = "response-id";
    public static final TokenClientParam RESPONSE_ID = new TokenClientParam("response-id");
    @SearchParamDefinition(name="event", path="MessageHeader.event", description="Code for the event this message represents", type="token")
    public static final String SP_EVENT = "event";
    public static final TokenClientParam EVENT = new TokenClientParam("event");
    @SearchParamDefinition(name="timestamp", path="MessageHeader.timestamp", description="Time that the message was sent", type="date")
    public static final String SP_TIMESTAMP = "timestamp";
    public static final DateClientParam TIMESTAMP = new DateClientParam("timestamp");

    public MessageHeader() {
    }

    public MessageHeader(Coding event, InstantType timestamp, MessageSourceComponent source) {
        this.event = event;
        this.timestamp = timestamp;
        this.source = source;
    }

    public Coding getEvent() {
        if (this.event == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.event");
            }
            if (Configuration.doAutoCreate()) {
                this.event = new Coding();
            }
        }
        return this.event;
    }

    public boolean hasEvent() {
        return this.event != null && !this.event.isEmpty();
    }

    public MessageHeader setEvent(Coding value) {
        this.event = value;
        return this;
    }

    public List<MessageDestinationComponent> getDestination() {
        if (this.destination == null) {
            this.destination = new ArrayList<MessageDestinationComponent>();
        }
        return this.destination;
    }

    public MessageHeader setDestination(List<MessageDestinationComponent> theDestination) {
        this.destination = theDestination;
        return this;
    }

    public boolean hasDestination() {
        if (this.destination == null) {
            return false;
        }
        for (MessageDestinationComponent item : this.destination) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MessageDestinationComponent addDestination() {
        MessageDestinationComponent t = new MessageDestinationComponent();
        if (this.destination == null) {
            this.destination = new ArrayList<MessageDestinationComponent>();
        }
        this.destination.add(t);
        return t;
    }

    public MessageHeader addDestination(MessageDestinationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.destination == null) {
            this.destination = new ArrayList<MessageDestinationComponent>();
        }
        this.destination.add(t);
        return this;
    }

    public MessageDestinationComponent getDestinationFirstRep() {
        if (this.getDestination().isEmpty()) {
            this.addDestination();
        }
        return this.getDestination().get(0);
    }

    public Reference getReceiver() {
        if (this.receiver == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.receiver");
            }
            if (Configuration.doAutoCreate()) {
                this.receiver = new Reference();
            }
        }
        return this.receiver;
    }

    public boolean hasReceiver() {
        return this.receiver != null && !this.receiver.isEmpty();
    }

    public MessageHeader setReceiver(Reference value) {
        this.receiver = value;
        return this;
    }

    public Resource getReceiverTarget() {
        return this.receiverTarget;
    }

    public MessageHeader setReceiverTarget(Resource value) {
        this.receiverTarget = value;
        return this;
    }

    public Reference getSender() {
        if (this.sender == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.sender");
            }
            if (Configuration.doAutoCreate()) {
                this.sender = new Reference();
            }
        }
        return this.sender;
    }

    public boolean hasSender() {
        return this.sender != null && !this.sender.isEmpty();
    }

    public MessageHeader setSender(Reference value) {
        this.sender = value;
        return this;
    }

    public Resource getSenderTarget() {
        return this.senderTarget;
    }

    public MessageHeader setSenderTarget(Resource value) {
        this.senderTarget = value;
        return this;
    }

    public InstantType getTimestampElement() {
        if (this.timestamp == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.timestamp");
            }
            if (Configuration.doAutoCreate()) {
                this.timestamp = new InstantType();
            }
        }
        return this.timestamp;
    }

    public boolean hasTimestampElement() {
        return this.timestamp != null && !this.timestamp.isEmpty();
    }

    public boolean hasTimestamp() {
        return this.timestamp != null && !this.timestamp.isEmpty();
    }

    public MessageHeader setTimestampElement(InstantType value) {
        this.timestamp = value;
        return this;
    }

    public Date getTimestamp() {
        return this.timestamp == null ? null : (Date)this.timestamp.getValue();
    }

    public MessageHeader setTimestamp(Date value) {
        if (this.timestamp == null) {
            this.timestamp = new InstantType();
        }
        this.timestamp.setValue(value);
        return this;
    }

    public Reference getEnterer() {
        if (this.enterer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.enterer");
            }
            if (Configuration.doAutoCreate()) {
                this.enterer = new Reference();
            }
        }
        return this.enterer;
    }

    public boolean hasEnterer() {
        return this.enterer != null && !this.enterer.isEmpty();
    }

    public MessageHeader setEnterer(Reference value) {
        this.enterer = value;
        return this;
    }

    public Practitioner getEntererTarget() {
        if (this.entererTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.enterer");
            }
            if (Configuration.doAutoCreate()) {
                this.entererTarget = new Practitioner();
            }
        }
        return this.entererTarget;
    }

    public MessageHeader setEntererTarget(Practitioner value) {
        this.entererTarget = value;
        return this;
    }

    public Reference getAuthor() {
        if (this.author == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.author");
            }
            if (Configuration.doAutoCreate()) {
                this.author = new Reference();
            }
        }
        return this.author;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public MessageHeader setAuthor(Reference value) {
        this.author = value;
        return this;
    }

    public Practitioner getAuthorTarget() {
        if (this.authorTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.author");
            }
            if (Configuration.doAutoCreate()) {
                this.authorTarget = new Practitioner();
            }
        }
        return this.authorTarget;
    }

    public MessageHeader setAuthorTarget(Practitioner value) {
        this.authorTarget = value;
        return this;
    }

    public MessageSourceComponent getSource() {
        if (this.source == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.source");
            }
            if (Configuration.doAutoCreate()) {
                this.source = new MessageSourceComponent();
            }
        }
        return this.source;
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public MessageHeader setSource(MessageSourceComponent value) {
        this.source = value;
        return this;
    }

    public Reference getResponsible() {
        if (this.responsible == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.responsible");
            }
            if (Configuration.doAutoCreate()) {
                this.responsible = new Reference();
            }
        }
        return this.responsible;
    }

    public boolean hasResponsible() {
        return this.responsible != null && !this.responsible.isEmpty();
    }

    public MessageHeader setResponsible(Reference value) {
        this.responsible = value;
        return this;
    }

    public Resource getResponsibleTarget() {
        return this.responsibleTarget;
    }

    public MessageHeader setResponsibleTarget(Resource value) {
        this.responsibleTarget = value;
        return this;
    }

    public CodeableConcept getReason() {
        if (this.reason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.reason");
            }
            if (Configuration.doAutoCreate()) {
                this.reason = new CodeableConcept();
            }
        }
        return this.reason;
    }

    public boolean hasReason() {
        return this.reason != null && !this.reason.isEmpty();
    }

    public MessageHeader setReason(CodeableConcept value) {
        this.reason = value;
        return this;
    }

    public MessageHeaderResponseComponent getResponse() {
        if (this.response == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.response");
            }
            if (Configuration.doAutoCreate()) {
                this.response = new MessageHeaderResponseComponent();
            }
        }
        return this.response;
    }

    public boolean hasResponse() {
        return this.response != null && !this.response.isEmpty();
    }

    public MessageHeader setResponse(MessageHeaderResponseComponent value) {
        this.response = value;
        return this;
    }

    public List<Reference> getFocus() {
        if (this.focus == null) {
            this.focus = new ArrayList<Reference>();
        }
        return this.focus;
    }

    public MessageHeader setFocus(List<Reference> theFocus) {
        this.focus = theFocus;
        return this;
    }

    public boolean hasFocus() {
        if (this.focus == null) {
            return false;
        }
        for (Reference item : this.focus) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addFocus() {
        Reference t = new Reference();
        if (this.focus == null) {
            this.focus = new ArrayList<Reference>();
        }
        this.focus.add(t);
        return t;
    }

    public MessageHeader addFocus(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.focus == null) {
            this.focus = new ArrayList<Reference>();
        }
        this.focus.add(t);
        return this;
    }

    public Reference getFocusFirstRep() {
        if (this.getFocus().isEmpty()) {
            this.addFocus();
        }
        return this.getFocus().get(0);
    }

    @Deprecated
    public List<Resource> getFocusTarget() {
        if (this.focusTarget == null) {
            this.focusTarget = new ArrayList<Resource>();
        }
        return this.focusTarget;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_EVENT, "Coding", "Code that identifies the event this message represents and connects it with its definition. Events defined as part of the FHIR specification have the system value \"http://hl7.org/fhir/message-events\".", 0, 1, this.event));
        children.add(new Property(SP_DESTINATION, "", "The destination application which the message is intended for.", 0, Integer.MAX_VALUE, this.destination));
        children.add(new Property(SP_RECEIVER, "Reference(Practitioner|Organization)", "Allows data conveyed by a message to be addressed to a particular person or department when routing to a specific application isn't sufficient.", 0, 1, this.receiver));
        children.add(new Property(SP_SENDER, "Reference(Practitioner|Organization)", "Identifies the sending system to allow the use of a trust relationship.", 0, 1, this.sender));
        children.add(new Property(SP_TIMESTAMP, "instant", "The time that the message was sent.", 0, 1, this.timestamp));
        children.add(new Property(SP_ENTERER, "Reference(Practitioner)", "The person or device that performed the data entry leading to this message. When there is more than one candidate, pick the most proximal to the message. Can provide other enterers in extensions.", 0, 1, this.enterer));
        children.add(new Property(SP_AUTHOR, "Reference(Practitioner)", "The logical author of the message - the person or device that decided the described event should happen. When there is more than one candidate, pick the most proximal to the MessageHeader. Can provide other authors in extensions.", 0, 1, this.author));
        children.add(new Property(SP_SOURCE, "", "The source application from which this message originated.", 0, 1, this.source));
        children.add(new Property(SP_RESPONSIBLE, "Reference(Practitioner|Organization)", "The person or organization that accepts overall responsibility for the contents of the message. The implication is that the message event happened under the policies of the responsible party.", 0, 1, this.responsible));
        children.add(new Property("reason", "CodeableConcept", "Coded indication of the cause for the event - indicates  a reason for the occurrence of the event that is a focus of this message.", 0, 1, this.reason));
        children.add(new Property("response", "", "Information about the message that this message is a response to.  Only present if this message is a response.", 0, 1, this.response));
        children.add(new Property(SP_FOCUS, "Reference(Any)", "The actual data of the message - a reference to the root/focus class of the event.", 0, Integer.MAX_VALUE, this.focus));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 96891546: {
                return new Property(SP_EVENT, "Coding", "Code that identifies the event this message represents and connects it with its definition. Events defined as part of the FHIR specification have the system value \"http://hl7.org/fhir/message-events\".", 0, 1, this.event);
            }
            case -1429847026: {
                return new Property(SP_DESTINATION, "", "The destination application which the message is intended for.", 0, Integer.MAX_VALUE, this.destination);
            }
            case -808719889: {
                return new Property(SP_RECEIVER, "Reference(Practitioner|Organization)", "Allows data conveyed by a message to be addressed to a particular person or department when routing to a specific application isn't sufficient.", 0, 1, this.receiver);
            }
            case -905962955: {
                return new Property(SP_SENDER, "Reference(Practitioner|Organization)", "Identifies the sending system to allow the use of a trust relationship.", 0, 1, this.sender);
            }
            case 55126294: {
                return new Property(SP_TIMESTAMP, "instant", "The time that the message was sent.", 0, 1, this.timestamp);
            }
            case -1591951995: {
                return new Property(SP_ENTERER, "Reference(Practitioner)", "The person or device that performed the data entry leading to this message. When there is more than one candidate, pick the most proximal to the message. Can provide other enterers in extensions.", 0, 1, this.enterer);
            }
            case -1406328437: {
                return new Property(SP_AUTHOR, "Reference(Practitioner)", "The logical author of the message - the person or device that decided the described event should happen. When there is more than one candidate, pick the most proximal to the MessageHeader. Can provide other authors in extensions.", 0, 1, this.author);
            }
            case -896505829: {
                return new Property(SP_SOURCE, "", "The source application from which this message originated.", 0, 1, this.source);
            }
            case 1847674614: {
                return new Property(SP_RESPONSIBLE, "Reference(Practitioner|Organization)", "The person or organization that accepts overall responsibility for the contents of the message. The implication is that the message event happened under the policies of the responsible party.", 0, 1, this.responsible);
            }
            case -934964668: {
                return new Property("reason", "CodeableConcept", "Coded indication of the cause for the event - indicates  a reason for the occurrence of the event that is a focus of this message.", 0, 1, this.reason);
            }
            case -340323263: {
                return new Property("response", "", "Information about the message that this message is a response to.  Only present if this message is a response.", 0, 1, this.response);
            }
            case 97604824: {
                return new Property(SP_FOCUS, "Reference(Any)", "The actual data of the message - a reference to the root/focus class of the event.", 0, Integer.MAX_VALUE, this.focus);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 96891546: {
                Base[] baseArray;
                if (this.event == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.event;
                }
                return baseArray;
            }
            case -1429847026: {
                return this.destination == null ? new Base[]{} : this.destination.toArray(new Base[this.destination.size()]);
            }
            case -808719889: {
                Base[] baseArray;
                if (this.receiver == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.receiver;
                }
                return baseArray;
            }
            case -905962955: {
                Base[] baseArray;
                if (this.sender == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.sender;
                }
                return baseArray;
            }
            case 55126294: {
                Base[] baseArray;
                if (this.timestamp == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.timestamp;
                }
                return baseArray;
            }
            case -1591951995: {
                Base[] baseArray;
                if (this.enterer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.enterer;
                }
                return baseArray;
            }
            case -1406328437: {
                Base[] baseArray;
                if (this.author == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.author;
                }
                return baseArray;
            }
            case -896505829: {
                Base[] baseArray;
                if (this.source == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.source;
                }
                return baseArray;
            }
            case 1847674614: {
                Base[] baseArray;
                if (this.responsible == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.responsible;
                }
                return baseArray;
            }
            case -934964668: {
                Base[] baseArray;
                if (this.reason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.reason;
                }
                return baseArray;
            }
            case -340323263: {
                Base[] baseArray;
                if (this.response == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.response;
                }
                return baseArray;
            }
            case 97604824: {
                return this.focus == null ? new Base[]{} : this.focus.toArray(new Base[this.focus.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 96891546: {
                this.event = this.castToCoding(value);
                return value;
            }
            case -1429847026: {
                this.getDestination().add((MessageDestinationComponent)value);
                return value;
            }
            case -808719889: {
                this.receiver = this.castToReference(value);
                return value;
            }
            case -905962955: {
                this.sender = this.castToReference(value);
                return value;
            }
            case 55126294: {
                this.timestamp = this.castToInstant(value);
                return value;
            }
            case -1591951995: {
                this.enterer = this.castToReference(value);
                return value;
            }
            case -1406328437: {
                this.author = this.castToReference(value);
                return value;
            }
            case -896505829: {
                this.source = (MessageSourceComponent)value;
                return value;
            }
            case 1847674614: {
                this.responsible = this.castToReference(value);
                return value;
            }
            case -934964668: {
                this.reason = this.castToCodeableConcept(value);
                return value;
            }
            case -340323263: {
                this.response = (MessageHeaderResponseComponent)value;
                return value;
            }
            case 97604824: {
                this.getFocus().add(this.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_EVENT)) {
            this.event = this.castToCoding(value);
        } else if (name.equals(SP_DESTINATION)) {
            this.getDestination().add((MessageDestinationComponent)value);
        } else if (name.equals(SP_RECEIVER)) {
            this.receiver = this.castToReference(value);
        } else if (name.equals(SP_SENDER)) {
            this.sender = this.castToReference(value);
        } else if (name.equals(SP_TIMESTAMP)) {
            this.timestamp = this.castToInstant(value);
        } else if (name.equals(SP_ENTERER)) {
            this.enterer = this.castToReference(value);
        } else if (name.equals(SP_AUTHOR)) {
            this.author = this.castToReference(value);
        } else if (name.equals(SP_SOURCE)) {
            this.source = (MessageSourceComponent)value;
        } else if (name.equals(SP_RESPONSIBLE)) {
            this.responsible = this.castToReference(value);
        } else if (name.equals("reason")) {
            this.reason = this.castToCodeableConcept(value);
        } else if (name.equals("response")) {
            this.response = (MessageHeaderResponseComponent)value;
        } else if (name.equals(SP_FOCUS)) {
            this.getFocus().add(this.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 96891546: {
                return this.getEvent();
            }
            case -1429847026: {
                return this.addDestination();
            }
            case -808719889: {
                return this.getReceiver();
            }
            case -905962955: {
                return this.getSender();
            }
            case 55126294: {
                return this.getTimestampElement();
            }
            case -1591951995: {
                return this.getEnterer();
            }
            case -1406328437: {
                return this.getAuthor();
            }
            case -896505829: {
                return this.getSource();
            }
            case 1847674614: {
                return this.getResponsible();
            }
            case -934964668: {
                return this.getReason();
            }
            case -340323263: {
                return this.getResponse();
            }
            case 97604824: {
                return this.addFocus();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 96891546: {
                return new String[]{"Coding"};
            }
            case -1429847026: {
                return new String[0];
            }
            case -808719889: {
                return new String[]{"Reference"};
            }
            case -905962955: {
                return new String[]{"Reference"};
            }
            case 55126294: {
                return new String[]{"instant"};
            }
            case -1591951995: {
                return new String[]{"Reference"};
            }
            case -1406328437: {
                return new String[]{"Reference"};
            }
            case -896505829: {
                return new String[0];
            }
            case 1847674614: {
                return new String[]{"Reference"};
            }
            case -934964668: {
                return new String[]{"CodeableConcept"};
            }
            case -340323263: {
                return new String[0];
            }
            case 97604824: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_EVENT)) {
            this.event = new Coding();
            return this.event;
        }
        if (name.equals(SP_DESTINATION)) {
            return this.addDestination();
        }
        if (name.equals(SP_RECEIVER)) {
            this.receiver = new Reference();
            return this.receiver;
        }
        if (name.equals(SP_SENDER)) {
            this.sender = new Reference();
            return this.sender;
        }
        if (name.equals(SP_TIMESTAMP)) {
            throw new FHIRException("Cannot call addChild on a primitive type MessageHeader.timestamp");
        }
        if (name.equals(SP_ENTERER)) {
            this.enterer = new Reference();
            return this.enterer;
        }
        if (name.equals(SP_AUTHOR)) {
            this.author = new Reference();
            return this.author;
        }
        if (name.equals(SP_SOURCE)) {
            this.source = new MessageSourceComponent();
            return this.source;
        }
        if (name.equals(SP_RESPONSIBLE)) {
            this.responsible = new Reference();
            return this.responsible;
        }
        if (name.equals("reason")) {
            this.reason = new CodeableConcept();
            return this.reason;
        }
        if (name.equals("response")) {
            this.response = new MessageHeaderResponseComponent();
            return this.response;
        }
        if (name.equals(SP_FOCUS)) {
            return this.addFocus();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MessageHeader";
    }

    @Override
    public MessageHeader copy() {
        MessageHeader dst = new MessageHeader();
        this.copyValues(dst);
        Coding coding = dst.event = this.event == null ? null : this.event.copy();
        if (this.destination != null) {
            dst.destination = new ArrayList<MessageDestinationComponent>();
            for (MessageDestinationComponent messageDestinationComponent : this.destination) {
                dst.destination.add(messageDestinationComponent.copy());
            }
        }
        dst.receiver = this.receiver == null ? null : this.receiver.copy();
        dst.sender = this.sender == null ? null : this.sender.copy();
        dst.timestamp = this.timestamp == null ? null : this.timestamp.copy();
        dst.enterer = this.enterer == null ? null : this.enterer.copy();
        dst.author = this.author == null ? null : this.author.copy();
        dst.source = this.source == null ? null : this.source.copy();
        dst.responsible = this.responsible == null ? null : this.responsible.copy();
        dst.reason = this.reason == null ? null : this.reason.copy();
        MessageHeaderResponseComponent messageHeaderResponseComponent = dst.response = this.response == null ? null : this.response.copy();
        if (this.focus != null) {
            dst.focus = new ArrayList<Reference>();
            for (Reference reference : this.focus) {
                dst.focus.add(reference.copy());
            }
        }
        return dst;
    }

    protected MessageHeader typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MessageHeader)) {
            return false;
        }
        MessageHeader o = (MessageHeader)other_;
        return MessageHeader.compareDeep(this.event, o.event, true) && MessageHeader.compareDeep(this.destination, o.destination, true) && MessageHeader.compareDeep(this.receiver, o.receiver, true) && MessageHeader.compareDeep(this.sender, o.sender, true) && MessageHeader.compareDeep(this.timestamp, o.timestamp, true) && MessageHeader.compareDeep(this.enterer, o.enterer, true) && MessageHeader.compareDeep(this.author, o.author, true) && MessageHeader.compareDeep(this.source, o.source, true) && MessageHeader.compareDeep(this.responsible, o.responsible, true) && MessageHeader.compareDeep(this.reason, o.reason, true) && MessageHeader.compareDeep(this.response, o.response, true) && MessageHeader.compareDeep(this.focus, o.focus, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MessageHeader)) {
            return false;
        }
        MessageHeader o = (MessageHeader)other_;
        return MessageHeader.compareValues(this.timestamp, o.timestamp, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.event, this.destination, this.receiver, this.sender, this.timestamp, this.enterer, this.author, this.source, this.responsible, this.reason, this.response, this.focus});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MessageHeader;
    }

    @Block
    public static class MessageHeaderResponseComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Id of original message", formalDefinition="The MessageHeader.id of the message to which this message is a response.")
        protected IdType identifier;
        @Child(name="code", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="ok | transient-error | fatal-error", formalDefinition="Code that identifies the type of response to the message - whether it was successful or not, and whether it should be resent or not.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/response-code")
        protected Enumeration<ResponseType> code;
        @Child(name="details", type={OperationOutcome.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Specific list of hints/warnings/errors", formalDefinition="Full details of any issues found in the message.")
        protected Reference details;
        protected OperationOutcome detailsTarget;
        private static final long serialVersionUID = -1008716838L;

        public MessageHeaderResponseComponent() {
        }

        public MessageHeaderResponseComponent(IdType identifier, Enumeration<ResponseType> code) {
            this.identifier = identifier;
            this.code = code;
        }

        public IdType getIdentifierElement() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageHeaderResponseComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new IdType();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifierElement() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public MessageHeaderResponseComponent setIdentifierElement(IdType value) {
            this.identifier = value;
            return this;
        }

        public String getIdentifier() {
            return this.identifier == null ? null : this.identifier.getValue();
        }

        public MessageHeaderResponseComponent setIdentifier(String value) {
            if (this.identifier == null) {
                this.identifier = new IdType();
            }
            this.identifier.setValue(value);
            return this;
        }

        public Enumeration<ResponseType> getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageHeaderResponseComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Enumeration<ResponseType>(new ResponseTypeEnumFactory());
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public MessageHeaderResponseComponent setCodeElement(Enumeration<ResponseType> value) {
            this.code = value;
            return this;
        }

        public ResponseType getCode() {
            return this.code == null ? null : (ResponseType)((Object)this.code.getValue());
        }

        public MessageHeaderResponseComponent setCode(ResponseType value) {
            if (this.code == null) {
                this.code = new Enumeration<ResponseType>(new ResponseTypeEnumFactory());
            }
            this.code.setValue((Object)value);
            return this;
        }

        public Reference getDetails() {
            if (this.details == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageHeaderResponseComponent.details");
                }
                if (Configuration.doAutoCreate()) {
                    this.details = new Reference();
                }
            }
            return this.details;
        }

        public boolean hasDetails() {
            return this.details != null && !this.details.isEmpty();
        }

        public MessageHeaderResponseComponent setDetails(Reference value) {
            this.details = value;
            return this;
        }

        public OperationOutcome getDetailsTarget() {
            if (this.detailsTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageHeaderResponseComponent.details");
                }
                if (Configuration.doAutoCreate()) {
                    this.detailsTarget = new OperationOutcome();
                }
            }
            return this.detailsTarget;
        }

        public MessageHeaderResponseComponent setDetailsTarget(OperationOutcome value) {
            this.detailsTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("identifier", "id", "The MessageHeader.id of the message to which this message is a response.", 0, 1, this.identifier));
            children.add(new Property(MessageHeader.SP_CODE, MessageHeader.SP_CODE, "Code that identifies the type of response to the message - whether it was successful or not, and whether it should be resent or not.", 0, 1, this.code));
            children.add(new Property("details", "Reference(OperationOutcome)", "Full details of any issues found in the message.", 0, 1, this.details));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property("identifier", "id", "The MessageHeader.id of the message to which this message is a response.", 0, 1, this.identifier);
                }
                case 3059181: {
                    return new Property(MessageHeader.SP_CODE, MessageHeader.SP_CODE, "Code that identifies the type of response to the message - whether it was successful or not, and whether it should be resent or not.", 0, 1, this.code);
                }
                case 1557721666: {
                    return new Property("details", "Reference(OperationOutcome)", "Full details of any issues found in the message.", 0, 1, this.details);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
                case 1557721666: {
                    Base[] baseArray;
                    if (this.details == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.details;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.identifier = this.castToId(value);
                    return value;
                }
                case 3059181: {
                    value = new ResponseTypeEnumFactory().fromType(this.castToCode(value));
                    this.code = value;
                    return value;
                }
                case 1557721666: {
                    this.details = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("identifier")) {
                this.identifier = this.castToId(value);
            } else if (name.equals(MessageHeader.SP_CODE)) {
                value = new ResponseTypeEnumFactory().fromType(this.castToCode(value));
                this.code = value;
            } else if (name.equals("details")) {
                this.details = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.getIdentifierElement();
                }
                case 3059181: {
                    return this.getCodeElement();
                }
                case 1557721666: {
                    return this.getDetails();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"id"};
                }
                case 3059181: {
                    return new String[]{MessageHeader.SP_CODE};
                }
                case 1557721666: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("identifier")) {
                throw new FHIRException("Cannot call addChild on a primitive type MessageHeader.identifier");
            }
            if (name.equals(MessageHeader.SP_CODE)) {
                throw new FHIRException("Cannot call addChild on a primitive type MessageHeader.code");
            }
            if (name.equals("details")) {
                this.details = new Reference();
                return this.details;
            }
            return super.addChild(name);
        }

        @Override
        public MessageHeaderResponseComponent copy() {
            MessageHeaderResponseComponent dst = new MessageHeaderResponseComponent();
            this.copyValues(dst);
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.code = this.code == null ? null : this.code.copy();
            dst.details = this.details == null ? null : this.details.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MessageHeaderResponseComponent)) {
                return false;
            }
            MessageHeaderResponseComponent o = (MessageHeaderResponseComponent)other_;
            return MessageHeaderResponseComponent.compareDeep(this.identifier, o.identifier, true) && MessageHeaderResponseComponent.compareDeep(this.code, o.code, true) && MessageHeaderResponseComponent.compareDeep(this.details, o.details, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MessageHeaderResponseComponent)) {
                return false;
            }
            MessageHeaderResponseComponent o = (MessageHeaderResponseComponent)other_;
            return MessageHeaderResponseComponent.compareValues(this.identifier, o.identifier, true) && MessageHeaderResponseComponent.compareValues(this.code, o.code, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.identifier, this.code, this.details});
        }

        @Override
        public String fhirType() {
            return "MessageHeader.response";
        }
    }

    @Block
    public static class MessageSourceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of system", formalDefinition="Human-readable name for the source system.")
        protected StringType name;
        @Child(name="software", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of software running the system", formalDefinition="May include configuration or other information useful in debugging.")
        protected StringType software;
        @Child(name="version", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Version of software running", formalDefinition="Can convey versions of multiple systems in situations where a message passes through multiple hands.")
        protected StringType version;
        @Child(name="contact", type={ContactPoint.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Human contact for problems", formalDefinition="An e-mail, phone, website or other contact point to use to resolve issues with message communications.")
        protected ContactPoint contact;
        @Child(name="endpoint", type={UriType.class}, order=5, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Actual message source address or id", formalDefinition="Identifies the routing target to send acknowledgements to.")
        protected UriType endpoint;
        private static final long serialVersionUID = -115878196L;

        public MessageSourceComponent() {
        }

        public MessageSourceComponent(UriType endpoint) {
            this.endpoint = endpoint;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageSourceComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public MessageSourceComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public MessageSourceComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getSoftwareElement() {
            if (this.software == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageSourceComponent.software");
                }
                if (Configuration.doAutoCreate()) {
                    this.software = new StringType();
                }
            }
            return this.software;
        }

        public boolean hasSoftwareElement() {
            return this.software != null && !this.software.isEmpty();
        }

        public boolean hasSoftware() {
            return this.software != null && !this.software.isEmpty();
        }

        public MessageSourceComponent setSoftwareElement(StringType value) {
            this.software = value;
            return this;
        }

        public String getSoftware() {
            return this.software == null ? null : (String)this.software.getValue();
        }

        public MessageSourceComponent setSoftware(String value) {
            if (Utilities.noString((String)value)) {
                this.software = null;
            } else {
                if (this.software == null) {
                    this.software = new StringType();
                }
                this.software.setValue(value);
            }
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageSourceComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public MessageSourceComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public MessageSourceComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        public ContactPoint getContact() {
            if (this.contact == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageSourceComponent.contact");
                }
                if (Configuration.doAutoCreate()) {
                    this.contact = new ContactPoint();
                }
            }
            return this.contact;
        }

        public boolean hasContact() {
            return this.contact != null && !this.contact.isEmpty();
        }

        public MessageSourceComponent setContact(ContactPoint value) {
            this.contact = value;
            return this;
        }

        public UriType getEndpointElement() {
            if (this.endpoint == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageSourceComponent.endpoint");
                }
                if (Configuration.doAutoCreate()) {
                    this.endpoint = new UriType();
                }
            }
            return this.endpoint;
        }

        public boolean hasEndpointElement() {
            return this.endpoint != null && !this.endpoint.isEmpty();
        }

        public boolean hasEndpoint() {
            return this.endpoint != null && !this.endpoint.isEmpty();
        }

        public MessageSourceComponent setEndpointElement(UriType value) {
            this.endpoint = value;
            return this;
        }

        public String getEndpoint() {
            return this.endpoint == null ? null : (String)this.endpoint.getValue();
        }

        public MessageSourceComponent setEndpoint(String value) {
            if (this.endpoint == null) {
                this.endpoint = new UriType();
            }
            this.endpoint.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("name", "string", "Human-readable name for the source system.", 0, 1, this.name));
            children.add(new Property("software", "string", "May include configuration or other information useful in debugging.", 0, 1, this.software));
            children.add(new Property("version", "string", "Can convey versions of multiple systems in situations where a message passes through multiple hands.", 0, 1, this.version));
            children.add(new Property("contact", "ContactPoint", "An e-mail, phone, website or other contact point to use to resolve issues with message communications.", 0, 1, this.contact));
            children.add(new Property("endpoint", "uri", "Identifies the routing target to send acknowledgements to.", 0, 1, this.endpoint));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property("name", "string", "Human-readable name for the source system.", 0, 1, this.name);
                }
                case 1319330215: {
                    return new Property("software", "string", "May include configuration or other information useful in debugging.", 0, 1, this.software);
                }
                case 351608024: {
                    return new Property("version", "string", "Can convey versions of multiple systems in situations where a message passes through multiple hands.", 0, 1, this.version);
                }
                case 951526432: {
                    return new Property("contact", "ContactPoint", "An e-mail, phone, website or other contact point to use to resolve issues with message communications.", 0, 1, this.contact);
                }
                case 1741102485: {
                    return new Property("endpoint", "uri", "Identifies the routing target to send acknowledgements to.", 0, 1, this.endpoint);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 1319330215: {
                    Base[] baseArray;
                    if (this.software == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.software;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.version;
                    }
                    return baseArray;
                }
                case 951526432: {
                    Base[] baseArray;
                    if (this.contact == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.contact;
                    }
                    return baseArray;
                }
                case 1741102485: {
                    Base[] baseArray;
                    if (this.endpoint == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.endpoint;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case 1319330215: {
                    this.software = this.castToString(value);
                    return value;
                }
                case 351608024: {
                    this.version = this.castToString(value);
                    return value;
                }
                case 951526432: {
                    this.contact = this.castToContactPoint(value);
                    return value;
                }
                case 1741102485: {
                    this.endpoint = this.castToUri(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("software")) {
                this.software = this.castToString(value);
            } else if (name.equals("version")) {
                this.version = this.castToString(value);
            } else if (name.equals("contact")) {
                this.contact = this.castToContactPoint(value);
            } else if (name.equals("endpoint")) {
                this.endpoint = this.castToUri(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 1319330215: {
                    return this.getSoftwareElement();
                }
                case 351608024: {
                    return this.getVersionElement();
                }
                case 951526432: {
                    return this.getContact();
                }
                case 1741102485: {
                    return this.getEndpointElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 1319330215: {
                    return new String[]{"string"};
                }
                case 351608024: {
                    return new String[]{"string"};
                }
                case 951526432: {
                    return new String[]{"ContactPoint"};
                }
                case 1741102485: {
                    return new String[]{"uri"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type MessageHeader.name");
            }
            if (name.equals("software")) {
                throw new FHIRException("Cannot call addChild on a primitive type MessageHeader.software");
            }
            if (name.equals("version")) {
                throw new FHIRException("Cannot call addChild on a primitive type MessageHeader.version");
            }
            if (name.equals("contact")) {
                this.contact = new ContactPoint();
                return this.contact;
            }
            if (name.equals("endpoint")) {
                throw new FHIRException("Cannot call addChild on a primitive type MessageHeader.endpoint");
            }
            return super.addChild(name);
        }

        @Override
        public MessageSourceComponent copy() {
            MessageSourceComponent dst = new MessageSourceComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.software = this.software == null ? null : this.software.copy();
            dst.version = this.version == null ? null : this.version.copy();
            dst.contact = this.contact == null ? null : this.contact.copy();
            dst.endpoint = this.endpoint == null ? null : this.endpoint.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MessageSourceComponent)) {
                return false;
            }
            MessageSourceComponent o = (MessageSourceComponent)other_;
            return MessageSourceComponent.compareDeep(this.name, o.name, true) && MessageSourceComponent.compareDeep(this.software, o.software, true) && MessageSourceComponent.compareDeep(this.version, o.version, true) && MessageSourceComponent.compareDeep(this.contact, o.contact, true) && MessageSourceComponent.compareDeep(this.endpoint, o.endpoint, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MessageSourceComponent)) {
                return false;
            }
            MessageSourceComponent o = (MessageSourceComponent)other_;
            return MessageSourceComponent.compareValues(this.name, o.name, true) && MessageSourceComponent.compareValues(this.software, o.software, true) && MessageSourceComponent.compareValues(this.version, o.version, true) && MessageSourceComponent.compareValues(this.endpoint, o.endpoint, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.software, this.version, this.contact, this.endpoint});
        }

        @Override
        public String fhirType() {
            return "MessageHeader.source";
        }
    }

    @Block
    public static class MessageDestinationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of system", formalDefinition="Human-readable name for the target system.")
        protected StringType name;
        @Child(name="target", type={Device.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Particular delivery destination within the destination", formalDefinition="Identifies the target end system in situations where the initial message transmission is to an intermediary system.")
        protected Reference target;
        protected Device targetTarget;
        @Child(name="endpoint", type={UriType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Actual destination address or id", formalDefinition="Indicates where the message should be routed to.")
        protected UriType endpoint;
        private static final long serialVersionUID = -2097633309L;

        public MessageDestinationComponent() {
        }

        public MessageDestinationComponent(UriType endpoint) {
            this.endpoint = endpoint;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageDestinationComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public MessageDestinationComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public MessageDestinationComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public Reference getTarget() {
            if (this.target == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageDestinationComponent.target");
                }
                if (Configuration.doAutoCreate()) {
                    this.target = new Reference();
                }
            }
            return this.target;
        }

        public boolean hasTarget() {
            return this.target != null && !this.target.isEmpty();
        }

        public MessageDestinationComponent setTarget(Reference value) {
            this.target = value;
            return this;
        }

        public Device getTargetTarget() {
            if (this.targetTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageDestinationComponent.target");
                }
                if (Configuration.doAutoCreate()) {
                    this.targetTarget = new Device();
                }
            }
            return this.targetTarget;
        }

        public MessageDestinationComponent setTargetTarget(Device value) {
            this.targetTarget = value;
            return this;
        }

        public UriType getEndpointElement() {
            if (this.endpoint == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageDestinationComponent.endpoint");
                }
                if (Configuration.doAutoCreate()) {
                    this.endpoint = new UriType();
                }
            }
            return this.endpoint;
        }

        public boolean hasEndpointElement() {
            return this.endpoint != null && !this.endpoint.isEmpty();
        }

        public boolean hasEndpoint() {
            return this.endpoint != null && !this.endpoint.isEmpty();
        }

        public MessageDestinationComponent setEndpointElement(UriType value) {
            this.endpoint = value;
            return this;
        }

        public String getEndpoint() {
            return this.endpoint == null ? null : (String)this.endpoint.getValue();
        }

        public MessageDestinationComponent setEndpoint(String value) {
            if (this.endpoint == null) {
                this.endpoint = new UriType();
            }
            this.endpoint.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("name", "string", "Human-readable name for the target system.", 0, 1, this.name));
            children.add(new Property(MessageHeader.SP_TARGET, "Reference(Device)", "Identifies the target end system in situations where the initial message transmission is to an intermediary system.", 0, 1, this.target));
            children.add(new Property("endpoint", "uri", "Indicates where the message should be routed to.", 0, 1, this.endpoint));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property("name", "string", "Human-readable name for the target system.", 0, 1, this.name);
                }
                case -880905839: {
                    return new Property(MessageHeader.SP_TARGET, "Reference(Device)", "Identifies the target end system in situations where the initial message transmission is to an intermediary system.", 0, 1, this.target);
                }
                case 1741102485: {
                    return new Property("endpoint", "uri", "Indicates where the message should be routed to.", 0, 1, this.endpoint);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -880905839: {
                    Base[] baseArray;
                    if (this.target == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.target;
                    }
                    return baseArray;
                }
                case 1741102485: {
                    Base[] baseArray;
                    if (this.endpoint == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.endpoint;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case -880905839: {
                    this.target = this.castToReference(value);
                    return value;
                }
                case 1741102485: {
                    this.endpoint = this.castToUri(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals(MessageHeader.SP_TARGET)) {
                this.target = this.castToReference(value);
            } else if (name.equals("endpoint")) {
                this.endpoint = this.castToUri(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case -880905839: {
                    return this.getTarget();
                }
                case 1741102485: {
                    return this.getEndpointElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case -880905839: {
                    return new String[]{"Reference"};
                }
                case 1741102485: {
                    return new String[]{"uri"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type MessageHeader.name");
            }
            if (name.equals(MessageHeader.SP_TARGET)) {
                this.target = new Reference();
                return this.target;
            }
            if (name.equals("endpoint")) {
                throw new FHIRException("Cannot call addChild on a primitive type MessageHeader.endpoint");
            }
            return super.addChild(name);
        }

        @Override
        public MessageDestinationComponent copy() {
            MessageDestinationComponent dst = new MessageDestinationComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.target = this.target == null ? null : this.target.copy();
            dst.endpoint = this.endpoint == null ? null : this.endpoint.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MessageDestinationComponent)) {
                return false;
            }
            MessageDestinationComponent o = (MessageDestinationComponent)other_;
            return MessageDestinationComponent.compareDeep(this.name, o.name, true) && MessageDestinationComponent.compareDeep(this.target, o.target, true) && MessageDestinationComponent.compareDeep(this.endpoint, o.endpoint, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MessageDestinationComponent)) {
                return false;
            }
            MessageDestinationComponent o = (MessageDestinationComponent)other_;
            return MessageDestinationComponent.compareValues(this.name, o.name, true) && MessageDestinationComponent.compareValues(this.endpoint, o.endpoint, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.target, this.endpoint});
        }

        @Override
        public String fhirType() {
            return "MessageHeader.destination";
        }
    }

    public static class ResponseTypeEnumFactory
    implements EnumFactory<ResponseType> {
        @Override
        public ResponseType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("ok".equals(codeString)) {
                return ResponseType.OK;
            }
            if ("transient-error".equals(codeString)) {
                return ResponseType.TRANSIENTERROR;
            }
            if ("fatal-error".equals(codeString)) {
                return ResponseType.FATALERROR;
            }
            throw new IllegalArgumentException("Unknown ResponseType code '" + codeString + "'");
        }

        public Enumeration<ResponseType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ResponseType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("ok".equals(codeString)) {
                return new Enumeration<ResponseType>(this, ResponseType.OK);
            }
            if ("transient-error".equals(codeString)) {
                return new Enumeration<ResponseType>(this, ResponseType.TRANSIENTERROR);
            }
            if ("fatal-error".equals(codeString)) {
                return new Enumeration<ResponseType>(this, ResponseType.FATALERROR);
            }
            throw new FHIRException("Unknown ResponseType code '" + codeString + "'");
        }

        @Override
        public String toCode(ResponseType code) {
            if (code == ResponseType.OK) {
                return "ok";
            }
            if (code == ResponseType.TRANSIENTERROR) {
                return "transient-error";
            }
            if (code == ResponseType.FATALERROR) {
                return "fatal-error";
            }
            return "?";
        }

        @Override
        public String toSystem(ResponseType code) {
            return code.getSystem();
        }
    }

    public static enum ResponseType {
        OK,
        TRANSIENTERROR,
        FATALERROR,
        NULL;


        public static ResponseType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("ok".equals(codeString)) {
                return OK;
            }
            if ("transient-error".equals(codeString)) {
                return TRANSIENTERROR;
            }
            if ("fatal-error".equals(codeString)) {
                return FATALERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ResponseType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case OK: {
                    return "ok";
                }
                case TRANSIENTERROR: {
                    return "transient-error";
                }
                case FATALERROR: {
                    return "fatal-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case OK: {
                    return "http://hl7.org/fhir/response-code";
                }
                case TRANSIENTERROR: {
                    return "http://hl7.org/fhir/response-code";
                }
                case FATALERROR: {
                    return "http://hl7.org/fhir/response-code";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case OK: {
                    return "The message was accepted and processed without error.";
                }
                case TRANSIENTERROR: {
                    return "Some internal unexpected error occurred - wait and try again. Note - this is usually used for things like database unavailable, which may be expected to resolve, though human intervention may be required.";
                }
                case FATALERROR: {
                    return "The message was rejected because of a problem with the content. There is no point in re-sending without change. The response narrative SHALL describe the issue.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case OK: {
                    return "OK";
                }
                case TRANSIENTERROR: {
                    return "Transient Error";
                }
                case FATALERROR: {
                    return "Fatal Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

