/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.IntegerType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Quantity;
import org.hl7.fhir.dstu3.model.Range;
import org.hl7.fhir.dstu3.model.Ratio;
import org.hl7.fhir.dstu3.model.SimpleQuantity;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Timing;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="Dosage")
public class Dosage
extends Type
implements ICompositeType {
    @Child(name="sequence", type={IntegerType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The order of the dosage instructions", formalDefinition="Indicates the order in which the dosage instructions should be applied or interpreted.")
    protected IntegerType sequence;
    @Child(name="text", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Free text dosage instructions e.g. SIG", formalDefinition="Free text dosage instructions e.g. SIG.")
    protected StringType text;
    @Child(name="additionalInstruction", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Supplemental instruction - e.g. \"with meals\"", formalDefinition="Supplemental instruction - e.g. \"with meals\".")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/additional-instruction-codes")
    protected List<CodeableConcept> additionalInstruction;
    @Child(name="patientInstruction", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Patient or consumer oriented instructions", formalDefinition="Instructions in terms that are understood by the patient or consumer.")
    protected StringType patientInstruction;
    @Child(name="timing", type={Timing.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When medication should be administered", formalDefinition="When medication should be administered.")
    protected Timing timing;
    @Child(name="asNeeded", type={BooleanType.class, CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Take \"as needed\" (for x)", formalDefinition="Indicates whether the Medication is only taken when needed within a specific dosing schedule (Boolean option), or it indicates the precondition for taking the Medication (CodeableConcept).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-as-needed-reason")
    protected Type asNeeded;
    @Child(name="site", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Body site to administer to", formalDefinition="Body site to administer to.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/approach-site-codes")
    protected CodeableConcept site;
    @Child(name="route", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="How drug should enter body", formalDefinition="How drug should enter body.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/route-codes")
    protected CodeableConcept route;
    @Child(name="method", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Technique for administering medication", formalDefinition="Technique for administering medication.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/administration-method-codes")
    protected CodeableConcept method;
    @Child(name="dose", type={Range.class, SimpleQuantity.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Amount of medication per dose", formalDefinition="Amount of medication per dose.")
    protected Type dose;
    @Child(name="maxDosePerPeriod", type={Ratio.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Upper limit on medication per unit of time", formalDefinition="Upper limit on medication per unit of time.")
    protected Ratio maxDosePerPeriod;
    @Child(name="maxDosePerAdministration", type={SimpleQuantity.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Upper limit on medication per administration", formalDefinition="Upper limit on medication per administration.")
    protected SimpleQuantity maxDosePerAdministration;
    @Child(name="maxDosePerLifetime", type={SimpleQuantity.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Upper limit on medication per lifetime of the patient", formalDefinition="Upper limit on medication per lifetime of the patient.")
    protected SimpleQuantity maxDosePerLifetime;
    @Child(name="rate", type={Ratio.class, Range.class, SimpleQuantity.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Amount of medication per unit of time", formalDefinition="Amount of medication per unit of time.")
    protected Type rate;
    private static final long serialVersionUID = 70626458L;

    public IntegerType getSequenceElement() {
        if (this.sequence == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Dosage.sequence");
            }
            if (Configuration.doAutoCreate()) {
                this.sequence = new IntegerType();
            }
        }
        return this.sequence;
    }

    public boolean hasSequenceElement() {
        return this.sequence != null && !this.sequence.isEmpty();
    }

    public boolean hasSequence() {
        return this.sequence != null && !this.sequence.isEmpty();
    }

    public Dosage setSequenceElement(IntegerType value) {
        this.sequence = value;
        return this;
    }

    public int getSequence() {
        return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
    }

    public Dosage setSequence(int value) {
        if (this.sequence == null) {
            this.sequence = new IntegerType();
        }
        this.sequence.setValue((Object)value);
        return this;
    }

    public StringType getTextElement() {
        if (this.text == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Dosage.text");
            }
            if (Configuration.doAutoCreate()) {
                this.text = new StringType();
            }
        }
        return this.text;
    }

    public boolean hasTextElement() {
        return this.text != null && !this.text.isEmpty();
    }

    public boolean hasText() {
        return this.text != null && !this.text.isEmpty();
    }

    public Dosage setTextElement(StringType value) {
        this.text = value;
        return this;
    }

    public String getText() {
        return this.text == null ? null : (String)this.text.getValue();
    }

    public Dosage setText(String value) {
        if (Utilities.noString((String)value)) {
            this.text = null;
        } else {
            if (this.text == null) {
                this.text = new StringType();
            }
            this.text.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getAdditionalInstruction() {
        if (this.additionalInstruction == null) {
            this.additionalInstruction = new ArrayList<CodeableConcept>();
        }
        return this.additionalInstruction;
    }

    public Dosage setAdditionalInstruction(List<CodeableConcept> theAdditionalInstruction) {
        this.additionalInstruction = theAdditionalInstruction;
        return this;
    }

    public boolean hasAdditionalInstruction() {
        if (this.additionalInstruction == null) {
            return false;
        }
        for (CodeableConcept item : this.additionalInstruction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addAdditionalInstruction() {
        CodeableConcept t = new CodeableConcept();
        if (this.additionalInstruction == null) {
            this.additionalInstruction = new ArrayList<CodeableConcept>();
        }
        this.additionalInstruction.add(t);
        return t;
    }

    public Dosage addAdditionalInstruction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.additionalInstruction == null) {
            this.additionalInstruction = new ArrayList<CodeableConcept>();
        }
        this.additionalInstruction.add(t);
        return this;
    }

    public CodeableConcept getAdditionalInstructionFirstRep() {
        if (this.getAdditionalInstruction().isEmpty()) {
            this.addAdditionalInstruction();
        }
        return this.getAdditionalInstruction().get(0);
    }

    public StringType getPatientInstructionElement() {
        if (this.patientInstruction == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Dosage.patientInstruction");
            }
            if (Configuration.doAutoCreate()) {
                this.patientInstruction = new StringType();
            }
        }
        return this.patientInstruction;
    }

    public boolean hasPatientInstructionElement() {
        return this.patientInstruction != null && !this.patientInstruction.isEmpty();
    }

    public boolean hasPatientInstruction() {
        return this.patientInstruction != null && !this.patientInstruction.isEmpty();
    }

    public Dosage setPatientInstructionElement(StringType value) {
        this.patientInstruction = value;
        return this;
    }

    public String getPatientInstruction() {
        return this.patientInstruction == null ? null : (String)this.patientInstruction.getValue();
    }

    public Dosage setPatientInstruction(String value) {
        if (Utilities.noString((String)value)) {
            this.patientInstruction = null;
        } else {
            if (this.patientInstruction == null) {
                this.patientInstruction = new StringType();
            }
            this.patientInstruction.setValue(value);
        }
        return this;
    }

    public Timing getTiming() {
        if (this.timing == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Dosage.timing");
            }
            if (Configuration.doAutoCreate()) {
                this.timing = new Timing();
            }
        }
        return this.timing;
    }

    public boolean hasTiming() {
        return this.timing != null && !this.timing.isEmpty();
    }

    public Dosage setTiming(Timing value) {
        this.timing = value;
        return this;
    }

    public Type getAsNeeded() {
        return this.asNeeded;
    }

    public BooleanType getAsNeededBooleanType() throws FHIRException {
        if (this.asNeeded == null) {
            return null;
        }
        if (!(this.asNeeded instanceof BooleanType)) {
            throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.asNeeded.getClass().getName() + " was encountered");
        }
        return (BooleanType)this.asNeeded;
    }

    public boolean hasAsNeededBooleanType() {
        return this != null && this.asNeeded instanceof BooleanType;
    }

    public CodeableConcept getAsNeededCodeableConcept() throws FHIRException {
        if (this.asNeeded == null) {
            return null;
        }
        if (!(this.asNeeded instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.asNeeded.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.asNeeded;
    }

    public boolean hasAsNeededCodeableConcept() {
        return this != null && this.asNeeded instanceof CodeableConcept;
    }

    public boolean hasAsNeeded() {
        return this.asNeeded != null && !this.asNeeded.isEmpty();
    }

    public Dosage setAsNeeded(Type value) throws FHIRFormatError {
        if (value != null && !(value instanceof BooleanType) && !(value instanceof CodeableConcept)) {
            throw new FHIRFormatError("Not the right type for Dosage.asNeeded[x]: " + value.fhirType());
        }
        this.asNeeded = value;
        return this;
    }

    public CodeableConcept getSite() {
        if (this.site == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Dosage.site");
            }
            if (Configuration.doAutoCreate()) {
                this.site = new CodeableConcept();
            }
        }
        return this.site;
    }

    public boolean hasSite() {
        return this.site != null && !this.site.isEmpty();
    }

    public Dosage setSite(CodeableConcept value) {
        this.site = value;
        return this;
    }

    public CodeableConcept getRoute() {
        if (this.route == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Dosage.route");
            }
            if (Configuration.doAutoCreate()) {
                this.route = new CodeableConcept();
            }
        }
        return this.route;
    }

    public boolean hasRoute() {
        return this.route != null && !this.route.isEmpty();
    }

    public Dosage setRoute(CodeableConcept value) {
        this.route = value;
        return this;
    }

    public CodeableConcept getMethod() {
        if (this.method == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Dosage.method");
            }
            if (Configuration.doAutoCreate()) {
                this.method = new CodeableConcept();
            }
        }
        return this.method;
    }

    public boolean hasMethod() {
        return this.method != null && !this.method.isEmpty();
    }

    public Dosage setMethod(CodeableConcept value) {
        this.method = value;
        return this;
    }

    public Type getDose() {
        return this.dose;
    }

    public Range getDoseRange() throws FHIRException {
        if (this.dose == null) {
            return null;
        }
        if (!(this.dose instanceof Range)) {
            throw new FHIRException("Type mismatch: the type Range was expected, but " + this.dose.getClass().getName() + " was encountered");
        }
        return (Range)this.dose;
    }

    public boolean hasDoseRange() {
        return this != null && this.dose instanceof Range;
    }

    public SimpleQuantity getDoseSimpleQuantity() throws FHIRException {
        if (this.dose == null) {
            return null;
        }
        if (!(this.dose instanceof SimpleQuantity)) {
            throw new FHIRException("Type mismatch: the type SimpleQuantity was expected, but " + this.dose.getClass().getName() + " was encountered");
        }
        return (SimpleQuantity)this.dose;
    }

    public boolean hasDoseSimpleQuantity() {
        return this != null && this.dose instanceof SimpleQuantity;
    }

    public boolean hasDose() {
        return this.dose != null && !this.dose.isEmpty();
    }

    public Dosage setDose(Type value) throws FHIRFormatError {
        if (value != null && !(value instanceof Range) && !(value instanceof Quantity)) {
            throw new FHIRFormatError("Not the right type for Dosage.dose[x]: " + value.fhirType());
        }
        this.dose = value;
        return this;
    }

    public Ratio getMaxDosePerPeriod() {
        if (this.maxDosePerPeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Dosage.maxDosePerPeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.maxDosePerPeriod = new Ratio();
            }
        }
        return this.maxDosePerPeriod;
    }

    public boolean hasMaxDosePerPeriod() {
        return this.maxDosePerPeriod != null && !this.maxDosePerPeriod.isEmpty();
    }

    public Dosage setMaxDosePerPeriod(Ratio value) {
        this.maxDosePerPeriod = value;
        return this;
    }

    public SimpleQuantity getMaxDosePerAdministration() {
        if (this.maxDosePerAdministration == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Dosage.maxDosePerAdministration");
            }
            if (Configuration.doAutoCreate()) {
                this.maxDosePerAdministration = new SimpleQuantity();
            }
        }
        return this.maxDosePerAdministration;
    }

    public boolean hasMaxDosePerAdministration() {
        return this.maxDosePerAdministration != null && !this.maxDosePerAdministration.isEmpty();
    }

    public Dosage setMaxDosePerAdministration(SimpleQuantity value) {
        this.maxDosePerAdministration = value;
        return this;
    }

    public SimpleQuantity getMaxDosePerLifetime() {
        if (this.maxDosePerLifetime == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Dosage.maxDosePerLifetime");
            }
            if (Configuration.doAutoCreate()) {
                this.maxDosePerLifetime = new SimpleQuantity();
            }
        }
        return this.maxDosePerLifetime;
    }

    public boolean hasMaxDosePerLifetime() {
        return this.maxDosePerLifetime != null && !this.maxDosePerLifetime.isEmpty();
    }

    public Dosage setMaxDosePerLifetime(SimpleQuantity value) {
        this.maxDosePerLifetime = value;
        return this;
    }

    public Type getRate() {
        return this.rate;
    }

    public Ratio getRateRatio() throws FHIRException {
        if (this.rate == null) {
            return null;
        }
        if (!(this.rate instanceof Ratio)) {
            throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.rate.getClass().getName() + " was encountered");
        }
        return (Ratio)this.rate;
    }

    public boolean hasRateRatio() {
        return this != null && this.rate instanceof Ratio;
    }

    public Range getRateRange() throws FHIRException {
        if (this.rate == null) {
            return null;
        }
        if (!(this.rate instanceof Range)) {
            throw new FHIRException("Type mismatch: the type Range was expected, but " + this.rate.getClass().getName() + " was encountered");
        }
        return (Range)this.rate;
    }

    public boolean hasRateRange() {
        return this != null && this.rate instanceof Range;
    }

    public SimpleQuantity getRateSimpleQuantity() throws FHIRException {
        if (this.rate == null) {
            return null;
        }
        if (!(this.rate instanceof SimpleQuantity)) {
            throw new FHIRException("Type mismatch: the type SimpleQuantity was expected, but " + this.rate.getClass().getName() + " was encountered");
        }
        return (SimpleQuantity)this.rate;
    }

    public boolean hasRateSimpleQuantity() {
        return this != null && this.rate instanceof SimpleQuantity;
    }

    public boolean hasRate() {
        return this.rate != null && !this.rate.isEmpty();
    }

    public Dosage setRate(Type value) throws FHIRFormatError {
        if (!(value == null || value instanceof Ratio || value instanceof Range || value instanceof Quantity)) {
            throw new FHIRFormatError("Not the right type for Dosage.rate[x]: " + value.fhirType());
        }
        this.rate = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("sequence", "integer", "Indicates the order in which the dosage instructions should be applied or interpreted.", 0, 1, this.sequence));
        children.add(new Property("text", "string", "Free text dosage instructions e.g. SIG.", 0, 1, this.text));
        children.add(new Property("additionalInstruction", "CodeableConcept", "Supplemental instruction - e.g. \"with meals\".", 0, Integer.MAX_VALUE, this.additionalInstruction));
        children.add(new Property("patientInstruction", "string", "Instructions in terms that are understood by the patient or consumer.", 0, 1, this.patientInstruction));
        children.add(new Property("timing", "Timing", "When medication should be administered.", 0, 1, this.timing));
        children.add(new Property("asNeeded[x]", "boolean|CodeableConcept", "Indicates whether the Medication is only taken when needed within a specific dosing schedule (Boolean option), or it indicates the precondition for taking the Medication (CodeableConcept).", 0, 1, this.asNeeded));
        children.add(new Property("site", "CodeableConcept", "Body site to administer to.", 0, 1, this.site));
        children.add(new Property("route", "CodeableConcept", "How drug should enter body.", 0, 1, this.route));
        children.add(new Property("method", "CodeableConcept", "Technique for administering medication.", 0, 1, this.method));
        children.add(new Property("dose[x]", "Range|SimpleQuantity", "Amount of medication per dose.", 0, 1, this.dose));
        children.add(new Property("maxDosePerPeriod", "Ratio", "Upper limit on medication per unit of time.", 0, 1, this.maxDosePerPeriod));
        children.add(new Property("maxDosePerAdministration", "SimpleQuantity", "Upper limit on medication per administration.", 0, 1, this.maxDosePerAdministration));
        children.add(new Property("maxDosePerLifetime", "SimpleQuantity", "Upper limit on medication per lifetime of the patient.", 0, 1, this.maxDosePerLifetime));
        children.add(new Property("rate[x]", "Ratio|Range|SimpleQuantity", "Amount of medication per unit of time.", 0, 1, this.rate));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 1349547969: {
                return new Property("sequence", "integer", "Indicates the order in which the dosage instructions should be applied or interpreted.", 0, 1, this.sequence);
            }
            case 3556653: {
                return new Property("text", "string", "Free text dosage instructions e.g. SIG.", 0, 1, this.text);
            }
            case 1623641575: {
                return new Property("additionalInstruction", "CodeableConcept", "Supplemental instruction - e.g. \"with meals\".", 0, Integer.MAX_VALUE, this.additionalInstruction);
            }
            case 737543241: {
                return new Property("patientInstruction", "string", "Instructions in terms that are understood by the patient or consumer.", 0, 1, this.patientInstruction);
            }
            case -873664438: {
                return new Property("timing", "Timing", "When medication should be administered.", 0, 1, this.timing);
            }
            case -544329575: {
                return new Property("asNeeded[x]", "boolean|CodeableConcept", "Indicates whether the Medication is only taken when needed within a specific dosing schedule (Boolean option), or it indicates the precondition for taking the Medication (CodeableConcept).", 0, 1, this.asNeeded);
            }
            case -1432923513: {
                return new Property("asNeeded[x]", "boolean|CodeableConcept", "Indicates whether the Medication is only taken when needed within a specific dosing schedule (Boolean option), or it indicates the precondition for taking the Medication (CodeableConcept).", 0, 1, this.asNeeded);
            }
            case -591717471: {
                return new Property("asNeeded[x]", "boolean|CodeableConcept", "Indicates whether the Medication is only taken when needed within a specific dosing schedule (Boolean option), or it indicates the precondition for taking the Medication (CodeableConcept).", 0, 1, this.asNeeded);
            }
            case 1556420122: {
                return new Property("asNeeded[x]", "boolean|CodeableConcept", "Indicates whether the Medication is only taken when needed within a specific dosing schedule (Boolean option), or it indicates the precondition for taking the Medication (CodeableConcept).", 0, 1, this.asNeeded);
            }
            case 3530567: {
                return new Property("site", "CodeableConcept", "Body site to administer to.", 0, 1, this.site);
            }
            case 108704329: {
                return new Property("route", "CodeableConcept", "How drug should enter body.", 0, 1, this.route);
            }
            case -1077554975: {
                return new Property("method", "CodeableConcept", "Technique for administering medication.", 0, 1, this.method);
            }
            case 1843195715: {
                return new Property("dose[x]", "Range|SimpleQuantity", "Amount of medication per dose.", 0, 1, this.dose);
            }
            case 3089437: {
                return new Property("dose[x]", "Range|SimpleQuantity", "Amount of medication per dose.", 0, 1, this.dose);
            }
            case 1775578912: {
                return new Property("dose[x]", "Range|SimpleQuantity", "Amount of medication per dose.", 0, 1, this.dose);
            }
            case 1230053850: {
                return new Property("dose[x]", "Range|SimpleQuantity", "Amount of medication per dose.", 0, 1, this.dose);
            }
            case 1506263709: {
                return new Property("maxDosePerPeriod", "Ratio", "Upper limit on medication per unit of time.", 0, 1, this.maxDosePerPeriod);
            }
            case 2004889914: {
                return new Property("maxDosePerAdministration", "SimpleQuantity", "Upper limit on medication per administration.", 0, 1, this.maxDosePerAdministration);
            }
            case 642099621: {
                return new Property("maxDosePerLifetime", "SimpleQuantity", "Upper limit on medication per lifetime of the patient.", 0, 1, this.maxDosePerLifetime);
            }
            case 983460768: {
                return new Property("rate[x]", "Ratio|Range|SimpleQuantity", "Amount of medication per unit of time.", 0, 1, this.rate);
            }
            case 3493088: {
                return new Property("rate[x]", "Ratio|Range|SimpleQuantity", "Amount of medication per unit of time.", 0, 1, this.rate);
            }
            case 204021515: {
                return new Property("rate[x]", "Ratio|Range|SimpleQuantity", "Amount of medication per unit of time.", 0, 1, this.rate);
            }
            case 204015677: {
                return new Property("rate[x]", "Ratio|Range|SimpleQuantity", "Amount of medication per unit of time.", 0, 1, this.rate);
            }
            case -2121057955: {
                return new Property("rate[x]", "Ratio|Range|SimpleQuantity", "Amount of medication per unit of time.", 0, 1, this.rate);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 1349547969: {
                Base[] baseArray;
                if (this.sequence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.sequence;
                }
                return baseArray;
            }
            case 3556653: {
                Base[] baseArray;
                if (this.text == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.text;
                }
                return baseArray;
            }
            case 1623641575: {
                return this.additionalInstruction == null ? new Base[]{} : this.additionalInstruction.toArray(new Base[this.additionalInstruction.size()]);
            }
            case 737543241: {
                Base[] baseArray;
                if (this.patientInstruction == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.patientInstruction;
                }
                return baseArray;
            }
            case -873664438: {
                Base[] baseArray;
                if (this.timing == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.timing;
                }
                return baseArray;
            }
            case -1432923513: {
                Base[] baseArray;
                if (this.asNeeded == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.asNeeded;
                }
                return baseArray;
            }
            case 3530567: {
                Base[] baseArray;
                if (this.site == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.site;
                }
                return baseArray;
            }
            case 108704329: {
                Base[] baseArray;
                if (this.route == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.route;
                }
                return baseArray;
            }
            case -1077554975: {
                Base[] baseArray;
                if (this.method == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.method;
                }
                return baseArray;
            }
            case 3089437: {
                Base[] baseArray;
                if (this.dose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.dose;
                }
                return baseArray;
            }
            case 1506263709: {
                Base[] baseArray;
                if (this.maxDosePerPeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.maxDosePerPeriod;
                }
                return baseArray;
            }
            case 2004889914: {
                Base[] baseArray;
                if (this.maxDosePerAdministration == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.maxDosePerAdministration;
                }
                return baseArray;
            }
            case 642099621: {
                Base[] baseArray;
                if (this.maxDosePerLifetime == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.maxDosePerLifetime;
                }
                return baseArray;
            }
            case 3493088: {
                Base[] baseArray;
                if (this.rate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.rate;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 1349547969: {
                this.sequence = this.castToInteger(value);
                return value;
            }
            case 3556653: {
                this.text = this.castToString(value);
                return value;
            }
            case 1623641575: {
                this.getAdditionalInstruction().add(this.castToCodeableConcept(value));
                return value;
            }
            case 737543241: {
                this.patientInstruction = this.castToString(value);
                return value;
            }
            case -873664438: {
                this.timing = this.castToTiming(value);
                return value;
            }
            case -1432923513: {
                this.asNeeded = this.castToType(value);
                return value;
            }
            case 3530567: {
                this.site = this.castToCodeableConcept(value);
                return value;
            }
            case 108704329: {
                this.route = this.castToCodeableConcept(value);
                return value;
            }
            case -1077554975: {
                this.method = this.castToCodeableConcept(value);
                return value;
            }
            case 3089437: {
                this.dose = this.castToType(value);
                return value;
            }
            case 1506263709: {
                this.maxDosePerPeriod = this.castToRatio(value);
                return value;
            }
            case 2004889914: {
                this.maxDosePerAdministration = this.castToSimpleQuantity(value);
                return value;
            }
            case 642099621: {
                this.maxDosePerLifetime = this.castToSimpleQuantity(value);
                return value;
            }
            case 3493088: {
                this.rate = this.castToType(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("sequence")) {
            this.sequence = this.castToInteger(value);
        } else if (name.equals("text")) {
            this.text = this.castToString(value);
        } else if (name.equals("additionalInstruction")) {
            this.getAdditionalInstruction().add(this.castToCodeableConcept(value));
        } else if (name.equals("patientInstruction")) {
            this.patientInstruction = this.castToString(value);
        } else if (name.equals("timing")) {
            this.timing = this.castToTiming(value);
        } else if (name.equals("asNeeded[x]")) {
            this.asNeeded = this.castToType(value);
        } else if (name.equals("site")) {
            this.site = this.castToCodeableConcept(value);
        } else if (name.equals("route")) {
            this.route = this.castToCodeableConcept(value);
        } else if (name.equals("method")) {
            this.method = this.castToCodeableConcept(value);
        } else if (name.equals("dose[x]")) {
            this.dose = this.castToType(value);
        } else if (name.equals("maxDosePerPeriod")) {
            this.maxDosePerPeriod = this.castToRatio(value);
        } else if (name.equals("maxDosePerAdministration")) {
            this.maxDosePerAdministration = this.castToSimpleQuantity(value);
        } else if (name.equals("maxDosePerLifetime")) {
            this.maxDosePerLifetime = this.castToSimpleQuantity(value);
        } else if (name.equals("rate[x]")) {
            this.rate = this.castToType(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1349547969: {
                return this.getSequenceElement();
            }
            case 3556653: {
                return this.getTextElement();
            }
            case 1623641575: {
                return this.addAdditionalInstruction();
            }
            case 737543241: {
                return this.getPatientInstructionElement();
            }
            case -873664438: {
                return this.getTiming();
            }
            case -544329575: {
                return this.getAsNeeded();
            }
            case -1432923513: {
                return this.getAsNeeded();
            }
            case 3530567: {
                return this.getSite();
            }
            case 108704329: {
                return this.getRoute();
            }
            case -1077554975: {
                return this.getMethod();
            }
            case 1843195715: {
                return this.getDose();
            }
            case 3089437: {
                return this.getDose();
            }
            case 1506263709: {
                return this.getMaxDosePerPeriod();
            }
            case 2004889914: {
                return this.getMaxDosePerAdministration();
            }
            case 642099621: {
                return this.getMaxDosePerLifetime();
            }
            case 983460768: {
                return this.getRate();
            }
            case 3493088: {
                return this.getRate();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1349547969: {
                return new String[]{"integer"};
            }
            case 3556653: {
                return new String[]{"string"};
            }
            case 1623641575: {
                return new String[]{"CodeableConcept"};
            }
            case 737543241: {
                return new String[]{"string"};
            }
            case -873664438: {
                return new String[]{"Timing"};
            }
            case -1432923513: {
                return new String[]{"boolean", "CodeableConcept"};
            }
            case 3530567: {
                return new String[]{"CodeableConcept"};
            }
            case 108704329: {
                return new String[]{"CodeableConcept"};
            }
            case -1077554975: {
                return new String[]{"CodeableConcept"};
            }
            case 3089437: {
                return new String[]{"Range", "SimpleQuantity"};
            }
            case 1506263709: {
                return new String[]{"Ratio"};
            }
            case 2004889914: {
                return new String[]{"SimpleQuantity"};
            }
            case 642099621: {
                return new String[]{"SimpleQuantity"};
            }
            case 3493088: {
                return new String[]{"Ratio", "Range", "SimpleQuantity"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("sequence")) {
            throw new FHIRException("Cannot call addChild on a primitive type Dosage.sequence");
        }
        if (name.equals("text")) {
            throw new FHIRException("Cannot call addChild on a primitive type Dosage.text");
        }
        if (name.equals("additionalInstruction")) {
            return this.addAdditionalInstruction();
        }
        if (name.equals("patientInstruction")) {
            throw new FHIRException("Cannot call addChild on a primitive type Dosage.patientInstruction");
        }
        if (name.equals("timing")) {
            this.timing = new Timing();
            return this.timing;
        }
        if (name.equals("asNeededBoolean")) {
            this.asNeeded = new BooleanType();
            return this.asNeeded;
        }
        if (name.equals("asNeededCodeableConcept")) {
            this.asNeeded = new CodeableConcept();
            return this.asNeeded;
        }
        if (name.equals("site")) {
            this.site = new CodeableConcept();
            return this.site;
        }
        if (name.equals("route")) {
            this.route = new CodeableConcept();
            return this.route;
        }
        if (name.equals("method")) {
            this.method = new CodeableConcept();
            return this.method;
        }
        if (name.equals("doseRange")) {
            this.dose = new Range();
            return this.dose;
        }
        if (name.equals("doseSimpleQuantity")) {
            this.dose = new SimpleQuantity();
            return this.dose;
        }
        if (name.equals("maxDosePerPeriod")) {
            this.maxDosePerPeriod = new Ratio();
            return this.maxDosePerPeriod;
        }
        if (name.equals("maxDosePerAdministration")) {
            this.maxDosePerAdministration = new SimpleQuantity();
            return this.maxDosePerAdministration;
        }
        if (name.equals("maxDosePerLifetime")) {
            this.maxDosePerLifetime = new SimpleQuantity();
            return this.maxDosePerLifetime;
        }
        if (name.equals("rateRatio")) {
            this.rate = new Ratio();
            return this.rate;
        }
        if (name.equals("rateRange")) {
            this.rate = new Range();
            return this.rate;
        }
        if (name.equals("rateSimpleQuantity")) {
            this.rate = new SimpleQuantity();
            return this.rate;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Dosage";
    }

    @Override
    public Dosage copy() {
        Dosage dst = new Dosage();
        this.copyValues(dst);
        dst.sequence = this.sequence == null ? null : this.sequence.copy();
        StringType stringType = dst.text = this.text == null ? null : this.text.copy();
        if (this.additionalInstruction != null) {
            dst.additionalInstruction = new ArrayList<CodeableConcept>();
            for (CodeableConcept i : this.additionalInstruction) {
                dst.additionalInstruction.add(i.copy());
            }
        }
        dst.patientInstruction = this.patientInstruction == null ? null : this.patientInstruction.copy();
        dst.timing = this.timing == null ? null : this.timing.copy();
        dst.asNeeded = this.asNeeded == null ? null : this.asNeeded.copy();
        dst.site = this.site == null ? null : this.site.copy();
        dst.route = this.route == null ? null : this.route.copy();
        dst.method = this.method == null ? null : this.method.copy();
        dst.dose = this.dose == null ? null : this.dose.copy();
        dst.maxDosePerPeriod = this.maxDosePerPeriod == null ? null : this.maxDosePerPeriod.copy();
        dst.maxDosePerAdministration = this.maxDosePerAdministration == null ? null : this.maxDosePerAdministration.copy();
        dst.maxDosePerLifetime = this.maxDosePerLifetime == null ? null : this.maxDosePerLifetime.copy();
        dst.rate = this.rate == null ? null : this.rate.copy();
        return dst;
    }

    @Override
    protected Dosage typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Dosage)) {
            return false;
        }
        Dosage o = (Dosage)other_;
        return Dosage.compareDeep(this.sequence, o.sequence, true) && Dosage.compareDeep(this.text, o.text, true) && Dosage.compareDeep(this.additionalInstruction, o.additionalInstruction, true) && Dosage.compareDeep(this.patientInstruction, o.patientInstruction, true) && Dosage.compareDeep(this.timing, o.timing, true) && Dosage.compareDeep(this.asNeeded, o.asNeeded, true) && Dosage.compareDeep(this.site, o.site, true) && Dosage.compareDeep(this.route, o.route, true) && Dosage.compareDeep(this.method, o.method, true) && Dosage.compareDeep(this.dose, o.dose, true) && Dosage.compareDeep(this.maxDosePerPeriod, o.maxDosePerPeriod, true) && Dosage.compareDeep(this.maxDosePerAdministration, o.maxDosePerAdministration, true) && Dosage.compareDeep(this.maxDosePerLifetime, o.maxDosePerLifetime, true) && Dosage.compareDeep(this.rate, o.rate, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Dosage)) {
            return false;
        }
        Dosage o = (Dosage)other_;
        return Dosage.compareValues(this.sequence, o.sequence, true) && Dosage.compareValues(this.text, o.text, true) && Dosage.compareValues(this.patientInstruction, o.patientInstruction, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequence, this.text, this.additionalInstruction, this.patientInstruction, this.timing, this.asNeeded, this.site, this.route, this.method, this.dose, this.maxDosePerPeriod, this.maxDosePerAdministration, this.maxDosePerLifetime, this.rate});
    }
}

