/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.TranslateConceptResults;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.hl7.fhir.common.hapi.validation.support.BaseValidationSupportWrapper;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingValidationSupport
extends BaseValidationSupportWrapper
implements IValidationSupport {
    private static final Logger ourLog = LoggerFactory.getLogger(CachingValidationSupport.class);
    private final Cache<String, Object> myCache;
    private final Cache<String, Object> myValidateCodeCache;
    private final Cache<IValidationSupport.TranslateCodeRequest, Object> myTranslateCodeCache;
    private final Cache<String, Object> myLookupCodeCache;
    private final ThreadPoolExecutor myBackgroundExecutor;
    private final Map<Object, Object> myNonExpiringCache;

    public CachingValidationSupport(IValidationSupport theWrap) {
        this(theWrap, CacheTimeouts.defaultValues());
    }

    public CachingValidationSupport(IValidationSupport theWrap, CacheTimeouts theCacheTimeouts) {
        super(theWrap.getFhirContext(), theWrap);
        this.myValidateCodeCache = Caffeine.newBuilder().expireAfterWrite(theCacheTimeouts.getValidateCodeMillis(), TimeUnit.MILLISECONDS).maximumSize(5000L).build();
        this.myLookupCodeCache = Caffeine.newBuilder().expireAfterWrite(theCacheTimeouts.getLookupCodeMillis(), TimeUnit.MILLISECONDS).maximumSize(5000L).build();
        this.myTranslateCodeCache = Caffeine.newBuilder().expireAfterWrite(theCacheTimeouts.getTranslateCodeMillis(), TimeUnit.MILLISECONDS).maximumSize(5000L).build();
        this.myCache = Caffeine.newBuilder().expireAfterWrite(theCacheTimeouts.getMiscMillis(), TimeUnit.MILLISECONDS).maximumSize(5000L).build();
        this.myNonExpiringCache = Collections.synchronizedMap(new HashMap());
        LinkedBlockingQueue<Runnable> executorQueue = new LinkedBlockingQueue<Runnable>(1000);
        BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern("CachingValidationSupport-%d").daemon(false).priority(5).build();
        this.myBackgroundExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, executorQueue, (ThreadFactory)threadFactory, new ThreadPoolExecutor.DiscardPolicy());
    }

    @Override
    public List<IBaseResource> fetchAllConformanceResources() {
        String key = "fetchAllConformanceResources";
        return this.loadFromCacheWithAsyncRefresh(this.myCache, key, t -> super.fetchAllConformanceResources());
    }

    @Override
    public <T extends IBaseResource> List<T> fetchAllStructureDefinitions() {
        String key = "fetchAllStructureDefinitions";
        return this.loadFromCacheWithAsyncRefresh(this.myCache, key, t -> super.fetchAllStructureDefinitions());
    }

    @Override
    public <T extends IBaseResource> List<T> fetchAllNonBaseStructureDefinitions() {
        String key = "fetchAllNonBaseStructureDefinitions";
        return this.loadFromCacheWithAsyncRefresh(this.myCache, key, t -> super.fetchAllNonBaseStructureDefinitions());
    }

    @Override
    public IBaseResource fetchCodeSystem(String theSystem) {
        return this.loadFromCache(this.myCache, "fetchCodeSystem " + theSystem, t -> super.fetchCodeSystem(theSystem));
    }

    @Override
    public IBaseResource fetchValueSet(String theUri) {
        return this.loadFromCache(this.myCache, "fetchValueSet " + theUri, t -> super.fetchValueSet(theUri));
    }

    @Override
    public IBaseResource fetchStructureDefinition(String theUrl) {
        return this.loadFromCache(this.myCache, "fetchStructureDefinition " + theUrl, t -> super.fetchStructureDefinition(theUrl));
    }

    @Override
    public <T extends IBaseResource> T fetchResource(@Nullable Class<T> theClass, String theUri) {
        return (T)this.loadFromCache(this.myCache, "fetchResource " + theClass + " " + theUri, t -> super.fetchResource(theClass, theUri));
    }

    @Override
    public boolean isCodeSystemSupported(ValidationSupportContext theValidationSupportContext, String theSystem) {
        String key = "isCodeSystemSupported " + theSystem;
        Boolean retVal = this.loadFromCacheReentrantSafe(this.myCache, key, t -> super.isCodeSystemSupported(theValidationSupportContext, theSystem));
        assert (retVal != null);
        return retVal;
    }

    @Override
    public IValidationSupport.CodeValidationResult validateCode(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl) {
        String key = "validateCode " + theCodeSystem + " " + theCode + " " + (String)StringUtils.defaultIfBlank((CharSequence)theValueSetUrl, (CharSequence)"NO_VS");
        return this.loadFromCache(this.myValidateCodeCache, key, t -> super.validateCode(theValidationSupportContext, theOptions, theCodeSystem, theCode, theDisplay, theValueSetUrl));
    }

    @Override
    public IValidationSupport.LookupCodeResult lookupCode(ValidationSupportContext theValidationSupportContext, String theSystem, String theCode, String theDisplayLanguage) {
        String key = "lookupCode " + theSystem + " " + theCode + " " + (String)StringUtils.defaultIfBlank((CharSequence)theDisplayLanguage, (CharSequence)"NO_LANG");
        return this.loadFromCache(this.myLookupCodeCache, key, t -> super.lookupCode(theValidationSupportContext, theSystem, theCode, theDisplayLanguage));
    }

    @Override
    public IValidationSupport.CodeValidationResult validateCodeInValueSet(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theValidationOptions, String theCodeSystem, String theCode, String theDisplay, @Nonnull IBaseResource theValueSet) {
        BaseRuntimeChildDefinition urlChild = this.myCtx.getResourceDefinition(theValueSet).getChildByName("url");
        Optional<String> valueSetUrl = urlChild.getAccessor().getValues((IBase)theValueSet).stream().map(t -> ((IPrimitiveType)t).getValueAsString()).filter(t -> StringUtils.isNotBlank((CharSequence)t)).findFirst();
        if (valueSetUrl.isPresent()) {
            String key = "validateCodeInValueSet " + theValidationOptions.toString() + " " + StringUtils.defaultString((String)theCodeSystem, (String)"(null)") + " " + StringUtils.defaultString((String)theCode, (String)"(null)") + " " + StringUtils.defaultString((String)theDisplay, (String)"(null)") + " " + valueSetUrl.get();
            return this.loadFromCache(this.myValidateCodeCache, key, t -> super.validateCodeInValueSet(theValidationSupportContext, theValidationOptions, theCodeSystem, theCode, theDisplay, theValueSet));
        }
        return super.validateCodeInValueSet(theValidationSupportContext, theValidationOptions, theCodeSystem, theCode, theDisplay, theValueSet);
    }

    @Override
    public TranslateConceptResults translateConcept(IValidationSupport.TranslateCodeRequest theRequest) {
        return this.loadFromCache(this.myTranslateCodeCache, theRequest, k -> super.translateConcept(theRequest));
    }

    @Nullable
    private <S, T> T loadFromCache(Cache<S, Object> theCache, S theKey, Function<S, T> theLoader) {
        ourLog.trace("Fetching from cache: {}", theKey);
        Function<Object, Optional> loaderWrapper = key -> Optional.ofNullable(theLoader.apply(theKey));
        Optional result = (Optional)theCache.get(theKey, loaderWrapper);
        assert (result != null);
        return result.orElse(null);
    }

    @Nullable
    private <S, T> T loadFromCacheReentrantSafe(Cache<S, Object> theCache, S theKey, Function<S, T> theLoader) {
        ourLog.trace("Reentrant fetch from cache: {}", theKey);
        Optional result = (Optional)theCache.getIfPresent(theKey);
        if (result != null && result.isPresent()) {
            return result.get();
        }
        T value = theLoader.apply(theKey);
        assert (value != null);
        theCache.put(theKey, Optional.of(value));
        return value;
    }

    private <S, T> T loadFromCacheWithAsyncRefresh(Cache<S, Object> theCache, S theKey, Function<S, T> theLoader) {
        Object retVal = theCache.getIfPresent(theKey);
        if (retVal == null && (retVal = this.myNonExpiringCache.get(theKey)) != null) {
            Runnable loaderTask = () -> {
                Object loadedItem = this.loadFromCache(theCache, theKey, theLoader);
                this.myNonExpiringCache.put(theKey, loadedItem);
            };
            this.myBackgroundExecutor.execute(loaderTask);
            return (T)retVal;
        }
        retVal = this.loadFromCache(theCache, theKey, theLoader);
        this.myNonExpiringCache.put(theKey, retVal);
        return (T)retVal;
    }

    public void invalidateCaches() {
        this.myLookupCodeCache.invalidateAll();
        this.myCache.invalidateAll();
        this.myValidateCodeCache.invalidateAll();
        this.myNonExpiringCache.clear();
    }

    public static class CacheTimeouts {
        private long myTranslateCodeMillis;
        private long myLookupCodeMillis;
        private long myValidateCodeMillis;
        private long myMiscMillis;

        public long getTranslateCodeMillis() {
            return this.myTranslateCodeMillis;
        }

        public CacheTimeouts setTranslateCodeMillis(long theTranslateCodeMillis) {
            this.myTranslateCodeMillis = theTranslateCodeMillis;
            return this;
        }

        public long getLookupCodeMillis() {
            return this.myLookupCodeMillis;
        }

        public CacheTimeouts setLookupCodeMillis(long theLookupCodeMillis) {
            this.myLookupCodeMillis = theLookupCodeMillis;
            return this;
        }

        public long getValidateCodeMillis() {
            return this.myValidateCodeMillis;
        }

        public CacheTimeouts setValidateCodeMillis(long theValidateCodeMillis) {
            this.myValidateCodeMillis = theValidateCodeMillis;
            return this;
        }

        public long getMiscMillis() {
            return this.myMiscMillis;
        }

        public CacheTimeouts setMiscMillis(long theMiscMillis) {
            this.myMiscMillis = theMiscMillis;
            return this;
        }

        public static CacheTimeouts defaultValues() {
            return new CacheTimeouts().setLookupCodeMillis(600000L).setTranslateCodeMillis(600000L).setValidateCodeMillis(600000L).setMiscMillis(600000L);
        }
    }
}

