/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.TranslateConceptResults;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.common.hapi.validation.support.BaseValidationSupport;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class BaseValidationSupportWrapper
extends BaseValidationSupport {
    private final IValidationSupport myWrap;

    public BaseValidationSupportWrapper(FhirContext theFhirContext, IValidationSupport theWrap) {
        super(theFhirContext);
        Validate.notNull((Object)theWrap, (String)"theWrap must not be null", (Object[])new Object[0]);
        this.myWrap = theWrap;
    }

    public List<IBaseResource> fetchAllConformanceResources() {
        return this.myWrap.fetchAllConformanceResources();
    }

    @Nullable
    public <T extends IBaseResource> List<T> fetchAllNonBaseStructureDefinitions() {
        return this.myWrap.fetchAllNonBaseStructureDefinitions();
    }

    public <T extends IBaseResource> List<T> fetchAllStructureDefinitions() {
        return this.myWrap.fetchAllStructureDefinitions();
    }

    public <T extends IBaseResource> T fetchResource(Class<T> theClass, String theUri) {
        return (T)this.myWrap.fetchResource(theClass, theUri);
    }

    public boolean isCodeSystemSupported(ValidationSupportContext theValidationSupportContext, String theSystem) {
        return this.myWrap.isCodeSystemSupported(theValidationSupportContext, theSystem);
    }

    public IValidationSupport.CodeValidationResult validateCode(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl) {
        return this.myWrap.validateCode(theValidationSupportContext, theOptions, theCodeSystem, theCode, theDisplay, theValueSetUrl);
    }

    public IValidationSupport.CodeValidationResult validateCodeInValueSet(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theValidationOptions, String theCodeSystem, String theCode, String theDisplay, @Nonnull IBaseResource theValueSet) {
        return this.myWrap.validateCodeInValueSet(theValidationSupportContext, theValidationOptions, theCodeSystem, theCode, theDisplay, theValueSet);
    }

    public IValidationSupport.LookupCodeResult lookupCode(ValidationSupportContext theValidationSupportContext, String theSystem, String theCode, String theDisplayLanguage) {
        return this.myWrap.lookupCode(theValidationSupportContext, theSystem, theCode, theDisplayLanguage);
    }

    public boolean isValueSetSupported(ValidationSupportContext theValidationSupportContext, String theValueSetUrl) {
        return this.myWrap.isValueSetSupported(theValidationSupportContext, theValueSetUrl);
    }

    public IValidationSupport.ValueSetExpansionOutcome expandValueSet(ValidationSupportContext theValidationSupportContext, ValueSetExpansionOptions theExpansionOptions, @Nonnull IBaseResource theValueSetToExpand) {
        return this.myWrap.expandValueSet(theValidationSupportContext, theExpansionOptions, theValueSetToExpand);
    }

    public IBaseResource fetchCodeSystem(String theSystem) {
        return this.myWrap.fetchCodeSystem(theSystem);
    }

    public IBaseResource fetchValueSet(String theUri) {
        return this.myWrap.fetchValueSet(theUri);
    }

    public IBaseResource fetchStructureDefinition(String theUrl) {
        return this.myWrap.fetchStructureDefinition(theUrl);
    }

    public IBaseResource generateSnapshot(ValidationSupportContext theValidationSupportContext, IBaseResource theInput, String theUrl, String theWebUrl, String theProfileName) {
        return this.myWrap.generateSnapshot(theValidationSupportContext, theInput, theUrl, theWebUrl, theProfileName);
    }

    public TranslateConceptResults translateConcept(IValidationSupport.TranslateCodeRequest theRequest) {
        return this.myWrap.translateConcept(theRequest);
    }
}

