/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum ListOrderCodesEnum {
    SORTED_BY_USER("user", "http://hl7.org/fhir/list-order"),
    SORTED_BY_SYSTEM("system", "http://hl7.org/fhir/list-order"),
    SORTED_BY_EVENT_DATE("event-date", "http://hl7.org/fhir/list-order"),
    SORTED_BY_ITEM_DATE("entry-date", "http://hl7.org/fhir/list-order"),
    SORTED_BY_PRIORITY("priority", "http://hl7.org/fhir/list-order"),
    SORTED_ALPHABETICALLY("alphabetic", "http://hl7.org/fhir/list-order"),
    SORTED_BY_CATEGORY("category", "http://hl7.org/fhir/list-order"),
    SORTED_BY_PATIENT("patient", "http://hl7.org/fhir/list-order");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "List Order Codes";
    private static Map<String, ListOrderCodesEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, ListOrderCodesEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<ListOrderCodesEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static ListOrderCodesEnum forCode(String theCode) {
        ListOrderCodesEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private ListOrderCodesEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, ListOrderCodesEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, ListOrderCodesEnum>>();
        for (ListOrderCodesEnum next : ListOrderCodesEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<ListOrderCodesEnum>(){

            public String toCodeString(ListOrderCodesEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(ListOrderCodesEnum theEnum) {
                return theEnum.getSystem();
            }

            public ListOrderCodesEnum fromCodeString(String theCodeString) {
                return CODE_TO_ENUM.get(theCodeString);
            }

            public ListOrderCodesEnum fromCodeString(String theCodeString, String theSystemString) {
                Map<String, ListOrderCodesEnum> map = SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return map.get(theCodeString);
            }
        };
    }
}

