/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.composite.ContactPointDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Conformance;
import ca.uhn.fhir.model.dstu2.valueset.AssertionDirectionTypeEnum;
import ca.uhn.fhir.model.dstu2.valueset.AssertionOperatorTypeEnum;
import ca.uhn.fhir.model.dstu2.valueset.AssertionResponseTypesEnum;
import ca.uhn.fhir.model.dstu2.valueset.ConformanceResourceStatusEnum;
import ca.uhn.fhir.model.dstu2.valueset.ContentTypeEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="TestScript", profile="http://hl7.org/fhir/profiles/TestScript", id="testscript")
public class TestScript
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="url", path="TestScript.url", description="", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="identifier", path="TestScript.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="name", path="TestScript.name", description="", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="description", path="TestScript.description", description="", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="testscript-capability", path="TestScript.metadata.capability.description", description="TestScript required and validated capability", type="string")
    public static final String SP_TESTSCRIPT_CAPABILITY = "testscript-capability";
    public static final StringClientParam TESTSCRIPT_CAPABILITY = new StringClientParam("testscript-capability");
    @SearchParamDefinition(name="testscript-setup-capability", path="TestScript.setup.metadata.capability.description", description="TestScript setup required and validated capability", type="string")
    public static final String SP_TESTSCRIPT_SETUP_CAPABILITY = "testscript-setup-capability";
    public static final StringClientParam TESTSCRIPT_SETUP_CAPABILITY = new StringClientParam("testscript-setup-capability");
    @SearchParamDefinition(name="testscript-test-capability", path="TestScript.test.metadata.capability.description", description="TestScript test required and validated capability", type="string")
    public static final String SP_TESTSCRIPT_TEST_CAPABILITY = "testscript-test-capability";
    public static final StringClientParam TESTSCRIPT_TEST_CAPABILITY = new StringClientParam("testscript-test-capability");
    @Child(name="url", type={UriDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="An absolute URL that is used to identify this Test Script. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this Test Script is (or will be) published")
    private UriDt myUrl;
    @Child(name="version", type={StringDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The identifier that is used to identify this version of the TestScript. This is an arbitrary value managed by the TestScript author manually")
    private StringDt myVersion;
    @Child(name="name", type={StringDt.class}, order=2, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A free text natural language name identifying the TestScript")
    private StringDt myName;
    @Child(name="status", type={CodeDt.class}, order=3, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The status of the TestScript")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/conformance-resource-status")
    private BoundCodeDt<ConformanceResourceStatusEnum> myStatus;
    @Child(name="identifier", type={IdentifierDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifier for the TestScript assigned for external purposes outside the context of FHIR.")
    private IdentifierDt myIdentifier;
    @Child(name="experimental", type={BooleanDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="This TestScript was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage")
    private BooleanDt myExperimental;
    @Child(name="publisher", type={StringDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The name of the individual or organization that published the Test Script")
    private StringDt myPublisher;
    @Child(name="contact", order=7, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Contacts to assist a user in finding and communicating with the publisher")
    private List<Contact> myContact;
    @Child(name="date", type={DateTimeDt.class}, order=8, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The date this version of the test tcript was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the test cases change")
    private DateTimeDt myDate;
    @Child(name="description", type={StringDt.class}, order=9, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A free text natural language description of the TestScript and its use")
    private StringDt myDescription;
    @Child(name="useContext", type={CodeableConceptDt.class}, order=10, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of Test Scripts.")
    private List<CodeableConceptDt> myUseContext;
    @Child(name="requirements", type={StringDt.class}, order=11, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Explains why this Test Script is needed and why it's been constrained as it has")
    private StringDt myRequirements;
    @Child(name="copyright", type={StringDt.class}, order=12, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A copyright statement relating to the Test Script and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the details of the constraints and mappings")
    private StringDt myCopyright;
    @Child(name="metadata", order=13, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The required capability must exist and are assumed to function correctly on the FHIR server being tested.")
    private Metadata myMetadata;
    @Child(name="multiserver", type={BooleanDt.class}, order=14, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="If the tests apply to more than one FHIR server (e.g. cross-server interoperability tests) then multiserver=true. Defaults to false if value is unspecified.")
    private BooleanDt myMultiserver;
    @Child(name="fixture", order=15, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Fixture in the test script - by reference (uri). All fixtures are required for the test script to execute.")
    private List<Fixture> myFixture;
    @Child(name="profile", order=16, min=0, max=-1, summary=false, modifier=false, type={IResource.class})
    @Description(shortDefinition="", formalDefinition="Reference to the profile to be used for validation.")
    private List<ResourceReferenceDt> myProfile;
    @Child(name="variable", order=17, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Variable is set based either on element value in response body or on header field value in the response headers.")
    private List<Variable> myVariable;
    @Child(name="setup", order=18, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A series of required setup operations before tests are executed.")
    private Setup mySetup;
    @Child(name="test", order=19, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A test in this script.")
    private List<Test> myTest;
    @Child(name="teardown", order=20, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A series of operations required to clean up after the all the tests are executed (successfully or otherwise).")
    private Teardown myTeardown;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myUrl, this.myVersion, this.myName, this.myStatus, this.myIdentifier, this.myExperimental, this.myPublisher, this.myContact, this.myDate, this.myDescription, this.myUseContext, this.myRequirements, this.myCopyright, this.myMetadata, this.myMultiserver, this.myFixture, this.myProfile, this.myVariable, this.mySetup, this.myTest, this.myTeardown});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myUrl, this.myVersion, this.myName, this.myStatus, this.myIdentifier, this.myExperimental, this.myPublisher, this.myContact, this.myDate, this.myDescription, this.myUseContext, this.myRequirements, this.myCopyright, this.myMetadata, this.myMultiserver, this.myFixture, this.myProfile, this.myVariable, this.mySetup, this.myTest, this.myTeardown});
    }

    public UriDt getUrlElement() {
        if (this.myUrl == null) {
            this.myUrl = new UriDt();
        }
        return this.myUrl;
    }

    public String getUrl() {
        return (String)this.getUrlElement().getValue();
    }

    public TestScript setUrl(UriDt theValue) {
        this.myUrl = theValue;
        return this;
    }

    public TestScript setUrl(String theUri) {
        this.myUrl = new UriDt(theUri);
        return this;
    }

    public StringDt getVersionElement() {
        if (this.myVersion == null) {
            this.myVersion = new StringDt();
        }
        return this.myVersion;
    }

    public String getVersion() {
        return (String)this.getVersionElement().getValue();
    }

    public TestScript setVersion(StringDt theValue) {
        this.myVersion = theValue;
        return this;
    }

    public TestScript setVersion(String theString) {
        this.myVersion = new StringDt(theString);
        return this;
    }

    public StringDt getNameElement() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public String getName() {
        return (String)this.getNameElement().getValue();
    }

    public TestScript setName(StringDt theValue) {
        this.myName = theValue;
        return this;
    }

    public TestScript setName(String theString) {
        this.myName = new StringDt(theString);
        return this;
    }

    public BoundCodeDt<ConformanceResourceStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ConformanceResourceStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public TestScript setStatus(BoundCodeDt<ConformanceResourceStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public TestScript setStatus(ConformanceResourceStatusEnum theValue) {
        this.setStatus((BoundCodeDt<ConformanceResourceStatusEnum>)new BoundCodeDt(ConformanceResourceStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public IdentifierDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public TestScript setIdentifier(IdentifierDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public BooleanDt getExperimentalElement() {
        if (this.myExperimental == null) {
            this.myExperimental = new BooleanDt();
        }
        return this.myExperimental;
    }

    public Boolean getExperimental() {
        return (Boolean)this.getExperimentalElement().getValue();
    }

    public TestScript setExperimental(BooleanDt theValue) {
        this.myExperimental = theValue;
        return this;
    }

    public TestScript setExperimental(boolean theBoolean) {
        this.myExperimental = new BooleanDt(theBoolean);
        return this;
    }

    public StringDt getPublisherElement() {
        if (this.myPublisher == null) {
            this.myPublisher = new StringDt();
        }
        return this.myPublisher;
    }

    public String getPublisher() {
        return (String)this.getPublisherElement().getValue();
    }

    public TestScript setPublisher(StringDt theValue) {
        this.myPublisher = theValue;
        return this;
    }

    public TestScript setPublisher(String theString) {
        this.myPublisher = new StringDt(theString);
        return this;
    }

    public List<Contact> getContact() {
        if (this.myContact == null) {
            this.myContact = new ArrayList<Contact>();
        }
        return this.myContact;
    }

    public TestScript setContact(List<Contact> theValue) {
        this.myContact = theValue;
        return this;
    }

    public Contact addContact() {
        Contact newType = new Contact();
        this.getContact().add(newType);
        return newType;
    }

    public TestScript addContact(Contact theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getContact().add(theValue);
        return this;
    }

    public Contact getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            return this.addContact();
        }
        return this.getContact().get(0);
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public Date getDate() {
        return (Date)this.getDateElement().getValue();
    }

    public TestScript setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public TestScript setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public TestScript setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public String getDescription() {
        return (String)this.getDescriptionElement().getValue();
    }

    public TestScript setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public TestScript setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public List<CodeableConceptDt> getUseContext() {
        if (this.myUseContext == null) {
            this.myUseContext = new ArrayList<CodeableConceptDt>();
        }
        return this.myUseContext;
    }

    public TestScript setUseContext(List<CodeableConceptDt> theValue) {
        this.myUseContext = theValue;
        return this;
    }

    public CodeableConceptDt addUseContext() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getUseContext().add(newType);
        return newType;
    }

    public TestScript addUseContext(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getUseContext().add(theValue);
        return this;
    }

    public CodeableConceptDt getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            return this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    public StringDt getRequirementsElement() {
        if (this.myRequirements == null) {
            this.myRequirements = new StringDt();
        }
        return this.myRequirements;
    }

    public String getRequirements() {
        return (String)this.getRequirementsElement().getValue();
    }

    public TestScript setRequirements(StringDt theValue) {
        this.myRequirements = theValue;
        return this;
    }

    public TestScript setRequirements(String theString) {
        this.myRequirements = new StringDt(theString);
        return this;
    }

    public StringDt getCopyrightElement() {
        if (this.myCopyright == null) {
            this.myCopyright = new StringDt();
        }
        return this.myCopyright;
    }

    public String getCopyright() {
        return (String)this.getCopyrightElement().getValue();
    }

    public TestScript setCopyright(StringDt theValue) {
        this.myCopyright = theValue;
        return this;
    }

    public TestScript setCopyright(String theString) {
        this.myCopyright = new StringDt(theString);
        return this;
    }

    public Metadata getMetadata() {
        if (this.myMetadata == null) {
            this.myMetadata = new Metadata();
        }
        return this.myMetadata;
    }

    public TestScript setMetadata(Metadata theValue) {
        this.myMetadata = theValue;
        return this;
    }

    public BooleanDt getMultiserverElement() {
        if (this.myMultiserver == null) {
            this.myMultiserver = new BooleanDt();
        }
        return this.myMultiserver;
    }

    public Boolean getMultiserver() {
        return (Boolean)this.getMultiserverElement().getValue();
    }

    public TestScript setMultiserver(BooleanDt theValue) {
        this.myMultiserver = theValue;
        return this;
    }

    public TestScript setMultiserver(boolean theBoolean) {
        this.myMultiserver = new BooleanDt(theBoolean);
        return this;
    }

    public List<Fixture> getFixture() {
        if (this.myFixture == null) {
            this.myFixture = new ArrayList<Fixture>();
        }
        return this.myFixture;
    }

    public TestScript setFixture(List<Fixture> theValue) {
        this.myFixture = theValue;
        return this;
    }

    public Fixture addFixture() {
        Fixture newType = new Fixture();
        this.getFixture().add(newType);
        return newType;
    }

    public TestScript addFixture(Fixture theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getFixture().add(theValue);
        return this;
    }

    public Fixture getFixtureFirstRep() {
        if (this.getFixture().isEmpty()) {
            return this.addFixture();
        }
        return this.getFixture().get(0);
    }

    public List<ResourceReferenceDt> getProfile() {
        if (this.myProfile == null) {
            this.myProfile = new ArrayList<ResourceReferenceDt>();
        }
        return this.myProfile;
    }

    public TestScript setProfile(List<ResourceReferenceDt> theValue) {
        this.myProfile = theValue;
        return this;
    }

    public ResourceReferenceDt addProfile() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getProfile().add(newType);
        return newType;
    }

    public List<Variable> getVariable() {
        if (this.myVariable == null) {
            this.myVariable = new ArrayList<Variable>();
        }
        return this.myVariable;
    }

    public TestScript setVariable(List<Variable> theValue) {
        this.myVariable = theValue;
        return this;
    }

    public Variable addVariable() {
        Variable newType = new Variable();
        this.getVariable().add(newType);
        return newType;
    }

    public TestScript addVariable(Variable theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getVariable().add(theValue);
        return this;
    }

    public Variable getVariableFirstRep() {
        if (this.getVariable().isEmpty()) {
            return this.addVariable();
        }
        return this.getVariable().get(0);
    }

    public Setup getSetup() {
        if (this.mySetup == null) {
            this.mySetup = new Setup();
        }
        return this.mySetup;
    }

    public TestScript setSetup(Setup theValue) {
        this.mySetup = theValue;
        return this;
    }

    public List<Test> getTest() {
        if (this.myTest == null) {
            this.myTest = new ArrayList<Test>();
        }
        return this.myTest;
    }

    public TestScript setTest(List<Test> theValue) {
        this.myTest = theValue;
        return this;
    }

    public Test addTest() {
        Test newType = new Test();
        this.getTest().add(newType);
        return newType;
    }

    public TestScript addTest(Test theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getTest().add(theValue);
        return this;
    }

    public Test getTestFirstRep() {
        if (this.getTest().isEmpty()) {
            return this.addTest();
        }
        return this.getTest().get(0);
    }

    public Teardown getTeardown() {
        if (this.myTeardown == null) {
            this.myTeardown = new Teardown();
        }
        return this.myTeardown;
    }

    public TestScript setTeardown(Teardown theValue) {
        this.myTeardown = theValue;
        return this;
    }

    public String getResourceName() {
        return "TestScript";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Metadata
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="link", order=0, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A link to the FHIR specification that this test is covering.")
        private List<MetadataLink> myLink;
        @Child(name="capability", order=1, min=1, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Capabilities that must exist and are assumed to function correctly on the FHIR server being tested.")
        private List<MetadataCapability> myCapability;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myLink, this.myCapability});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myLink, this.myCapability});
        }

        public List<MetadataLink> getLink() {
            if (this.myLink == null) {
                this.myLink = new ArrayList<MetadataLink>();
            }
            return this.myLink;
        }

        public Metadata setLink(List<MetadataLink> theValue) {
            this.myLink = theValue;
            return this;
        }

        public MetadataLink addLink() {
            MetadataLink newType = new MetadataLink();
            this.getLink().add(newType);
            return newType;
        }

        public Metadata addLink(MetadataLink theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getLink().add(theValue);
            return this;
        }

        public MetadataLink getLinkFirstRep() {
            if (this.getLink().isEmpty()) {
                return this.addLink();
            }
            return this.getLink().get(0);
        }

        public List<MetadataCapability> getCapability() {
            if (this.myCapability == null) {
                this.myCapability = new ArrayList<MetadataCapability>();
            }
            return this.myCapability;
        }

        public Metadata setCapability(List<MetadataCapability> theValue) {
            this.myCapability = theValue;
            return this;
        }

        public MetadataCapability addCapability() {
            MetadataCapability newType = new MetadataCapability();
            this.getCapability().add(newType);
            return newType;
        }

        public Metadata addCapability(MetadataCapability theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getCapability().add(theValue);
            return this;
        }

        public MetadataCapability getCapabilityFirstRep() {
            if (this.getCapability().isEmpty()) {
                return this.addCapability();
            }
            return this.getCapability().get(0);
        }
    }

    @Block
    public static class Setup
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="metadata", type={Metadata.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Capabilities that must exist and are assumed to function correctly on the FHIR server being tested.")
        private Metadata myMetadata;
        @Child(name="action", order=1, min=1, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Action would contain either an operation or an assertion.")
        private List<SetupAction> myAction;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myMetadata, this.myAction});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myMetadata, this.myAction});
        }

        public Metadata getMetadata() {
            if (this.myMetadata == null) {
                this.myMetadata = new Metadata();
            }
            return this.myMetadata;
        }

        public Setup setMetadata(Metadata theValue) {
            this.myMetadata = theValue;
            return this;
        }

        public List<SetupAction> getAction() {
            if (this.myAction == null) {
                this.myAction = new ArrayList<SetupAction>();
            }
            return this.myAction;
        }

        public Setup setAction(List<SetupAction> theValue) {
            this.myAction = theValue;
            return this;
        }

        public SetupAction addAction() {
            SetupAction newType = new SetupAction();
            this.getAction().add(newType);
            return newType;
        }

        public Setup addAction(SetupAction theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getAction().add(theValue);
            return this;
        }

        public SetupAction getActionFirstRep() {
            if (this.getAction().isEmpty()) {
                return this.addAction();
            }
            return this.getAction().get(0);
        }
    }

    @Block
    public static class Teardown
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="action", order=0, min=1, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The teardown action will only contain an operation.")
        private List<TeardownAction> myAction;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty(this.myAction);
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myAction});
        }

        public List<TeardownAction> getAction() {
            if (this.myAction == null) {
                this.myAction = new ArrayList<TeardownAction>();
            }
            return this.myAction;
        }

        public Teardown setAction(List<TeardownAction> theValue) {
            this.myAction = theValue;
            return this;
        }

        public TeardownAction addAction() {
            TeardownAction newType = new TeardownAction();
            this.getAction().add(newType);
            return newType;
        }

        public Teardown addAction(TeardownAction theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getAction().add(theValue);
            return this;
        }

        public TeardownAction getActionFirstRep() {
            if (this.getAction().isEmpty()) {
                return this.addAction();
            }
            return this.getAction().get(0);
        }
    }

    @Block
    public static class Contact
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The name of an individual to contact regarding the Test Script")
        private StringDt myName;
        @Child(name="telecom", type={ContactPointDt.class}, order=1, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Contact details for individual (if a name was provided) or the publisher")
        private List<ContactPointDt> myTelecom;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myName, this.myTelecom});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myTelecom});
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public String getName() {
            return (String)this.getNameElement().getValue();
        }

        public Contact setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Contact setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public List<ContactPointDt> getTelecom() {
            if (this.myTelecom == null) {
                this.myTelecom = new ArrayList<ContactPointDt>();
            }
            return this.myTelecom;
        }

        public Contact setTelecom(List<ContactPointDt> theValue) {
            this.myTelecom = theValue;
            return this;
        }

        public ContactPointDt addTelecom() {
            ContactPointDt newType = new ContactPointDt();
            this.getTelecom().add(newType);
            return newType;
        }

        public Contact addTelecom(ContactPointDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getTelecom().add(theValue);
            return this;
        }

        public ContactPointDt getTelecomFirstRep() {
            if (this.getTelecom().isEmpty()) {
                return this.addTelecom();
            }
            return this.getTelecom().get(0);
        }
    }

    @Block
    public static class Fixture
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="autocreate", type={BooleanDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Whether or not to implicitly create the fixture during setup. If true, the fixture is automatically created on each server being tested during setup, therefore no create operation is required for this fixture in the TestScript.setup section.")
        private BooleanDt myAutocreate;
        @Child(name="autodelete", type={BooleanDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Whether or not to implicitly delete the fixture during teardown If true, the fixture is automatically deleted on each server being tested during teardown, therefore no delete operation is required for this fixture in the TestScript.teardown section.")
        private BooleanDt myAutodelete;
        @Child(name="resource", order=2, min=0, max=1, summary=false, modifier=false, type={IResource.class})
        @Description(shortDefinition="", formalDefinition="Reference to the resource (containing the contents of the resource needed for operations)")
        private ResourceReferenceDt myResource;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myAutocreate, this.myAutodelete, this.myResource});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myAutocreate, this.myAutodelete, this.myResource});
        }

        public BooleanDt getAutocreateElement() {
            if (this.myAutocreate == null) {
                this.myAutocreate = new BooleanDt();
            }
            return this.myAutocreate;
        }

        public Boolean getAutocreate() {
            return (Boolean)this.getAutocreateElement().getValue();
        }

        public Fixture setAutocreate(BooleanDt theValue) {
            this.myAutocreate = theValue;
            return this;
        }

        public Fixture setAutocreate(boolean theBoolean) {
            this.myAutocreate = new BooleanDt(theBoolean);
            return this;
        }

        public BooleanDt getAutodeleteElement() {
            if (this.myAutodelete == null) {
                this.myAutodelete = new BooleanDt();
            }
            return this.myAutodelete;
        }

        public Boolean getAutodelete() {
            return (Boolean)this.getAutodeleteElement().getValue();
        }

        public Fixture setAutodelete(BooleanDt theValue) {
            this.myAutodelete = theValue;
            return this;
        }

        public Fixture setAutodelete(boolean theBoolean) {
            this.myAutodelete = new BooleanDt(theBoolean);
            return this;
        }

        public ResourceReferenceDt getResource() {
            if (this.myResource == null) {
                this.myResource = new ResourceReferenceDt();
            }
            return this.myResource;
        }

        public Fixture setResource(ResourceReferenceDt theValue) {
            this.myResource = theValue;
            return this;
        }
    }

    @Block
    public static class Variable
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Descriptive name for this variable")
        private StringDt myName;
        @Child(name="headerField", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Will be used to grab the HTTP header field value from the headers that sourceId is pointing to.")
        private StringDt myHeaderField;
        @Child(name="path", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="XPath or JSONPath against the fixture body.  When variables are defined, either headerField must be specified or path, but not both.")
        private StringDt myPath;
        @Child(name="sourceId", type={IdDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Fixture to evaluate the XPath/JSONPath expression or the headerField  against within this variable.")
        private IdDt mySourceId;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myName, this.myHeaderField, this.myPath, this.mySourceId});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myHeaderField, this.myPath, this.mySourceId});
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public String getName() {
            return (String)this.getNameElement().getValue();
        }

        public Variable setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Variable setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public StringDt getHeaderFieldElement() {
            if (this.myHeaderField == null) {
                this.myHeaderField = new StringDt();
            }
            return this.myHeaderField;
        }

        public String getHeaderField() {
            return (String)this.getHeaderFieldElement().getValue();
        }

        public Variable setHeaderField(StringDt theValue) {
            this.myHeaderField = theValue;
            return this;
        }

        public Variable setHeaderField(String theString) {
            this.myHeaderField = new StringDt(theString);
            return this;
        }

        public StringDt getPathElement() {
            if (this.myPath == null) {
                this.myPath = new StringDt();
            }
            return this.myPath;
        }

        public String getPath() {
            return (String)this.getPathElement().getValue();
        }

        public Variable setPath(StringDt theValue) {
            this.myPath = theValue;
            return this;
        }

        public Variable setPath(String theString) {
            this.myPath = new StringDt(theString);
            return this;
        }

        public IdDt getSourceIdElement() {
            if (this.mySourceId == null) {
                this.mySourceId = new IdDt();
            }
            return this.mySourceId;
        }

        public String getSourceId() {
            return this.getSourceIdElement().getValue();
        }

        public Variable setSourceId(IdDt theValue) {
            this.mySourceId = theValue;
            return this;
        }

        public Variable setSourceId(String theId) {
            this.mySourceId = new IdDt(theId);
            return this;
        }
    }

    @Block
    public static class Test
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The name of this test used for tracking/logging purposes by test engines.")
        private StringDt myName;
        @Child(name="description", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A short description of the test used by test engines for tracking and reporting purposes.")
        private StringDt myDescription;
        @Child(name="metadata", type={Metadata.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Capabilities that must exist and are assumed to function correctly on the FHIR server being tested.")
        private Metadata myMetadata;
        @Child(name="action", order=3, min=1, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Action would contain either an operation or an assertion.")
        private List<TestAction> myAction;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myName, this.myDescription, this.myMetadata, this.myAction});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myDescription, this.myMetadata, this.myAction});
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public String getName() {
            return (String)this.getNameElement().getValue();
        }

        public Test setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Test setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public String getDescription() {
            return (String)this.getDescriptionElement().getValue();
        }

        public Test setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public Test setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }

        public Metadata getMetadata() {
            if (this.myMetadata == null) {
                this.myMetadata = new Metadata();
            }
            return this.myMetadata;
        }

        public Test setMetadata(Metadata theValue) {
            this.myMetadata = theValue;
            return this;
        }

        public List<TestAction> getAction() {
            if (this.myAction == null) {
                this.myAction = new ArrayList<TestAction>();
            }
            return this.myAction;
        }

        public Test setAction(List<TestAction> theValue) {
            this.myAction = theValue;
            return this;
        }

        public TestAction addAction() {
            TestAction newType = new TestAction();
            this.getAction().add(newType);
            return newType;
        }

        public Test addAction(TestAction theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getAction().add(theValue);
            return this;
        }

        public TestAction getActionFirstRep() {
            if (this.getAction().isEmpty()) {
                return this.addAction();
            }
            return this.getAction().get(0);
        }
    }

    @Block
    public static class TeardownAction
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="operation", type={SetupActionOperation.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An operation would involve a REST request to a server.")
        private SetupActionOperation myOperation;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myOperation});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myOperation});
        }

        public SetupActionOperation getOperation() {
            if (this.myOperation == null) {
                this.myOperation = new SetupActionOperation();
            }
            return this.myOperation;
        }

        public TeardownAction setOperation(SetupActionOperation theValue) {
            this.myOperation = theValue;
            return this;
        }
    }

    @Block
    public static class TestAction
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="operation", type={SetupActionOperation.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An operation would involve a REST request to a server.")
        private SetupActionOperation myOperation;
        @Child(name="assert", type={SetupActionAssert.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Evaluates the results of previous operations to determine if the server under test behaves appropriately.")
        private SetupActionAssert myAssert;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myOperation, this.myAssert});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myOperation, this.myAssert});
        }

        public SetupActionOperation getOperation() {
            if (this.myOperation == null) {
                this.myOperation = new SetupActionOperation();
            }
            return this.myOperation;
        }

        public TestAction setOperation(SetupActionOperation theValue) {
            this.myOperation = theValue;
            return this;
        }

        public SetupActionAssert getAssert() {
            if (this.myAssert == null) {
                this.myAssert = new SetupActionAssert();
            }
            return this.myAssert;
        }

        public TestAction setAssert(SetupActionAssert theValue) {
            this.myAssert = theValue;
            return this;
        }
    }

    @Block
    public static class SetupActionAssert
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="label", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The label would be used for tracking/logging purposes by test engines.")
        private StringDt myLabel;
        @Child(name="description", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The description would be used by test engines for tracking and reporting purposes.")
        private StringDt myDescription;
        @Child(name="direction", type={CodeDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The direction to use for the assertion.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/assert-direction-codes")
        private BoundCodeDt<AssertionDirectionTypeEnum> myDirection;
        @Child(name="compareToSourceId", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Id of fixture used to compare the \"sourceId/path\" evaluations to.")
        private StringDt myCompareToSourceId;
        @Child(name="compareToSourcePath", type={StringDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="XPath or JSONPath expression against fixture used to compare the \"sourceId/path\" evaluations to.")
        private StringDt myCompareToSourcePath;
        @Child(name="contentType", type={CodeDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The content-type or mime-type to use for RESTful operation in the 'Content-Type' header.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/content-type")
        private BoundCodeDt<ContentTypeEnum> myContentType;
        @Child(name="headerField", type={StringDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The HTTP header field name e.g. 'Location'")
        private StringDt myHeaderField;
        @Child(name="minimumId", type={StringDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The ID of a fixture.  Asserts that the response contains at a minimumId the fixture specified by minimumId.")
        private StringDt myMinimumId;
        @Child(name="navigationLinks", type={BooleanDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Whether or not the test execution performs validation on the bundle navigation links")
        private BooleanDt myNavigationLinks;
        @Child(name="operator", type={CodeDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The operator type")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/assert-operator-codes")
        private BoundCodeDt<AssertionOperatorTypeEnum> myOperator;
        @Child(name="path", type={StringDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The XPath or JSONPath expression to be evaluated against the fixture representing the response received from server.")
        private StringDt myPath;
        @Child(name="resource", type={CodeDt.class}, order=11, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The type of the resource.  See http://hl7-fhir.github.io/resourcelist.html.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/defined-types")
        private CodeDt myResource;
        @Child(name="response", type={CodeDt.class}, order=12, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="okay | created | noContent | notModified | bad | forbidden | notFound | methodNotAllowed | conflict | gone | preconditionFailed | unprocessable")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/assert-response-code-types")
        private BoundCodeDt<AssertionResponseTypesEnum> myResponse;
        @Child(name="responseCode", type={StringDt.class}, order=13, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The value of the HTTP response code to be tested")
        private StringDt myResponseCode;
        @Child(name="sourceId", type={IdDt.class}, order=14, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Fixture to evaluate the XPath/JSONPath expression or the headerField  against.")
        private IdDt mySourceId;
        @Child(name="validateProfileId", type={IdDt.class}, order=15, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The ID of the Profile to validate against.")
        private IdDt myValidateProfileId;
        @Child(name="value", type={StringDt.class}, order=16, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The value to compare to")
        private StringDt myValue;
        @Child(name="warningOnly", type={BooleanDt.class}, order=17, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Whether or not the test execution will produce a warning only on error for this assert")
        private BooleanDt myWarningOnly;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myLabel, this.myDescription, this.myDirection, this.myCompareToSourceId, this.myCompareToSourcePath, this.myContentType, this.myHeaderField, this.myMinimumId, this.myNavigationLinks, this.myOperator, this.myPath, this.myResource, this.myResponse, this.myResponseCode, this.mySourceId, this.myValidateProfileId, this.myValue, this.myWarningOnly});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myLabel, this.myDescription, this.myDirection, this.myCompareToSourceId, this.myCompareToSourcePath, this.myContentType, this.myHeaderField, this.myMinimumId, this.myNavigationLinks, this.myOperator, this.myPath, this.myResource, this.myResponse, this.myResponseCode, this.mySourceId, this.myValidateProfileId, this.myValue, this.myWarningOnly});
        }

        public StringDt getLabelElement() {
            if (this.myLabel == null) {
                this.myLabel = new StringDt();
            }
            return this.myLabel;
        }

        public String getLabel() {
            return (String)this.getLabelElement().getValue();
        }

        public SetupActionAssert setLabel(StringDt theValue) {
            this.myLabel = theValue;
            return this;
        }

        public SetupActionAssert setLabel(String theString) {
            this.myLabel = new StringDt(theString);
            return this;
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public String getDescription() {
            return (String)this.getDescriptionElement().getValue();
        }

        public SetupActionAssert setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public SetupActionAssert setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }

        public BoundCodeDt<AssertionDirectionTypeEnum> getDirectionElement() {
            if (this.myDirection == null) {
                this.myDirection = new BoundCodeDt(AssertionDirectionTypeEnum.VALUESET_BINDER);
            }
            return this.myDirection;
        }

        public String getDirection() {
            return (String)this.getDirectionElement().getValue();
        }

        public SetupActionAssert setDirection(BoundCodeDt<AssertionDirectionTypeEnum> theValue) {
            this.myDirection = theValue;
            return this;
        }

        public SetupActionAssert setDirection(AssertionDirectionTypeEnum theValue) {
            this.setDirection((BoundCodeDt<AssertionDirectionTypeEnum>)new BoundCodeDt(AssertionDirectionTypeEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public StringDt getCompareToSourceIdElement() {
            if (this.myCompareToSourceId == null) {
                this.myCompareToSourceId = new StringDt();
            }
            return this.myCompareToSourceId;
        }

        public String getCompareToSourceId() {
            return (String)this.getCompareToSourceIdElement().getValue();
        }

        public SetupActionAssert setCompareToSourceId(StringDt theValue) {
            this.myCompareToSourceId = theValue;
            return this;
        }

        public SetupActionAssert setCompareToSourceId(String theString) {
            this.myCompareToSourceId = new StringDt(theString);
            return this;
        }

        public StringDt getCompareToSourcePathElement() {
            if (this.myCompareToSourcePath == null) {
                this.myCompareToSourcePath = new StringDt();
            }
            return this.myCompareToSourcePath;
        }

        public String getCompareToSourcePath() {
            return (String)this.getCompareToSourcePathElement().getValue();
        }

        public SetupActionAssert setCompareToSourcePath(StringDt theValue) {
            this.myCompareToSourcePath = theValue;
            return this;
        }

        public SetupActionAssert setCompareToSourcePath(String theString) {
            this.myCompareToSourcePath = new StringDt(theString);
            return this;
        }

        public BoundCodeDt<ContentTypeEnum> getContentTypeElement() {
            if (this.myContentType == null) {
                this.myContentType = new BoundCodeDt(ContentTypeEnum.VALUESET_BINDER);
            }
            return this.myContentType;
        }

        public String getContentType() {
            return (String)this.getContentTypeElement().getValue();
        }

        public SetupActionAssert setContentType(BoundCodeDt<ContentTypeEnum> theValue) {
            this.myContentType = theValue;
            return this;
        }

        public SetupActionAssert setContentType(ContentTypeEnum theValue) {
            this.setContentType((BoundCodeDt<ContentTypeEnum>)new BoundCodeDt(ContentTypeEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public StringDt getHeaderFieldElement() {
            if (this.myHeaderField == null) {
                this.myHeaderField = new StringDt();
            }
            return this.myHeaderField;
        }

        public String getHeaderField() {
            return (String)this.getHeaderFieldElement().getValue();
        }

        public SetupActionAssert setHeaderField(StringDt theValue) {
            this.myHeaderField = theValue;
            return this;
        }

        public SetupActionAssert setHeaderField(String theString) {
            this.myHeaderField = new StringDt(theString);
            return this;
        }

        public StringDt getMinimumIdElement() {
            if (this.myMinimumId == null) {
                this.myMinimumId = new StringDt();
            }
            return this.myMinimumId;
        }

        public String getMinimumId() {
            return (String)this.getMinimumIdElement().getValue();
        }

        public SetupActionAssert setMinimumId(StringDt theValue) {
            this.myMinimumId = theValue;
            return this;
        }

        public SetupActionAssert setMinimumId(String theString) {
            this.myMinimumId = new StringDt(theString);
            return this;
        }

        public BooleanDt getNavigationLinksElement() {
            if (this.myNavigationLinks == null) {
                this.myNavigationLinks = new BooleanDt();
            }
            return this.myNavigationLinks;
        }

        public Boolean getNavigationLinks() {
            return (Boolean)this.getNavigationLinksElement().getValue();
        }

        public SetupActionAssert setNavigationLinks(BooleanDt theValue) {
            this.myNavigationLinks = theValue;
            return this;
        }

        public SetupActionAssert setNavigationLinks(boolean theBoolean) {
            this.myNavigationLinks = new BooleanDt(theBoolean);
            return this;
        }

        public BoundCodeDt<AssertionOperatorTypeEnum> getOperatorElement() {
            if (this.myOperator == null) {
                this.myOperator = new BoundCodeDt(AssertionOperatorTypeEnum.VALUESET_BINDER);
            }
            return this.myOperator;
        }

        public String getOperator() {
            return (String)this.getOperatorElement().getValue();
        }

        public SetupActionAssert setOperator(BoundCodeDt<AssertionOperatorTypeEnum> theValue) {
            this.myOperator = theValue;
            return this;
        }

        public SetupActionAssert setOperator(AssertionOperatorTypeEnum theValue) {
            this.setOperator((BoundCodeDt<AssertionOperatorTypeEnum>)new BoundCodeDt(AssertionOperatorTypeEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public StringDt getPathElement() {
            if (this.myPath == null) {
                this.myPath = new StringDt();
            }
            return this.myPath;
        }

        public String getPath() {
            return (String)this.getPathElement().getValue();
        }

        public SetupActionAssert setPath(StringDt theValue) {
            this.myPath = theValue;
            return this;
        }

        public SetupActionAssert setPath(String theString) {
            this.myPath = new StringDt(theString);
            return this;
        }

        public CodeDt getResourceElement() {
            if (this.myResource == null) {
                this.myResource = new CodeDt();
            }
            return this.myResource;
        }

        public String getResource() {
            return (String)this.getResourceElement().getValue();
        }

        public SetupActionAssert setResource(CodeDt theValue) {
            this.myResource = theValue;
            return this;
        }

        public SetupActionAssert setResource(String theCode) {
            this.myResource = new CodeDt(theCode);
            return this;
        }

        public BoundCodeDt<AssertionResponseTypesEnum> getResponseElement() {
            if (this.myResponse == null) {
                this.myResponse = new BoundCodeDt(AssertionResponseTypesEnum.VALUESET_BINDER);
            }
            return this.myResponse;
        }

        public String getResponse() {
            return (String)this.getResponseElement().getValue();
        }

        public SetupActionAssert setResponse(BoundCodeDt<AssertionResponseTypesEnum> theValue) {
            this.myResponse = theValue;
            return this;
        }

        public SetupActionAssert setResponse(AssertionResponseTypesEnum theValue) {
            this.setResponse((BoundCodeDt<AssertionResponseTypesEnum>)new BoundCodeDt(AssertionResponseTypesEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public StringDt getResponseCodeElement() {
            if (this.myResponseCode == null) {
                this.myResponseCode = new StringDt();
            }
            return this.myResponseCode;
        }

        public String getResponseCode() {
            return (String)this.getResponseCodeElement().getValue();
        }

        public SetupActionAssert setResponseCode(StringDt theValue) {
            this.myResponseCode = theValue;
            return this;
        }

        public SetupActionAssert setResponseCode(String theString) {
            this.myResponseCode = new StringDt(theString);
            return this;
        }

        public IdDt getSourceIdElement() {
            if (this.mySourceId == null) {
                this.mySourceId = new IdDt();
            }
            return this.mySourceId;
        }

        public String getSourceId() {
            return this.getSourceIdElement().getValue();
        }

        public SetupActionAssert setSourceId(IdDt theValue) {
            this.mySourceId = theValue;
            return this;
        }

        public SetupActionAssert setSourceId(String theId) {
            this.mySourceId = new IdDt(theId);
            return this;
        }

        public IdDt getValidateProfileIdElement() {
            if (this.myValidateProfileId == null) {
                this.myValidateProfileId = new IdDt();
            }
            return this.myValidateProfileId;
        }

        public String getValidateProfileId() {
            return this.getValidateProfileIdElement().getValue();
        }

        public SetupActionAssert setValidateProfileId(IdDt theValue) {
            this.myValidateProfileId = theValue;
            return this;
        }

        public SetupActionAssert setValidateProfileId(String theId) {
            this.myValidateProfileId = new IdDt(theId);
            return this;
        }

        public StringDt getValueElement() {
            if (this.myValue == null) {
                this.myValue = new StringDt();
            }
            return this.myValue;
        }

        public String getValue() {
            return (String)this.getValueElement().getValue();
        }

        public SetupActionAssert setValue(StringDt theValue) {
            this.myValue = theValue;
            return this;
        }

        public SetupActionAssert setValue(String theString) {
            this.myValue = new StringDt(theString);
            return this;
        }

        public BooleanDt getWarningOnlyElement() {
            if (this.myWarningOnly == null) {
                this.myWarningOnly = new BooleanDt();
            }
            return this.myWarningOnly;
        }

        public Boolean getWarningOnly() {
            return (Boolean)this.getWarningOnlyElement().getValue();
        }

        public SetupActionAssert setWarningOnly(BooleanDt theValue) {
            this.myWarningOnly = theValue;
            return this;
        }

        public SetupActionAssert setWarningOnly(boolean theBoolean) {
            this.myWarningOnly = new BooleanDt(theBoolean);
            return this;
        }
    }

    @Block
    public static class SetupActionOperationRequestHeader
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="field", type={StringDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The HTTP header field e.g. \"Accept\"")
        private StringDt myField;
        @Child(name="value", type={StringDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The value of the header e.g. \"application/xml\"")
        private StringDt myValue;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myField, this.myValue});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myField, this.myValue});
        }

        public StringDt getFieldElement() {
            if (this.myField == null) {
                this.myField = new StringDt();
            }
            return this.myField;
        }

        public String getField() {
            return (String)this.getFieldElement().getValue();
        }

        public SetupActionOperationRequestHeader setField(StringDt theValue) {
            this.myField = theValue;
            return this;
        }

        public SetupActionOperationRequestHeader setField(String theString) {
            this.myField = new StringDt(theString);
            return this;
        }

        public StringDt getValueElement() {
            if (this.myValue == null) {
                this.myValue = new StringDt();
            }
            return this.myValue;
        }

        public String getValue() {
            return (String)this.getValueElement().getValue();
        }

        public SetupActionOperationRequestHeader setValue(StringDt theValue) {
            this.myValue = theValue;
            return this;
        }

        public SetupActionOperationRequestHeader setValue(String theString) {
            this.myValue = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class SetupActionOperation
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodingDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Server interaction or operation type")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/valueset-testscript-operation-codes")
        private CodingDt myType;
        @Child(name="resource", type={CodeDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The type of the resource.  See http://hl7-fhir.github.io/resourcelist.html.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/defined-types")
        private CodeDt myResource;
        @Child(name="label", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The label would be used for tracking/logging purposes by test engines.")
        private StringDt myLabel;
        @Child(name="description", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The description would be used by test engines for tracking and reporting purposes.")
        private StringDt myDescription;
        @Child(name="accept", type={CodeDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The content-type or mime-type to use for RESTful operation in the 'Accept' header.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/content-type")
        private BoundCodeDt<ContentTypeEnum> myAccept;
        @Child(name="contentType", type={CodeDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The content-type or mime-type to use for RESTful operation in the 'Content-Type' header.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/content-type")
        private BoundCodeDt<ContentTypeEnum> myContentType;
        @Child(name="destination", type={IntegerDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Which server to perform the operation on.")
        private IntegerDt myDestination;
        @Child(name="encodeRequestUrl", type={BooleanDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Whether or not to implicitly send the request url in encoded format. The default is true to match the standard RESTful client behavior. Set to false when communicating with a server that does not support encoded url paths.")
        private BooleanDt myEncodeRequestUrl;
        @Child(name="params", type={StringDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Path plus parameters after [type].  Used to set parts of the request URL explicitly.")
        private StringDt myParams;
        @Child(name="requestHeader", order=9, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Header elements would be used to set HTTP headers.")
        private List<SetupActionOperationRequestHeader> myRequestHeader;
        @Child(name="responseId", type={IdDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The fixture id (maybe new) to map to the response.")
        private IdDt myResponseId;
        @Child(name="sourceId", type={IdDt.class}, order=11, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The id of the fixture used as the body of a PUT or POST request.")
        private IdDt mySourceId;
        @Child(name="targetId", type={IdDt.class}, order=12, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Id of fixture used for extracting the [id],  [type], and [vid] for GET requests")
        private IdDt myTargetId;
        @Child(name="url", type={StringDt.class}, order=13, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Complete request URL.")
        private StringDt myUrl;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myType, this.myResource, this.myLabel, this.myDescription, this.myAccept, this.myContentType, this.myDestination, this.myEncodeRequestUrl, this.myParams, this.myRequestHeader, this.myResponseId, this.mySourceId, this.myTargetId, this.myUrl});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myResource, this.myLabel, this.myDescription, this.myAccept, this.myContentType, this.myDestination, this.myEncodeRequestUrl, this.myParams, this.myRequestHeader, this.myResponseId, this.mySourceId, this.myTargetId, this.myUrl});
        }

        public CodingDt getType() {
            if (this.myType == null) {
                this.myType = new CodingDt();
            }
            return this.myType;
        }

        public SetupActionOperation setType(CodingDt theValue) {
            this.myType = theValue;
            return this;
        }

        public CodeDt getResourceElement() {
            if (this.myResource == null) {
                this.myResource = new CodeDt();
            }
            return this.myResource;
        }

        public String getResource() {
            return (String)this.getResourceElement().getValue();
        }

        public SetupActionOperation setResource(CodeDt theValue) {
            this.myResource = theValue;
            return this;
        }

        public SetupActionOperation setResource(String theCode) {
            this.myResource = new CodeDt(theCode);
            return this;
        }

        public StringDt getLabelElement() {
            if (this.myLabel == null) {
                this.myLabel = new StringDt();
            }
            return this.myLabel;
        }

        public String getLabel() {
            return (String)this.getLabelElement().getValue();
        }

        public SetupActionOperation setLabel(StringDt theValue) {
            this.myLabel = theValue;
            return this;
        }

        public SetupActionOperation setLabel(String theString) {
            this.myLabel = new StringDt(theString);
            return this;
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public String getDescription() {
            return (String)this.getDescriptionElement().getValue();
        }

        public SetupActionOperation setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public SetupActionOperation setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }

        public BoundCodeDt<ContentTypeEnum> getAcceptElement() {
            if (this.myAccept == null) {
                this.myAccept = new BoundCodeDt(ContentTypeEnum.VALUESET_BINDER);
            }
            return this.myAccept;
        }

        public String getAccept() {
            return (String)this.getAcceptElement().getValue();
        }

        public SetupActionOperation setAccept(BoundCodeDt<ContentTypeEnum> theValue) {
            this.myAccept = theValue;
            return this;
        }

        public SetupActionOperation setAccept(ContentTypeEnum theValue) {
            this.setAccept((BoundCodeDt<ContentTypeEnum>)new BoundCodeDt(ContentTypeEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public BoundCodeDt<ContentTypeEnum> getContentTypeElement() {
            if (this.myContentType == null) {
                this.myContentType = new BoundCodeDt(ContentTypeEnum.VALUESET_BINDER);
            }
            return this.myContentType;
        }

        public String getContentType() {
            return (String)this.getContentTypeElement().getValue();
        }

        public SetupActionOperation setContentType(BoundCodeDt<ContentTypeEnum> theValue) {
            this.myContentType = theValue;
            return this;
        }

        public SetupActionOperation setContentType(ContentTypeEnum theValue) {
            this.setContentType((BoundCodeDt<ContentTypeEnum>)new BoundCodeDt(ContentTypeEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public IntegerDt getDestinationElement() {
            if (this.myDestination == null) {
                this.myDestination = new IntegerDt();
            }
            return this.myDestination;
        }

        public Integer getDestination() {
            return (Integer)this.getDestinationElement().getValue();
        }

        public SetupActionOperation setDestination(IntegerDt theValue) {
            this.myDestination = theValue;
            return this;
        }

        public SetupActionOperation setDestination(int theInteger) {
            this.myDestination = new IntegerDt(theInteger);
            return this;
        }

        public BooleanDt getEncodeRequestUrlElement() {
            if (this.myEncodeRequestUrl == null) {
                this.myEncodeRequestUrl = new BooleanDt();
            }
            return this.myEncodeRequestUrl;
        }

        public Boolean getEncodeRequestUrl() {
            return (Boolean)this.getEncodeRequestUrlElement().getValue();
        }

        public SetupActionOperation setEncodeRequestUrl(BooleanDt theValue) {
            this.myEncodeRequestUrl = theValue;
            return this;
        }

        public SetupActionOperation setEncodeRequestUrl(boolean theBoolean) {
            this.myEncodeRequestUrl = new BooleanDt(theBoolean);
            return this;
        }

        public StringDt getParamsElement() {
            if (this.myParams == null) {
                this.myParams = new StringDt();
            }
            return this.myParams;
        }

        public String getParams() {
            return (String)this.getParamsElement().getValue();
        }

        public SetupActionOperation setParams(StringDt theValue) {
            this.myParams = theValue;
            return this;
        }

        public SetupActionOperation setParams(String theString) {
            this.myParams = new StringDt(theString);
            return this;
        }

        public List<SetupActionOperationRequestHeader> getRequestHeader() {
            if (this.myRequestHeader == null) {
                this.myRequestHeader = new ArrayList<SetupActionOperationRequestHeader>();
            }
            return this.myRequestHeader;
        }

        public SetupActionOperation setRequestHeader(List<SetupActionOperationRequestHeader> theValue) {
            this.myRequestHeader = theValue;
            return this;
        }

        public SetupActionOperationRequestHeader addRequestHeader() {
            SetupActionOperationRequestHeader newType = new SetupActionOperationRequestHeader();
            this.getRequestHeader().add(newType);
            return newType;
        }

        public SetupActionOperation addRequestHeader(SetupActionOperationRequestHeader theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getRequestHeader().add(theValue);
            return this;
        }

        public SetupActionOperationRequestHeader getRequestHeaderFirstRep() {
            if (this.getRequestHeader().isEmpty()) {
                return this.addRequestHeader();
            }
            return this.getRequestHeader().get(0);
        }

        public IdDt getResponseIdElement() {
            if (this.myResponseId == null) {
                this.myResponseId = new IdDt();
            }
            return this.myResponseId;
        }

        public String getResponseId() {
            return this.getResponseIdElement().getValue();
        }

        public SetupActionOperation setResponseId(IdDt theValue) {
            this.myResponseId = theValue;
            return this;
        }

        public SetupActionOperation setResponseId(String theId) {
            this.myResponseId = new IdDt(theId);
            return this;
        }

        public IdDt getSourceIdElement() {
            if (this.mySourceId == null) {
                this.mySourceId = new IdDt();
            }
            return this.mySourceId;
        }

        public String getSourceId() {
            return this.getSourceIdElement().getValue();
        }

        public SetupActionOperation setSourceId(IdDt theValue) {
            this.mySourceId = theValue;
            return this;
        }

        public SetupActionOperation setSourceId(String theId) {
            this.mySourceId = new IdDt(theId);
            return this;
        }

        public IdDt getTargetIdElement() {
            if (this.myTargetId == null) {
                this.myTargetId = new IdDt();
            }
            return this.myTargetId;
        }

        public String getTargetId() {
            return this.getTargetIdElement().getValue();
        }

        public SetupActionOperation setTargetId(IdDt theValue) {
            this.myTargetId = theValue;
            return this;
        }

        public SetupActionOperation setTargetId(String theId) {
            this.myTargetId = new IdDt(theId);
            return this;
        }

        public StringDt getUrlElement() {
            if (this.myUrl == null) {
                this.myUrl = new StringDt();
            }
            return this.myUrl;
        }

        public String getUrl() {
            return (String)this.getUrlElement().getValue();
        }

        public SetupActionOperation setUrl(StringDt theValue) {
            this.myUrl = theValue;
            return this;
        }

        public SetupActionOperation setUrl(String theString) {
            this.myUrl = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class SetupAction
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="operation", order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The operation to perform")
        private SetupActionOperation myOperation;
        @Child(name="assert", order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Evaluates the results of previous operations to determine if the server under test behaves appropriately.")
        private SetupActionAssert myAssert;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myOperation, this.myAssert});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myOperation, this.myAssert});
        }

        public SetupActionOperation getOperation() {
            if (this.myOperation == null) {
                this.myOperation = new SetupActionOperation();
            }
            return this.myOperation;
        }

        public SetupAction setOperation(SetupActionOperation theValue) {
            this.myOperation = theValue;
            return this;
        }

        public SetupActionAssert getAssert() {
            if (this.myAssert == null) {
                this.myAssert = new SetupActionAssert();
            }
            return this.myAssert;
        }

        public SetupAction setAssert(SetupActionAssert theValue) {
            this.myAssert = theValue;
            return this;
        }
    }

    @Block
    public static class MetadataCapability
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="required", type={BooleanDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Whether or not the test execution will require the given capabilities of the server in order for this test script to execute.")
        private BooleanDt myRequired;
        @Child(name="validated", type={BooleanDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Whether or not the test execution will validate the given capabilities of the server in order for this test script to execute.")
        private BooleanDt myValidated;
        @Child(name="description", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Description of the capabilities that this test script is requiring the server to support.")
        private StringDt myDescription;
        @Child(name="destination", type={IntegerDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Which server these requirements apply to.")
        private IntegerDt myDestination;
        @Child(name="link", type={UriDt.class}, order=4, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Links to the FHIR specification that describes this interaction and the resources involved in more detail.")
        private List<UriDt> myLink;
        @Child(name="conformance", order=5, min=1, max=1, summary=false, modifier=false, type={Conformance.class})
        @Description(shortDefinition="", formalDefinition="Minimum conformance required of server for test script to execute successfully.   If server does not meet at a minimum the reference conformance definition, then all tests in this script are skipped.")
        private ResourceReferenceDt myConformance;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myRequired, this.myValidated, this.myDescription, this.myDestination, this.myLink, this.myConformance});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myRequired, this.myValidated, this.myDescription, this.myDestination, this.myLink, this.myConformance});
        }

        public BooleanDt getRequiredElement() {
            if (this.myRequired == null) {
                this.myRequired = new BooleanDt();
            }
            return this.myRequired;
        }

        public Boolean getRequired() {
            return (Boolean)this.getRequiredElement().getValue();
        }

        public MetadataCapability setRequired(BooleanDt theValue) {
            this.myRequired = theValue;
            return this;
        }

        public MetadataCapability setRequired(boolean theBoolean) {
            this.myRequired = new BooleanDt(theBoolean);
            return this;
        }

        public BooleanDt getValidatedElement() {
            if (this.myValidated == null) {
                this.myValidated = new BooleanDt();
            }
            return this.myValidated;
        }

        public Boolean getValidated() {
            return (Boolean)this.getValidatedElement().getValue();
        }

        public MetadataCapability setValidated(BooleanDt theValue) {
            this.myValidated = theValue;
            return this;
        }

        public MetadataCapability setValidated(boolean theBoolean) {
            this.myValidated = new BooleanDt(theBoolean);
            return this;
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public String getDescription() {
            return (String)this.getDescriptionElement().getValue();
        }

        public MetadataCapability setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public MetadataCapability setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }

        public IntegerDt getDestinationElement() {
            if (this.myDestination == null) {
                this.myDestination = new IntegerDt();
            }
            return this.myDestination;
        }

        public Integer getDestination() {
            return (Integer)this.getDestinationElement().getValue();
        }

        public MetadataCapability setDestination(IntegerDt theValue) {
            this.myDestination = theValue;
            return this;
        }

        public MetadataCapability setDestination(int theInteger) {
            this.myDestination = new IntegerDt(theInteger);
            return this;
        }

        public List<UriDt> getLink() {
            if (this.myLink == null) {
                this.myLink = new ArrayList<UriDt>();
            }
            return this.myLink;
        }

        public MetadataCapability setLink(List<UriDt> theValue) {
            this.myLink = theValue;
            return this;
        }

        public UriDt addLink() {
            UriDt newType = new UriDt();
            this.getLink().add(newType);
            return newType;
        }

        public MetadataCapability addLink(UriDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getLink().add(theValue);
            return this;
        }

        public UriDt getLinkFirstRep() {
            if (this.getLink().isEmpty()) {
                return this.addLink();
            }
            return this.getLink().get(0);
        }

        public MetadataCapability addLink(String theUri) {
            if (this.myLink == null) {
                this.myLink = new ArrayList<UriDt>();
            }
            this.myLink.add(new UriDt(theUri));
            return this;
        }

        public ResourceReferenceDt getConformance() {
            if (this.myConformance == null) {
                this.myConformance = new ResourceReferenceDt();
            }
            return this.myConformance;
        }

        public MetadataCapability setConformance(ResourceReferenceDt theValue) {
            this.myConformance = theValue;
            return this;
        }
    }

    @Block
    public static class MetadataLink
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="url", type={UriDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="URL to a particular requirement or feature within the FHIR specification.")
        private UriDt myUrl;
        @Child(name="description", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Short description of the link.")
        private StringDt myDescription;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myUrl, this.myDescription});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myUrl, this.myDescription});
        }

        public UriDt getUrlElement() {
            if (this.myUrl == null) {
                this.myUrl = new UriDt();
            }
            return this.myUrl;
        }

        public String getUrl() {
            return (String)this.getUrlElement().getValue();
        }

        public MetadataLink setUrl(UriDt theValue) {
            this.myUrl = theValue;
            return this;
        }

        public MetadataLink setUrl(String theUri) {
            this.myUrl = new UriDt(theUri);
            return this;
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public String getDescription() {
            return (String)this.getDescriptionElement().getValue();
        }

        public MetadataLink setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public MetadataLink setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }
    }
}

