/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.BoundCodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.ContactPointDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.valueset.ConformanceResourceStatusEnum;
import ca.uhn.fhir.model.dstu2.valueset.IdentifierTypeCodesEnum;
import ca.uhn.fhir.model.dstu2.valueset.NamingSystemIdentifierTypeEnum;
import ca.uhn.fhir.model.dstu2.valueset.NamingSystemTypeEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="NamingSystem", profile="http://hl7.org/fhir/profiles/NamingSystem", id="namingsystem")
public class NamingSystem
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="type", path="NamingSystem.type", description="", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="name", path="NamingSystem.name", description="", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="date", path="NamingSystem.date", description="", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="status", path="NamingSystem.status", description="", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="kind", path="NamingSystem.kind", description="", type="token")
    public static final String SP_KIND = "kind";
    public static final TokenClientParam KIND = new TokenClientParam("kind");
    @SearchParamDefinition(name="responsible", path="NamingSystem.responsible", description="", type="string")
    public static final String SP_RESPONSIBLE = "responsible";
    public static final StringClientParam RESPONSIBLE = new StringClientParam("responsible");
    @SearchParamDefinition(name="id-type", path="NamingSystem.uniqueId.type", description="", type="token")
    public static final String SP_ID_TYPE = "id-type";
    public static final TokenClientParam ID_TYPE = new TokenClientParam("id-type");
    @SearchParamDefinition(name="value", path="NamingSystem.uniqueId.value", description="", type="string")
    public static final String SP_VALUE = "value";
    public static final StringClientParam VALUE = new StringClientParam("value");
    @SearchParamDefinition(name="period", path="NamingSystem.uniqueId.period", description="", type="date")
    public static final String SP_PERIOD = "period";
    public static final DateClientParam PERIOD = new DateClientParam("period");
    @SearchParamDefinition(name="publisher", path="NamingSystem.publisher", description="", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="contact", path="NamingSystem.contact.name", description="", type="string")
    public static final String SP_CONTACT = "contact";
    public static final StringClientParam CONTACT = new StringClientParam("contact");
    @SearchParamDefinition(name="telecom", path="NamingSystem.contact.telecom", description="", type="token")
    public static final String SP_TELECOM = "telecom";
    public static final TokenClientParam TELECOM = new TokenClientParam("telecom");
    @SearchParamDefinition(name="replaced-by", path="NamingSystem.replacedBy", description="", type="reference")
    public static final String SP_REPLACED_BY = "replaced-by";
    public static final ReferenceClientParam REPLACED_BY = new ReferenceClientParam("replaced-by");
    @SearchParamDefinition(name="context", path="NamingSystem.useContext", description="", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    public static final Include INCLUDE_REPLACED_BY = new Include("NamingSystem:replaced-by");
    @Child(name="name", type={StringDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The descriptive name of this particular identifier type or code system")
    private StringDt myName;
    @Child(name="status", type={CodeDt.class}, order=1, min=1, max=1, summary=false, modifier=true)
    @Description(shortDefinition="status", formalDefinition="Indicates whether the naming system is \"ready for use\" or not.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/conformance-resource-status")
    private BoundCodeDt<ConformanceResourceStatusEnum> myStatus;
    @Child(name="kind", type={CodeDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="class", formalDefinition="Indicates the purpose for the naming system - what kinds of things does it make unique?")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/namingsystem-type")
    private BoundCodeDt<NamingSystemTypeEnum> myKind;
    @Child(name="publisher", type={StringDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="who.witness", formalDefinition="The name of the individual or organization that published the naming system")
    private StringDt myPublisher;
    @Child(name="contact", order=4, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Contacts to assist a user in finding and communicating with the publisher")
    private List<Contact> myContact;
    @Child(name="responsible", type={StringDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="who.witness", formalDefinition="The name of the organization that is responsible for issuing identifiers or codes for this namespace and ensuring their non-collision.")
    private StringDt myResponsible;
    @Child(name="date", type={DateTimeDt.class}, order=6, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="when.recorded", formalDefinition="The date  (and optionally time) when the system was registered or published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the registration changes")
    private DateTimeDt myDate;
    @Child(name="type", type={CodeableConceptDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Categorizes a naming system for easier search by grouping related naming systems.")
    private BoundCodeableConceptDt<IdentifierTypeCodesEnum> myType;
    @Child(name="description", type={StringDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Details about what the namespace identifies including scope, granularity, version labeling, etc.")
    private StringDt myDescription;
    @Child(name="useContext", type={CodeableConceptDt.class}, order=9, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of naming systems")
    private List<CodeableConceptDt> myUseContext;
    @Child(name="usage", type={StringDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Provides guidance on the use of the namespace, including the handling of formatting characters, use of upper vs. lower case, etc.")
    private StringDt myUsage;
    @Child(name="uniqueId", order=11, min=1, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indicates how the system may be identified when referenced in electronic exchange")
    private List<UniqueId> myUniqueId;
    @Child(name="replacedBy", order=12, min=0, max=1, summary=false, modifier=false, type={NamingSystem.class})
    @Description(shortDefinition="", formalDefinition="For naming systems that are retired, indicates the naming system that should be used in their place (if any)")
    private ResourceReferenceDt myReplacedBy;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myName, this.myStatus, this.myKind, this.myPublisher, this.myContact, this.myResponsible, this.myDate, this.myType, this.myDescription, this.myUseContext, this.myUsage, this.myUniqueId, this.myReplacedBy});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myStatus, this.myKind, this.myPublisher, this.myContact, this.myResponsible, this.myDate, this.myType, this.myDescription, this.myUseContext, this.myUsage, this.myUniqueId, this.myReplacedBy});
    }

    public StringDt getNameElement() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public String getName() {
        return (String)this.getNameElement().getValue();
    }

    public NamingSystem setName(StringDt theValue) {
        this.myName = theValue;
        return this;
    }

    public NamingSystem setName(String theString) {
        this.myName = new StringDt(theString);
        return this;
    }

    public BoundCodeDt<ConformanceResourceStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ConformanceResourceStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public NamingSystem setStatus(BoundCodeDt<ConformanceResourceStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public NamingSystem setStatus(ConformanceResourceStatusEnum theValue) {
        this.setStatus((BoundCodeDt<ConformanceResourceStatusEnum>)new BoundCodeDt(ConformanceResourceStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public BoundCodeDt<NamingSystemTypeEnum> getKindElement() {
        if (this.myKind == null) {
            this.myKind = new BoundCodeDt(NamingSystemTypeEnum.VALUESET_BINDER);
        }
        return this.myKind;
    }

    public String getKind() {
        return (String)this.getKindElement().getValue();
    }

    public NamingSystem setKind(BoundCodeDt<NamingSystemTypeEnum> theValue) {
        this.myKind = theValue;
        return this;
    }

    public NamingSystem setKind(NamingSystemTypeEnum theValue) {
        this.setKind((BoundCodeDt<NamingSystemTypeEnum>)new BoundCodeDt(NamingSystemTypeEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public StringDt getPublisherElement() {
        if (this.myPublisher == null) {
            this.myPublisher = new StringDt();
        }
        return this.myPublisher;
    }

    public String getPublisher() {
        return (String)this.getPublisherElement().getValue();
    }

    public NamingSystem setPublisher(StringDt theValue) {
        this.myPublisher = theValue;
        return this;
    }

    public NamingSystem setPublisher(String theString) {
        this.myPublisher = new StringDt(theString);
        return this;
    }

    public List<Contact> getContact() {
        if (this.myContact == null) {
            this.myContact = new ArrayList<Contact>();
        }
        return this.myContact;
    }

    public NamingSystem setContact(List<Contact> theValue) {
        this.myContact = theValue;
        return this;
    }

    public Contact addContact() {
        Contact newType = new Contact();
        this.getContact().add(newType);
        return newType;
    }

    public NamingSystem addContact(Contact theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getContact().add(theValue);
        return this;
    }

    public Contact getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            return this.addContact();
        }
        return this.getContact().get(0);
    }

    public StringDt getResponsibleElement() {
        if (this.myResponsible == null) {
            this.myResponsible = new StringDt();
        }
        return this.myResponsible;
    }

    public String getResponsible() {
        return (String)this.getResponsibleElement().getValue();
    }

    public NamingSystem setResponsible(StringDt theValue) {
        this.myResponsible = theValue;
        return this;
    }

    public NamingSystem setResponsible(String theString) {
        this.myResponsible = new StringDt(theString);
        return this;
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public Date getDate() {
        return (Date)this.getDateElement().getValue();
    }

    public NamingSystem setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public NamingSystem setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public NamingSystem setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public BoundCodeableConceptDt<IdentifierTypeCodesEnum> getType() {
        if (this.myType == null) {
            this.myType = new BoundCodeableConceptDt<IdentifierTypeCodesEnum>(IdentifierTypeCodesEnum.VALUESET_BINDER);
        }
        return this.myType;
    }

    public NamingSystem setType(BoundCodeableConceptDt<IdentifierTypeCodesEnum> theValue) {
        this.myType = theValue;
        return this;
    }

    public NamingSystem setType(IdentifierTypeCodesEnum theValue) {
        this.setType(new BoundCodeableConceptDt<IdentifierTypeCodesEnum>(IdentifierTypeCodesEnum.VALUESET_BINDER, theValue));
        return this;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public String getDescription() {
        return (String)this.getDescriptionElement().getValue();
    }

    public NamingSystem setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public NamingSystem setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public List<CodeableConceptDt> getUseContext() {
        if (this.myUseContext == null) {
            this.myUseContext = new ArrayList<CodeableConceptDt>();
        }
        return this.myUseContext;
    }

    public NamingSystem setUseContext(List<CodeableConceptDt> theValue) {
        this.myUseContext = theValue;
        return this;
    }

    public CodeableConceptDt addUseContext() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getUseContext().add(newType);
        return newType;
    }

    public NamingSystem addUseContext(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getUseContext().add(theValue);
        return this;
    }

    public CodeableConceptDt getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            return this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    public StringDt getUsageElement() {
        if (this.myUsage == null) {
            this.myUsage = new StringDt();
        }
        return this.myUsage;
    }

    public String getUsage() {
        return (String)this.getUsageElement().getValue();
    }

    public NamingSystem setUsage(StringDt theValue) {
        this.myUsage = theValue;
        return this;
    }

    public NamingSystem setUsage(String theString) {
        this.myUsage = new StringDt(theString);
        return this;
    }

    public List<UniqueId> getUniqueId() {
        if (this.myUniqueId == null) {
            this.myUniqueId = new ArrayList<UniqueId>();
        }
        return this.myUniqueId;
    }

    public NamingSystem setUniqueId(List<UniqueId> theValue) {
        this.myUniqueId = theValue;
        return this;
    }

    public UniqueId addUniqueId() {
        UniqueId newType = new UniqueId();
        this.getUniqueId().add(newType);
        return newType;
    }

    public NamingSystem addUniqueId(UniqueId theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getUniqueId().add(theValue);
        return this;
    }

    public UniqueId getUniqueIdFirstRep() {
        if (this.getUniqueId().isEmpty()) {
            return this.addUniqueId();
        }
        return this.getUniqueId().get(0);
    }

    public ResourceReferenceDt getReplacedBy() {
        if (this.myReplacedBy == null) {
            this.myReplacedBy = new ResourceReferenceDt();
        }
        return this.myReplacedBy;
    }

    public NamingSystem setReplacedBy(ResourceReferenceDt theValue) {
        this.myReplacedBy = theValue;
        return this;
    }

    public String getResourceName() {
        return "NamingSystem";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Contact
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The name of an individual to contact regarding the naming system")
        private StringDt myName;
        @Child(name="telecom", type={ContactPointDt.class}, order=1, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Contact details for individual (if a name was provided) or the publisher")
        private List<ContactPointDt> myTelecom;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myName, this.myTelecom});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myTelecom});
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public String getName() {
            return (String)this.getNameElement().getValue();
        }

        public Contact setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Contact setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public List<ContactPointDt> getTelecom() {
            if (this.myTelecom == null) {
                this.myTelecom = new ArrayList<ContactPointDt>();
            }
            return this.myTelecom;
        }

        public Contact setTelecom(List<ContactPointDt> theValue) {
            this.myTelecom = theValue;
            return this;
        }

        public ContactPointDt addTelecom() {
            ContactPointDt newType = new ContactPointDt();
            this.getTelecom().add(newType);
            return newType;
        }

        public Contact addTelecom(ContactPointDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getTelecom().add(theValue);
            return this;
        }

        public ContactPointDt getTelecomFirstRep() {
            if (this.getTelecom().isEmpty()) {
                return this.addTelecom();
            }
            return this.getTelecom().get(0);
        }
    }

    @Block
    public static class UniqueId
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifies the unique identifier scheme used for this particular identifier.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/namingsystem-identifier-type")
        private BoundCodeDt<NamingSystemIdentifierTypeEnum> myType;
        @Child(name="value", type={StringDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="id", formalDefinition="The string that should be sent over the wire to identify the code system or identifier system")
        private StringDt myValue;
        @Child(name="preferred", type={BooleanDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Indicates whether this identifier is the \"preferred\" identifier of this type.")
        private BooleanDt myPreferred;
        @Child(name="period", type={PeriodDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifies the period of time over which this identifier is considered appropriate to refer to the naming system.  Outside of this window, the identifier might be non-deterministic")
        private PeriodDt myPeriod;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myType, this.myValue, this.myPreferred, this.myPeriod});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myValue, this.myPreferred, this.myPeriod});
        }

        public BoundCodeDt<NamingSystemIdentifierTypeEnum> getTypeElement() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(NamingSystemIdentifierTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public String getType() {
            return (String)this.getTypeElement().getValue();
        }

        public UniqueId setType(BoundCodeDt<NamingSystemIdentifierTypeEnum> theValue) {
            this.myType = theValue;
            return this;
        }

        public UniqueId setType(NamingSystemIdentifierTypeEnum theValue) {
            this.setType((BoundCodeDt<NamingSystemIdentifierTypeEnum>)new BoundCodeDt(NamingSystemIdentifierTypeEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public StringDt getValueElement() {
            if (this.myValue == null) {
                this.myValue = new StringDt();
            }
            return this.myValue;
        }

        public String getValue() {
            return (String)this.getValueElement().getValue();
        }

        public UniqueId setValue(StringDt theValue) {
            this.myValue = theValue;
            return this;
        }

        public UniqueId setValue(String theString) {
            this.myValue = new StringDt(theString);
            return this;
        }

        public BooleanDt getPreferredElement() {
            if (this.myPreferred == null) {
                this.myPreferred = new BooleanDt();
            }
            return this.myPreferred;
        }

        public Boolean getPreferred() {
            return (Boolean)this.getPreferredElement().getValue();
        }

        public UniqueId setPreferred(BooleanDt theValue) {
            this.myPreferred = theValue;
            return this;
        }

        public UniqueId setPreferred(boolean theBoolean) {
            this.myPreferred = new BooleanDt(theBoolean);
            return this;
        }

        public PeriodDt getPeriod() {
            if (this.myPeriod == null) {
                this.myPeriod = new PeriodDt();
            }
            return this.myPeriod;
        }

        public UniqueId setPeriod(PeriodDt theValue) {
            this.myPeriod = theValue;
            return this;
        }
    }
}

