/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageHelper {
    @Autowired
    private final IMdmSettings myMdmSettings;
    @Autowired
    private final FhirContext myFhirContext;

    public MessageHelper(IMdmSettings theMdmSettings, FhirContext theFhirContext) {
        this.myMdmSettings = theMdmSettings;
        this.myFhirContext = theFhirContext;
    }

    public String getMessageForUnmanagedResource() {
        return String.format("Only MDM managed resources can be merged. MDM managed resources must have the %s tag.", "HAPI-MDM");
    }

    public String getMessageForUnsupportedResource(String theName, IAnyResource theResource) {
        return this.getMessageForUnsupportedResource(theName, this.myFhirContext.getResourceType((IBaseResource)theResource));
    }

    public String getMessageForUnsupportedResource(String theName, String theResourceType) {
        return String.format("Only %s resources can be merged. The %s points to a %s", this.myMdmSettings.getSupportedMdmTypes(), theName, theResourceType);
    }

    public String getMessageForUnsupportedMatchResult() {
        return "Match Result may only be set to " + MdmMatchResultEnum.NO_MATCH + " or " + MdmMatchResultEnum.MATCH;
    }

    public String getMessageForUnsupportedFirstArgumentTypeInUpdate(String goldenRecordType) {
        return "First argument to $mdm-update-link must be a " + this.myMdmSettings.getSupportedMdmTypes() + ".  Was " + goldenRecordType;
    }

    public String getMessageForUnsupportedSecondArgumentTypeInUpdate(String theGoldenRecordType) {
        return "First argument to $mdm-update-link must be a " + this.myMdmSettings.getSupportedMdmTypes() + ".  Was " + theGoldenRecordType;
    }

    public String getMessageForArgumentTypeMismatchInUpdate(String theGoldenRecordType, String theSourceResourceType) {
        return "Arguments to $mdm-update-link must be of the same type. Were " + theGoldenRecordType + " and " + theSourceResourceType;
    }

    public String getMessageForUnsupportedSourceResource() {
        return "The source resource is marked with the NO-MDM tag which means it may not be MDM linked.";
    }

    public String getMessageForNoLink(IAnyResource theGoldenRecord, IAnyResource theSourceResource) {
        return this.getMessageForNoLink(theGoldenRecord.getIdElement().toVersionless().toString(), theSourceResource.getIdElement().toVersionless().toString());
    }

    public String getMessageForNoLink(String theGoldenRecord, String theSourceResource) {
        return "No link exists between " + theGoldenRecord + " and " + theSourceResource;
    }

    public String getMessageForAlreadyAcceptedLink(IAnyResource theGoldenRecord, IAnyResource theSourceResource) {
        return this.getMessageForAlreadyAcceptedLink(theGoldenRecord.getIdElement().toVersionless().toString(), theSourceResource.getIdElement().toVersionless().toString());
    }

    public String getMessageForAlreadyAcceptedLink(String theGoldenId, String theSourceId) {
        return "A match with a different golden resource (" + theGoldenId + ") exists for resource " + theSourceId;
    }

    public String getMessageForPresentLink(IAnyResource theGoldenRecord, IAnyResource theSourceResource) {
        return this.getMessageForPresentLink(theGoldenRecord.getIdElement().toVersionless().toString(), theSourceResource.getIdElement().toVersionless().toString());
    }

    public String getMessageForPresentLink(String theGoldenRecord, String theSourceResource) {
        return "Link already exists between " + theGoldenRecord + " and " + theSourceResource + ". Use $mdm-update-link instead.";
    }

    public String getMessageForMultipleGoldenRecords(IAnyResource theSourceResource) {
        return this.getMessageForMultipleGoldenRecords(theSourceResource.getIdElement().toVersionless().toString());
    }

    public String getMessageForMultipleGoldenRecords(String theSourceResource) {
        return theSourceResource + " already has matched golden resource. Use $mdm-query-links to see more details.";
    }

    public String getMessageForFailedGoldenResourceLoad(String theParamName, String theGoldenResourceId) {
        return theGoldenResourceId + " used as parameter [" + theParamName + "] could not be loaded as a golden resource, as it appears to be lacking the golden resource meta tags.";
    }

    public String getMessageForMismatchPartition(IAnyResource theGoldenRecord, IAnyResource theSourceResource) {
        return this.getMessageForMismatchPartition(theGoldenRecord.getIdElement().toVersionless().toString(), theSourceResource.getIdElement().toVersionless().toString());
    }

    public String getMessageForMismatchPartition(String theGoldenRecord, String theSourceResource) {
        return theGoldenRecord + " and " + theSourceResource + " are stored in different partitions. This operation is only available for resources on the same partition.";
    }
}

