/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.util;

import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.mdm.rules.json.MdmRulesJson;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.TokenParam;

public class MdmSearchParamBuildingUtils {
    private static final String IDENTIFIER = "identifier";
    private static final String TAG = "_tag";

    public static SearchParameterMap buildSearchParameterForBlockedResourceCount(String theResourceType) {
        SearchParameterMap map = new SearchParameterMap();
        map.setLoadSynchronous(true);
        TokenAndListParam tagsToSearch = new TokenAndListParam();
        tagsToSearch.addAnd(new TokenParam[]{new TokenParam("http://hapifhir.io/fhir/NamingSystem/mdm-record-status", "GOLDEN_RECORD")});
        tagsToSearch.addAnd(new TokenParam[]{new TokenParam("http://hapifhir.io/fhir/NamingSystem/mdm-record-status", "BLOCKED_RESOURCE")});
        map.add(TAG, (IQueryParameterAnd)tagsToSearch);
        return map;
    }

    public static SearchParameterMap buildEidSearchParameterMap(String theEid, String theResourceType, MdmRulesJson theMdmRules) {
        SearchParameterMap map = MdmSearchParamBuildingUtils.buildBasicGoldenResourceSearchParameterMap(theEid);
        map.add(IDENTIFIER, (IQueryParameterType)new TokenParam(theMdmRules.getEnterpriseEIDSystemForResourceType(theResourceType), theEid));
        return map;
    }

    public static SearchParameterMap buildBasicGoldenResourceSearchParameterMap(String theResourceType) {
        SearchParameterMap map = new SearchParameterMap();
        map.setLoadSynchronous(true);
        map.add(TAG, (IQueryParameterType)new TokenParam("http://hapifhir.io/fhir/NamingSystem/mdm-record-status", "GOLDEN_RECORD"));
        return map;
    }
}

