/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.util;

import jakarta.annotation.Nonnull;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseResource;

public final class MdmResourceUtil {
    private MdmResourceUtil() {
    }

    public static boolean isMdmAllowed(IBaseResource theBaseResource) {
        return theBaseResource.getMeta().getTag("https://hapifhir.org/NamingSystem/managing-mdm-system", "NO-MDM") == null;
    }

    public static boolean isMdmManaged(IBaseResource theBaseResource) {
        return MdmResourceUtil.resourceHasTag(theBaseResource, "https://hapifhir.org/NamingSystem/managing-mdm-system", "HAPI-MDM");
    }

    public static boolean isGoldenRecord(IBaseResource theBaseResource) {
        return MdmResourceUtil.resourceHasTag(theBaseResource, "http://hapifhir.io/fhir/NamingSystem/mdm-record-status", "GOLDEN_RECORD");
    }

    public static boolean hasGoldenRecordSystemTag(IBaseResource theIBaseResource) {
        return MdmResourceUtil.resourceHasTagWithSystem(theIBaseResource, "http://hapifhir.io/fhir/NamingSystem/mdm-record-status");
    }

    public static boolean containsTagWithSystem(IBaseResource theBaseResource) {
        return MdmResourceUtil.resourceHasTagWithSystem(theBaseResource, "http://hapifhir.io/fhir/NamingSystem/mdm-record-status");
    }

    public static boolean isGoldenRecordRedirected(IBaseResource theBaseResource) {
        return MdmResourceUtil.resourceHasTag(theBaseResource, "http://hapifhir.io/fhir/NamingSystem/mdm-record-status", "REDIRECTED");
    }

    private static boolean resourceHasTag(IBaseResource theBaseResource, String theSystem, String theCode) {
        if (theBaseResource == null) {
            return false;
        }
        return theBaseResource.getMeta().getTag(theSystem, theCode) != null;
    }

    private static boolean resourceHasTagWithSystem(IBaseResource theBaseResource, @Nonnull String theSystem) {
        if (theBaseResource == null) {
            return false;
        }
        return theBaseResource.getMeta().getTag().stream().anyMatch(tag -> theSystem.equalsIgnoreCase(tag.getSystem()));
    }

    private static Optional<? extends IBaseCoding> getTagWithSystem(IBaseResource theResource, @Nonnull String theSystem) {
        return theResource.getMeta().getTag().stream().filter(tag -> theSystem.equalsIgnoreCase(tag.getSystem())).findFirst();
    }

    public static void removeTagWithSystem(IBaseResource theResource, @Nonnull String theSystem) {
        theResource.getMeta().getTag().removeIf(tag -> theSystem.equalsIgnoreCase(tag.getSystem()));
    }

    public static IBaseResource setMdmManaged(IBaseResource theBaseResource) {
        return MdmResourceUtil.setTagOnResource(theBaseResource, "https://hapifhir.org/NamingSystem/managing-mdm-system", "HAPI-MDM", "This Golden Resource can only be modified by HAPI MDM system.");
    }

    public static IBaseResource setGoldenResource(IBaseResource theBaseResource) {
        return MdmResourceUtil.setTagOnResource(theBaseResource, "http://hapifhir.io/fhir/NamingSystem/mdm-record-status", "GOLDEN_RECORD", "Golden Record");
    }

    public static IBaseResource setGoldenResourceRedirected(IBaseResource theBaseResource) {
        return MdmResourceUtil.setTagOnResource(theBaseResource, "http://hapifhir.io/fhir/NamingSystem/mdm-record-status", "REDIRECTED", "This resource was found to be a duplicate and has been redirected.");
    }

    public static IBaseResource setGoldenResourceAsBlockedResourceGoldenResource(IBaseResource theBaseResource) {
        IBaseCoding tag = theBaseResource.getMeta().addTag();
        tag.setSystem("http://hapifhir.io/fhir/NamingSystem/mdm-record-status");
        tag.setCode("BLOCKED_RESOURCE");
        tag.setDisplay("Source Resource is omitted from MDM matching.");
        tag.setUserSelected(false);
        tag.setVersion("1");
        return theBaseResource;
    }

    @Nonnull
    private static IBaseResource setTagOnResource(IBaseResource theGoldenResource, String theSystem, String theCode, String theDisplay) {
        Optional<? extends IBaseCoding> tagWithSystem = MdmResourceUtil.getTagWithSystem(theGoldenResource, theSystem);
        if (tagWithSystem.isPresent()) {
            tagWithSystem.get().setCode(theCode);
            tagWithSystem.get().setDisplay(theDisplay);
        } else {
            IBaseCoding tag = theGoldenResource.getMeta().addTag();
            tag.setSystem(theSystem);
            tag.setCode(theCode);
            tag.setDisplay(theDisplay);
            tag.setUserSelected(false);
            tag.setVersion("1");
        }
        return theGoldenResource;
    }
}

