/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.util;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.util.MessageHelper;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.springframework.stereotype.Service;

@Service
public class MdmPartitionHelper {
    private final MessageHelper myMessageHelper;
    private final IMdmSettings myMdmSettings;

    public MdmPartitionHelper(MessageHelper theMessageHelper, IMdmSettings theMdmSettings) {
        this.myMessageHelper = theMessageHelper;
        this.myMdmSettings = theMdmSettings;
    }

    public void validateMdmResourcesPartitionMatches(IAnyResource theFromResource, IAnyResource theToResource) {
        if (!this.myMdmSettings.getSearchAllPartitionForMatch()) {
            RequestPartitionId fromGoldenResourcePartitionId = (RequestPartitionId)theFromResource.getUserData(Constants.RESOURCE_PARTITION_ID);
            RequestPartitionId toGoldenPartitionId = (RequestPartitionId)theToResource.getUserData(Constants.RESOURCE_PARTITION_ID);
            if (fromGoldenResourcePartitionId != null && toGoldenPartitionId != null && fromGoldenResourcePartitionId.hasPartitionIds() && toGoldenPartitionId.hasPartitionIds() && !fromGoldenResourcePartitionId.hasPartitionId(toGoldenPartitionId.getFirstPartitionIdOrNull())) {
                throw new InvalidRequestException(Msg.code((int)2075) + this.myMessageHelper.getMessageForMismatchPartition(theFromResource, theToResource));
            }
        }
    }

    public RequestPartitionId getRequestPartitionIdFromResourceForSearch(IAnyResource theResource) {
        if (this.myMdmSettings.getSearchAllPartitionForMatch()) {
            return RequestPartitionId.allPartitions();
        }
        return (RequestPartitionId)theResource.getUserData(Constants.RESOURCE_PARTITION_ID);
    }

    public RequestPartitionId getRequestPartitionIdForNewGoldenResources(IAnyResource theSourceResource) {
        if (StringUtils.isBlank((CharSequence)this.myMdmSettings.getGoldenResourcePartitionName())) {
            return (RequestPartitionId)theSourceResource.getUserData(Constants.RESOURCE_PARTITION_ID);
        }
        return RequestPartitionId.fromPartitionName((String)this.myMdmSettings.getGoldenResourcePartitionName());
    }
}

