/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.mdm.model.CanonicalEID;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.CanonicalIdentifier;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.instance.model.api.IBase;

public final class IdentifierUtil {
    private IdentifierUtil() {
    }

    public static CanonicalIdentifier identifierDtFromIdentifier(IBase theIdentifier) {
        CanonicalIdentifier retval = new CanonicalIdentifier();
        if (theIdentifier instanceof Identifier) {
            Identifier ident = (Identifier)theIdentifier;
            retval.setSystem(ident.getSystem()).setValue(ident.getValue());
        } else if (theIdentifier instanceof org.hl7.fhir.r4.model.Identifier) {
            org.hl7.fhir.r4.model.Identifier ident = (org.hl7.fhir.r4.model.Identifier)theIdentifier;
            retval.setSystem(ident.getSystem()).setValue(ident.getValue());
        } else if (theIdentifier instanceof org.hl7.fhir.r5.model.Identifier) {
            org.hl7.fhir.r5.model.Identifier ident = (org.hl7.fhir.r5.model.Identifier)theIdentifier;
            retval.setSystem(ident.getSystem()).setValue(ident.getValue());
        } else {
            throw new InternalErrorException(Msg.code((int)1486) + "Expected 'Identifier' type but was '" + theIdentifier.getClass().getName() + "'");
        }
        return retval;
    }

    public static <T extends IBase> T toId(FhirContext theFhirContext, CanonicalEID eid) {
        switch (theFhirContext.getVersion().getVersion()) {
            case R5: {
                return (T)eid.toR5();
            }
            case R4: {
                return (T)eid.toR4();
            }
            case DSTU3: {
                return (T)eid.toDSTU3();
            }
        }
        throw new IllegalStateException(Msg.code((int)1487) + "Unsupported FHIR version " + theFhirContext.getVersion().getVersion());
    }
}

