/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.util;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.api.IMdmSurvivorshipService;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.mdm.model.CanonicalEID;
import ca.uhn.fhir.mdm.model.MdmTransactionContext;
import ca.uhn.fhir.mdm.util.EIDHelper;
import ca.uhn.fhir.mdm.util.IdentifierUtil;
import ca.uhn.fhir.mdm.util.MdmPartitionHelper;
import ca.uhn.fhir.mdm.util.MdmResourceUtil;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.TerserUtil;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GoldenResourceHelper {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    static final String FIELD_NAME_IDENTIFIER = "identifier";
    private final IMdmSettings myMdmSettings;
    private final EIDHelper myEIDHelper;
    private final MdmPartitionHelper myMdmPartitionHelper;
    private final FhirContext myFhirContext;

    @Autowired
    public GoldenResourceHelper(FhirContext theFhirContext, IMdmSettings theMdmSettings, EIDHelper theEIDHelper, MdmPartitionHelper theMdmPartitionHelper) {
        this.myFhirContext = theFhirContext;
        this.myMdmSettings = theMdmSettings;
        this.myEIDHelper = theEIDHelper;
        this.myMdmPartitionHelper = theMdmPartitionHelper;
    }

    @Nonnull
    public <T extends IAnyResource> T createGoldenResourceFromMdmSourceResource(T theIncomingResource, MdmTransactionContext theMdmTransactionContext, IMdmSurvivorshipService theMdmSurvivorshipService) {
        this.validateContextSupported();
        RuntimeResourceDefinition resourceDefinition = this.myFhirContext.getResourceDefinition(theIncomingResource);
        IBaseResource newGoldenResource = (IBaseResource)resourceDefinition.newInstance();
        if (theMdmSurvivorshipService != null) {
            theMdmSurvivorshipService.applySurvivorshipRulesToGoldenResource(theIncomingResource, newGoldenResource, theMdmTransactionContext);
        }
        BaseRuntimeChildDefinition goldenResourceIdentifier = resourceDefinition.getChildByName(FIELD_NAME_IDENTIFIER);
        this.cloneMDMEidsIntoNewGoldenResource(goldenResourceIdentifier, theIncomingResource, newGoldenResource);
        this.addHapiEidIfNoExternalEidIsPresent(newGoldenResource, goldenResourceIdentifier, theIncomingResource);
        MdmResourceUtil.setMdmManaged(newGoldenResource);
        MdmResourceUtil.setGoldenResource(newGoldenResource);
        if (theMdmTransactionContext.getIsBlocked()) {
            MdmResourceUtil.setGoldenResourceAsBlockedResourceGoldenResource(newGoldenResource);
        }
        newGoldenResource.setUserData(Constants.RESOURCE_PARTITION_ID, (Object)this.myMdmPartitionHelper.getRequestPartitionIdForNewGoldenResources(theIncomingResource));
        return (T)((IAnyResource)newGoldenResource);
    }

    private <T extends IAnyResource> void addHapiEidIfNoExternalEidIsPresent(IBaseResource theNewGoldenResource, BaseRuntimeChildDefinition theGoldenResourceIdentifier, IAnyResource theSourceResource) {
        List<CanonicalEID> eidsToApply = this.myEIDHelper.getExternalEid(theNewGoldenResource);
        if (!eidsToApply.isEmpty()) {
            return;
        }
        CanonicalEID hapiEid = this.myEIDHelper.createHapiEid();
        theGoldenResourceIdentifier.getMutator().addValue((IBase)theNewGoldenResource, IdentifierUtil.toId(this.myFhirContext, hapiEid));
        this.cloneEidIntoResource(this.myFhirContext, (IBaseResource)theSourceResource, hapiEid);
    }

    private void cloneMDMEidsIntoNewGoldenResource(BaseRuntimeChildDefinition theGoldenResourceIdentifier, IAnyResource theIncomingResource, IBaseResource theNewGoldenResource) {
        String incomingResourceType = this.myFhirContext.getResourceType((IBaseResource)theIncomingResource);
        String mdmEIDSystem = this.myMdmSettings.getMdmRules().getEnterpriseEIDSystemForResourceType(incomingResourceType);
        if (mdmEIDSystem == null) {
            return;
        }
        IFhirPath fhirPath = this.myFhirContext.newFhirPath();
        List incomingResourceIdentifiers = theGoldenResourceIdentifier.getAccessor().getValues((IBase)theIncomingResource);
        for (IBase incomingResourceIdentifier : incomingResourceIdentifiers) {
            Optional incomingIdentifierSystem = fhirPath.evaluateFirst(incomingResourceIdentifier, "system", IPrimitiveType.class);
            if (incomingIdentifierSystem.isPresent()) {
                String incomingIdentifierSystemString = ((IPrimitiveType)incomingIdentifierSystem.get()).getValueAsString();
                if (Objects.equals(incomingIdentifierSystemString, mdmEIDSystem)) {
                    ourLog.debug("Incoming resource EID System {} matches EID system in the MDM rules.  Copying to Golden Resource.", (Object)incomingIdentifierSystemString);
                    TerserUtil.cloneIdentifierIntoResource((FhirContext)this.myFhirContext, (BaseRuntimeChildDefinition)theGoldenResourceIdentifier, (IBase)incomingResourceIdentifier, (IBaseResource)theNewGoldenResource);
                    continue;
                }
                ourLog.debug("Incoming resource EID System {} differs from EID system in the MDM rules {}.  Not copying to Golden Resource.", (Object)incomingIdentifierSystemString, (Object)mdmEIDSystem);
                continue;
            }
            ourLog.debug("No EID System in incoming resource.");
        }
    }

    private void validateContextSupported() {
        FhirVersionEnum fhirVersion = this.myFhirContext.getVersion().getVersion();
        if (fhirVersion == FhirVersionEnum.R4 || fhirVersion == FhirVersionEnum.DSTU3 || fhirVersion == FhirVersionEnum.R5) {
            return;
        }
        throw new UnsupportedOperationException(Msg.code((int)1489) + "Version not supported: " + this.myFhirContext.getVersion().getVersion());
    }

    public IAnyResource updateGoldenResourceExternalEidFromSourceResource(IAnyResource theGoldenResource, IAnyResource theSourceResource, MdmTransactionContext theMdmTransactionContext) {
        List<CanonicalEID> incomingSourceEid = this.myEIDHelper.getExternalEid((IBaseResource)theSourceResource);
        List<CanonicalEID> goldenResourceOfficialEid = this.myEIDHelper.getExternalEid((IBaseResource)theGoldenResource);
        if (incomingSourceEid.isEmpty()) {
            return theGoldenResource;
        }
        if (goldenResourceOfficialEid.isEmpty() || !this.myMdmSettings.isPreventMultipleEids()) {
            if (this.addCanonicalEidsToGoldenResourceIfAbsent((IBaseResource)theGoldenResource, incomingSourceEid)) {
                this.log(theMdmTransactionContext, "Incoming resource:" + theSourceResource.getIdElement().toUnqualifiedVersionless() + " + with EID " + incomingSourceEid.stream().map(CanonicalEID::toString).collect(Collectors.joining(",")) + " is applying this EID to its related Golden Resource, as this Golden Resource does not yet have an external EID");
            }
        } else if (!goldenResourceOfficialEid.isEmpty() && this.myEIDHelper.eidMatchExists(goldenResourceOfficialEid, incomingSourceEid)) {
            this.log(theMdmTransactionContext, "Incoming resource:" + theSourceResource.getIdElement().toVersionless() + " with EIDs " + incomingSourceEid.stream().map(CanonicalEID::toString).collect(Collectors.joining(",")) + " does not need to overwrite the EID in the Golden Resource, as this EID is already present in the Golden Resource");
        } else {
            throw new IllegalArgumentException(Msg.code((int)1490) + String.format("Incoming resource EID %s would create a duplicate Golden Resource, as Golden Resource EID %s already exists!", incomingSourceEid.toString(), goldenResourceOfficialEid.toString()));
        }
        return theGoldenResource;
    }

    public IBaseResource overwriteExternalEids(IBaseResource theGoldenResource, List<CanonicalEID> theNewEid) {
        this.clearExternalEids(theGoldenResource);
        this.addCanonicalEidsToGoldenResourceIfAbsent(theGoldenResource, theNewEid);
        return theGoldenResource;
    }

    private void clearExternalEidsFromTheGoldenResource(BaseRuntimeChildDefinition theGoldenResourceIdentifier, IBaseResource theGoldenResource) {
        IFhirPath fhirPath = this.myFhirContext.newFhirPath();
        List goldenResourceIdentifiers = theGoldenResourceIdentifier.getAccessor().getValues((IBase)theGoldenResource);
        ArrayList<IBase> clonedIdentifiers = new ArrayList<IBase>();
        FhirTerser terser = this.myFhirContext.newTerser();
        for (IBase base : goldenResourceIdentifiers) {
            Optional system = fhirPath.evaluateFirst(base, "system", IPrimitiveType.class);
            if (system.isPresent()) {
                String resourceType = this.myFhirContext.getResourceType(theGoldenResource);
                String mdmSystem = this.myMdmSettings.getMdmRules().getEnterpriseEIDSystemForResourceType(resourceType);
                String baseSystem = ((IPrimitiveType)system.get()).getValueAsString();
                if (Objects.equals(baseSystem, mdmSystem)) {
                    ourLog.debug("Found EID confirming to MDM rules {}. It does not need to be copied, skipping", (Object)baseSystem);
                    continue;
                }
            }
            BaseRuntimeElementCompositeDefinition childIdentifier = (BaseRuntimeElementCompositeDefinition)theGoldenResourceIdentifier.getChildByName(FIELD_NAME_IDENTIFIER);
            IBase goldenResourceNewIdentifier = childIdentifier.newInstance();
            terser.cloneInto(base, goldenResourceNewIdentifier, true);
            clonedIdentifiers.add(goldenResourceNewIdentifier);
        }
        goldenResourceIdentifiers.clear();
        goldenResourceIdentifiers.addAll(clonedIdentifiers);
    }

    private void clearExternalEids(IBaseResource theGoldenResource) {
        this.validateContextSupported();
        RuntimeResourceDefinition resourceDefinition = this.myFhirContext.getResourceDefinition(theGoldenResource);
        BaseRuntimeChildDefinition goldenResourceIdentifier = resourceDefinition.getChildByName(FIELD_NAME_IDENTIFIER);
        this.clearExternalEidsFromTheGoldenResource(goldenResourceIdentifier, theGoldenResource);
    }

    private boolean addCanonicalEidsToGoldenResourceIfAbsent(IBaseResource theGoldenResource, List<CanonicalEID> theIncomingSourceExternalEids) {
        List<CanonicalEID> goldenResourceExternalEids = this.myEIDHelper.getExternalEid(theGoldenResource);
        boolean addedEid = false;
        for (CanonicalEID incomingExternalEid : theIncomingSourceExternalEids) {
            if (goldenResourceExternalEids.contains(incomingExternalEid)) continue;
            this.cloneEidIntoResource(this.myFhirContext, theGoldenResource, incomingExternalEid);
            addedEid = true;
        }
        return addedEid;
    }

    public boolean hasIdentifier(IBaseResource theResource) {
        return TerserUtil.hasValues((FhirContext)this.myFhirContext, (IBaseResource)theResource, (String)FIELD_NAME_IDENTIFIER);
    }

    public void mergeIndentifierFields(IBaseResource theFromGoldenResource, IBaseResource theToGoldenResource, MdmTransactionContext theMdmTransactionContext) {
        TerserUtil.cloneCompositeField((FhirContext)this.myFhirContext, (IBaseResource)theFromGoldenResource, (IBaseResource)theToGoldenResource, (String)FIELD_NAME_IDENTIFIER);
    }

    public boolean isPotentialDuplicate(IAnyResource theExistingGoldenResource, IAnyResource theComparingGoldenResource) {
        List<CanonicalEID> externalEidsGoldenResource = this.myEIDHelper.getExternalEid((IBaseResource)theExistingGoldenResource);
        List<CanonicalEID> externalEidsResource = this.myEIDHelper.getExternalEid((IBaseResource)theComparingGoldenResource);
        return !externalEidsGoldenResource.isEmpty() && !externalEidsResource.isEmpty() && !this.myEIDHelper.eidMatchExists(externalEidsResource, externalEidsGoldenResource);
    }

    private void log(MdmTransactionContext theMdmTransactionContext, String theMessage) {
        theMdmTransactionContext.addTransactionLogMessage(theMessage);
        ourLog.debug(theMessage);
    }

    public void handleExternalEidAddition(IAnyResource theGoldenResource, IAnyResource theSourceResource, MdmTransactionContext theMdmTransactionContext) {
        List<CanonicalEID> eidFromResource = this.myEIDHelper.getExternalEid((IBaseResource)theSourceResource);
        if (!eidFromResource.isEmpty()) {
            this.updateGoldenResourceExternalEidFromSourceResource(theGoldenResource, theSourceResource, theMdmTransactionContext);
        }
    }

    public void cloneEidIntoResource(FhirContext theFhirContext, IBaseResource theResourceToCloneInto, CanonicalEID theEid) {
        RuntimeResourceDefinition resourceDefinition = theFhirContext.getResourceDefinition(theResourceToCloneInto);
        BaseRuntimeChildDefinition resourceIdentifier = resourceDefinition.getChildByName(FIELD_NAME_IDENTIFIER);
        TerserUtil.cloneIdentifierIntoResource((FhirContext)theFhirContext, (BaseRuntimeChildDefinition)resourceIdentifier, IdentifierUtil.toId(theFhirContext, theEid), (IBaseResource)theResourceToCloneInto);
    }
}

