/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.model.CanonicalEID;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EIDHelper {
    private final FhirContext myFhirContext;
    private final IMdmSettings myMdmSettings;

    @Autowired
    public EIDHelper(FhirContext theFhirContext, IMdmSettings theMdmSettings) {
        this.myFhirContext = theFhirContext;
        this.myMdmSettings = theMdmSettings;
    }

    public CanonicalEID createHapiEid() {
        return new CanonicalEID("http://hapifhir.io/fhir/NamingSystem/mdm-golden-resource-enterprise-id", UUID.randomUUID().toString(), null);
    }

    public List<CanonicalEID> getExternalEid(IBaseResource theResource) {
        String resourceType = this.myFhirContext.getResourceType(theResource);
        return CanonicalEID.extractFromResource(this.myFhirContext, this.myMdmSettings.getMdmRules().getEnterpriseEIDSystemForResourceType(resourceType), theResource);
    }

    public List<CanonicalEID> getHapiEid(IAnyResource theResource) {
        return CanonicalEID.extractFromResource(this.myFhirContext, "http://hapifhir.io/fhir/NamingSystem/mdm-golden-resource-enterprise-id", (IBaseResource)theResource);
    }

    public boolean eidMatchExists(List<CanonicalEID> theFirstResourceEids, List<CanonicalEID> theSecondResourceEids) {
        List collect1;
        List collect = theFirstResourceEids.stream().map(CanonicalEID::getValue).collect(Collectors.toList());
        return !Collections.disjoint(collect, collect1 = theSecondResourceEids.stream().map(CanonicalEID::getValue).collect(Collectors.toList()));
    }

    public boolean hasEidOverlap(IAnyResource theExistingGoldenResource, IAnyResource theComparingGoldenResource) {
        List<CanonicalEID> firstEids = this.getExternalEid((IBaseResource)theExistingGoldenResource);
        List<CanonicalEID> secondEids = this.getExternalEid((IBaseResource)theComparingGoldenResource);
        if (firstEids.isEmpty() || secondEids.isEmpty()) {
            return false;
        }
        return this.eidMatchExists(firstEids, secondEids);
    }
}

