/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.svc;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.mdm.api.IMdmLinkQuerySvc;
import ca.uhn.fhir.mdm.api.IMdmSurvivorshipService;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.api.paging.MdmPageRequest;
import ca.uhn.fhir.mdm.api.params.MdmQuerySearchParameters;
import ca.uhn.fhir.mdm.model.MdmTransactionContext;
import ca.uhn.fhir.mdm.model.mdmevents.MdmLinkJson;
import ca.uhn.fhir.mdm.util.GoldenResourceHelper;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.util.TerserUtil;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.data.domain.Page;

public class MdmSurvivorshipSvcImpl
implements IMdmSurvivorshipService {
    protected final FhirContext myFhirContext;
    private final GoldenResourceHelper myGoldenResourceHelper;
    private final DaoRegistry myDaoRegistry;
    private final IMdmLinkQuerySvc myMdmLinkQuerySvc;
    private final IIdHelperService<?> myIIdHelperService;

    public MdmSurvivorshipSvcImpl(FhirContext theFhirContext, GoldenResourceHelper theResourceHelper, DaoRegistry theDaoRegistry, IMdmLinkQuerySvc theLinkQuerySvc, IIdHelperService<?> theIIdHelperService) {
        this.myFhirContext = theFhirContext;
        this.myGoldenResourceHelper = theResourceHelper;
        this.myDaoRegistry = theDaoRegistry;
        this.myMdmLinkQuerySvc = theLinkQuerySvc;
        this.myIIdHelperService = theIIdHelperService;
    }

    @Override
    public <T extends IBase> void applySurvivorshipRulesToGoldenResource(T theTargetResource, T theGoldenResource, MdmTransactionContext theMdmTransactionContext) {
        switch (theMdmTransactionContext.getRestOperation()) {
            case MERGE_GOLDEN_RESOURCES: {
                TerserUtil.mergeFields((FhirContext)this.myFhirContext, (IBaseResource)((IBaseResource)theTargetResource), (IBaseResource)((IBaseResource)theGoldenResource), (Predicate)TerserUtil.EXCLUDE_IDS_AND_META);
                break;
            }
            default: {
                TerserUtil.replaceFields((FhirContext)this.myFhirContext, (IBaseResource)((IBaseResource)theTargetResource), (IBaseResource)((IBaseResource)theGoldenResource), (Predicate)TerserUtil.EXCLUDE_IDS_AND_META);
            }
        }
    }

    @Override
    public <T extends IBase> T rebuildGoldenResourceWithSurvivorshipRules(T theGoldenResourceBase, MdmTransactionContext theMdmTransactionContext) {
        IBaseResource goldenResource = (IBaseResource)theGoldenResourceBase;
        Stream<IBaseResource> sourceResources = this.getMatchedSourceIdsByLinkUpdateDate(goldenResource, theMdmTransactionContext);
        IAnyResource toSave = this.myGoldenResourceHelper.createGoldenResourceFromMdmSourceResource((IAnyResource)goldenResource, theMdmTransactionContext, null);
        toSave.setId(goldenResource.getIdElement().toUnqualifiedVersionless());
        sourceResources.forEach(arg_0 -> this.lambda$rebuildGoldenResourceWithSurvivorshipRules$0((IBaseResource)toSave, theMdmTransactionContext, arg_0));
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(goldenResource.fhirType());
        dao.update((IBaseResource)toSave, (RequestDetails)new SystemRequestDetails());
        return (T)toSave;
    }

    private Stream<IBaseResource> getMatchedSourceIdsByLinkUpdateDate(IBaseResource theGoldenResource, MdmTransactionContext theMdmTransactionContext) {
        String resourceType = theGoldenResource.fhirType();
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(resourceType);
        MdmQuerySearchParameters searchParameters = new MdmQuerySearchParameters(new MdmPageRequest(0, 50, 50, 50));
        searchParameters.setGoldenResourceId(theGoldenResource.getIdElement());
        searchParameters.setSort("myUpdated");
        searchParameters.setMatchResult(MdmMatchResultEnum.MATCH);
        Page<MdmLinkJson> linksQuery = this.myMdmLinkQuerySvc.queryLinks(searchParameters, theMdmTransactionContext);
        return linksQuery.get().map(link -> {
            String sourceId = link.getSourceId();
            IResourcePersistentId<?> pid = this.getResourcePID(sourceId.substring(resourceType.length() + 1), resourceType);
            return dao.readByPid(pid);
        });
    }

    private IResourcePersistentId<?> getResourcePID(String theId, String theResourceType) {
        return this.myIIdHelperService.newPidFromStringIdAndResourceName(theId, theResourceType);
    }

    private /* synthetic */ void lambda$rebuildGoldenResourceWithSurvivorshipRules$0(IBaseResource toSave, MdmTransactionContext theMdmTransactionContext, IBaseResource source) {
        this.applySurvivorshipRulesToGoldenResource(source, toSave, theMdmTransactionContext);
    }
}

