/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.svc;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IDao;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.dao.ISearchBuilder;
import ca.uhn.fhir.jpa.dao.SearchBuilderFactory;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.extractor.SearchParamExtractorService;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.util.SearchParameterUtil;
import jakarta.annotation.Nullable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MdmSearchParamSvc {
    @Autowired
    FhirContext myFhirContext;
    @Autowired
    private MatchUrlService myMatchUrlService;
    @Autowired
    private ISearchParamRegistry mySearchParamRegistry;
    @Autowired
    private SearchParamExtractorService mySearchParamExtractorService;
    @Autowired
    private SearchBuilderFactory mySearchBuilderFactory;
    @Autowired
    private DaoRegistry myDaoRegistry;

    public SearchParameterMap mapFromCriteria(String theResourceType, String theResourceCriteria) {
        RuntimeResourceDefinition resourceDef = this.myFhirContext.getResourceDefinition(theResourceType);
        return this.myMatchUrlService.translateMatchUrl(theResourceCriteria, resourceDef, new MatchUrlService.Flag[0]);
    }

    public List<String> getValueFromResourceForSearchParam(IBaseResource theResource, String theSearchParam) {
        String resourceType = this.myFhirContext.getResourceType(theResource);
        String searchParam = SearchParameterUtil.stripModifier((String)theSearchParam);
        RuntimeSearchParam activeSearchParam = this.mySearchParamRegistry.getActiveSearchParam(resourceType, searchParam);
        return this.mySearchParamExtractorService.extractParamValuesAsStrings(activeSearchParam, theResource);
    }

    public SearchParameterMap getSearchParameterMapFromCriteria(String theSourceType, @Nullable String theCriteria) {
        SearchParameterMap spMap = StringUtils.isBlank((CharSequence)theCriteria) ? new SearchParameterMap() : this.mapFromCriteria(theSourceType, theCriteria);
        return spMap;
    }

    public ISearchBuilder generateSearchBuilderForType(String theSourceType) {
        IFhirResourceDao resourceDao = this.myDaoRegistry.getResourceDao(theSourceType);
        return this.mySearchBuilderFactory.newSearchBuilder((IDao)resourceDao, theSourceType, resourceDao.getResourceType());
    }

    public boolean searchParamTypeIsValidForResourceType(String theSearchParamType, String theResourceType) {
        return theSearchParamType.equalsIgnoreCase(theResourceType) || theSearchParamType.equalsIgnoreCase("*");
    }
}

