/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.svc;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.mdm.api.IMdmLinkExpandSvc;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.dao.IMdmLinkDao;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.mdm.model.MdmPidTuple;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MdmLinkExpandSvc
implements IMdmLinkExpandSvc {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    IMdmLinkDao myMdmLinkDao;
    @Autowired
    IIdHelperService myIdHelperService;

    @Override
    public Set<String> expandMdmBySourceResource(RequestPartitionId theRequestPartitionId, IBaseResource theResource) {
        ourLog.debug("About to MDM-expand source resource {}", (Object)theResource);
        return this.expandMdmBySourceResourceId(theRequestPartitionId, theResource.getIdElement());
    }

    @Override
    public Set<String> expandMdmBySourceResourceId(RequestPartitionId theRequestPartitionId, IIdType theId) {
        ourLog.debug("About to expand source resource with resource id {}", (Object)theId);
        return this.expandMdmBySourceResourcePid(theRequestPartitionId, this.myIdHelperService.getPidOrThrowException(RequestPartitionId.allPartitions(), theId));
    }

    @Override
    public Set<String> expandMdmBySourceResourcePid(RequestPartitionId theRequestPartitionId, IResourcePersistentId<?> theSourceResourcePid) {
        ourLog.debug("About to expand source resource with PID {}", theSourceResourcePid);
        List<MdmPidTuple<?>> goldenPidSourcePidTuples = this.myMdmLinkDao.expandPidsBySourcePidAndMatchResult(theSourceResourcePid, MdmMatchResultEnum.MATCH);
        return this.flattenPidTuplesToSet(theRequestPartitionId, theSourceResourcePid, goldenPidSourcePidTuples);
    }

    @Override
    public Set<String> expandMdmByGoldenResourceId(RequestPartitionId theRequestPartitionId, IResourcePersistentId<?> theGoldenResourcePid) {
        ourLog.debug("About to expand golden resource with PID {}", theGoldenResourcePid);
        List<MdmPidTuple<?>> goldenPidSourcePidTuples = this.myMdmLinkDao.expandPidsByGoldenResourcePidAndMatchResult(theGoldenResourcePid, MdmMatchResultEnum.MATCH);
        return this.flattenPidTuplesToSet(theRequestPartitionId, theGoldenResourcePid, goldenPidSourcePidTuples);
    }

    @Override
    public Set<String> expandMdmByGoldenResourcePid(RequestPartitionId theRequestPartitionId, IResourcePersistentId<?> theGoldenResourcePid) {
        ourLog.debug("About to expand golden resource with PID {}", theGoldenResourcePid);
        List<MdmPidTuple<?>> goldenPidSourcePidTuples = this.myMdmLinkDao.expandPidsByGoldenResourcePidAndMatchResult(theGoldenResourcePid, MdmMatchResultEnum.MATCH);
        return this.flattenPidTuplesToSet(theRequestPartitionId, theGoldenResourcePid, goldenPidSourcePidTuples);
    }

    @Override
    public Set<String> expandMdmByGoldenResourceId(RequestPartitionId theRequestPartitionId, IdDt theId) {
        ourLog.debug("About to expand golden resource with golden resource id {}", (Object)theId);
        IResourcePersistentId pidOrThrowException = this.myIdHelperService.getPidOrThrowException(RequestPartitionId.allPartitions(), (IIdType)theId);
        return this.expandMdmByGoldenResourcePid(theRequestPartitionId, pidOrThrowException);
    }

    @Nonnull
    public Set<String> flattenPidTuplesToSet(RequestPartitionId theRequestPartitionId, IResourcePersistentId<?> theInitialPid, List<MdmPidTuple<?>> theGoldenPidSourcePidTuples) {
        Set flattenedPids = theGoldenPidSourcePidTuples.stream().map(tuple -> MdmLinkExpandSvc.flattenTuple(theRequestPartitionId, tuple)).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
        Set resourceIds = this.myIdHelperService.translatePidsToFhirResourceIds(flattenedPids);
        ourLog.debug("Pid {} has been expanded to [{}]", theInitialPid, (Object)String.join((CharSequence)",", resourceIds));
        return resourceIds;
    }

    @Nonnull
    static Set<IResourcePersistentId> flattenTuple(RequestPartitionId theRequestPartitionId, MdmPidTuple<?> theTuple) {
        if (theRequestPartitionId.isPartitionCovered(theTuple.getGoldenPartitionId())) {
            if (theRequestPartitionId.isPartitionCovered(theTuple.getSourcePartitionId())) {
                return Set.of(theTuple.getSourcePid(), theTuple.getGoldenPid());
            }
            return Set.of(theTuple.getGoldenPid());
        }
        if (theRequestPartitionId.isPartitionCovered(theTuple.getSourcePartitionId())) {
            return Set.of(theTuple.getSourcePid());
        }
        return Collections.emptySet();
    }
}

