/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.svc;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.dao.IMdmLinkDao;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MdmLinkDeleteSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(MdmLinkDeleteSvc.class);
    @Autowired
    private IMdmLinkDao myMdmLinkDao;
    @Autowired
    private IIdHelperService myIdHelperService;

    public int deleteWithAnyReferenceTo(IBaseResource theResource) {
        IResourcePersistentId pid = this.myIdHelperService.getPidOrThrowException(RequestPartitionId.allPartitions(), theResource.getIdElement());
        int removed = this.myMdmLinkDao.deleteWithAnyReferenceToPid(pid);
        if (removed > 0) {
            ourLog.info("Removed {} MDM links with references to {}", (Object)removed, (Object)theResource.getIdElement().toVersionless());
        }
        return removed;
    }

    public int deleteNonRedirectWithAnyReferenceTo(IBaseResource theResource) {
        IResourcePersistentId pid = this.myIdHelperService.getPidOrThrowException(RequestPartitionId.allPartitions(), theResource.getIdElement());
        int removed = this.myMdmLinkDao.deleteWithAnyReferenceToPidAndMatchResultNot(pid, MdmMatchResultEnum.REDIRECT);
        if (removed > 0) {
            ourLog.info("Removed {} non-redirect MDM links with references to {}", (Object)removed, (Object)theResource.getIdElement().toVersionless());
        }
        return removed;
    }
}

