/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.svc;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.subscription.channel.api.ChannelProducerSettings;
import ca.uhn.fhir.jpa.subscription.channel.api.IChannelFactory;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedJsonMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.mdm.api.IMdmChannelSubmitterSvc;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.server.messaging.BaseResourceMessage;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;

public class MdmChannelSubmitterSvcImpl
implements IMdmChannelSubmitterSvc {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    private MessageChannel myMdmChannelProducer;
    private FhirContext myFhirContext;
    private IChannelFactory myChannelFactory;

    @Override
    public void submitResourceToMdmChannel(IBaseResource theResource) {
        ResourceModifiedJsonMessage resourceModifiedJsonMessage = new ResourceModifiedJsonMessage();
        ResourceModifiedMessage resourceModifiedMessage = new ResourceModifiedMessage(this.myFhirContext, theResource, BaseResourceMessage.OperationTypeEnum.MANUALLY_TRIGGERED, null, (RequestPartitionId)theResource.getUserData(Constants.RESOURCE_PARTITION_ID));
        resourceModifiedMessage.setOperationType(BaseResourceMessage.OperationTypeEnum.MANUALLY_TRIGGERED);
        resourceModifiedJsonMessage.setPayload(resourceModifiedMessage);
        boolean success = this.getMdmChannelProducer().send((Message)resourceModifiedJsonMessage);
        if (!success) {
            ourLog.error("Failed to submit {} to MDM Channel.", (Object)resourceModifiedMessage.getPayloadId());
        }
    }

    @Autowired
    public MdmChannelSubmitterSvcImpl(FhirContext theFhirContext, IChannelFactory theIChannelFactory) {
        this.myFhirContext = theFhirContext;
        this.myChannelFactory = theIChannelFactory;
    }

    private void init() {
        ChannelProducerSettings channelSettings = new ChannelProducerSettings();
        this.myMdmChannelProducer = this.myChannelFactory.getOrCreateProducer("empi", ResourceModifiedJsonMessage.class, channelSettings);
    }

    private MessageChannel getMdmChannelProducer() {
        if (this.myMdmChannelProducer == null) {
            this.init();
        }
        return this.myMdmChannelProducer;
    }
}

