/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.rules.svc;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.api.MdmMatchEvaluation;
import ca.uhn.fhir.mdm.api.MdmMatchOutcome;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.mdm.rules.json.MdmFieldMatchJson;
import ca.uhn.fhir.mdm.rules.json.MdmRulesJson;
import ca.uhn.fhir.mdm.rules.matcher.IMatcherFactory;
import ca.uhn.fhir.mdm.rules.svc.MdmResourceFieldMatcher;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class MdmResourceMatcherSvc {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    private final FhirContext myFhirContext;
    private final IMatcherFactory myMatcherFactory;
    private final List<MdmResourceFieldMatcher> myFieldMatchers = new ArrayList<MdmResourceFieldMatcher>();
    private MdmRulesJson myMdmRulesJson;

    public MdmResourceMatcherSvc(FhirContext theFhirContext, IMatcherFactory theIMatcherFactory, IMdmSettings theMdmSettings) {
        this.myFhirContext = theFhirContext;
        this.myMatcherFactory = theIMatcherFactory;
        this.myMdmRulesJson = theMdmSettings.getMdmRules();
        this.addFieldMatchers();
    }

    private void addFieldMatchers() {
        if (this.myMdmRulesJson == null) {
            throw new ConfigurationException(Msg.code((int)1521) + "Failed to load MDM Rules.  If MDM is enabled, then MDM rules must be available in context.");
        }
        this.myFieldMatchers.clear();
        for (MdmFieldMatchJson matchFieldJson : this.myMdmRulesJson.getMatchFields()) {
            this.myFieldMatchers.add(new MdmResourceFieldMatcher(this.myFhirContext, this.myMatcherFactory, matchFieldJson, this.myMdmRulesJson));
        }
    }

    public MdmMatchOutcome getMatchResult(IBaseResource theLeftResource, IBaseResource theRightResource) {
        return this.match(theLeftResource, theRightResource);
    }

    MdmMatchOutcome match(IBaseResource theLeftResource, IBaseResource theRightResource) {
        MdmMatchOutcome matchResult = this.getMatchOutcome(theLeftResource, theRightResource);
        MdmMatchResultEnum matchResultEnum = this.myMdmRulesJson.getMatchResult(matchResult.getVector());
        matchResult.setMatchResultEnum(matchResultEnum);
        if (ourLog.isDebugEnabled()) {
            ourLog.debug("{} {}: {}", new Object[]{matchResult.getMatchResultEnum(), theRightResource.getIdElement().toUnqualifiedVersionless(), matchResult});
            if (ourLog.isTraceEnabled()) {
                ourLog.trace("Field matcher results:\n{}", (Object)this.myMdmRulesJson.getDetailedFieldMatchResultWithSuccessInformation(matchResult.getVector()));
            }
        }
        return matchResult;
    }

    private MdmMatchOutcome getMatchOutcome(IBaseResource theLeftResource, IBaseResource theRightResource) {
        long vector = 0L;
        double score = 0.0;
        int appliedRuleCount = 0;
        String resourceType = this.myFhirContext.getResourceType(theLeftResource);
        for (int i = 0; i < this.myFieldMatchers.size(); ++i) {
            MdmResourceFieldMatcher fieldComparator = this.myFieldMatchers.get(i);
            if (!this.isValidResourceType(resourceType, fieldComparator.getResourceType())) {
                ourLog.debug("Matcher {} is not valid for resource type: {}. Skipping it.", (Object)fieldComparator.getName(), (Object)resourceType);
                continue;
            }
            ourLog.trace("Matcher {} is valid for resource type: {}. Evaluating match.", (Object)fieldComparator.getName(), (Object)resourceType);
            MdmMatchEvaluation matchEvaluation = fieldComparator.match(theLeftResource, theRightResource);
            if (matchEvaluation.match) {
                ourLog.trace("Match: Successfully matched matcher {} with score {}. New vector: {}", new Object[]{fieldComparator.getName(), matchEvaluation.score, vector |= 1L << i});
                score += matchEvaluation.score;
            } else {
                ourLog.trace("No match: Matcher {} did not match (score: {}).", (Object)fieldComparator.getName(), (Object)matchEvaluation.score);
            }
            ++appliedRuleCount;
        }
        MdmMatchOutcome retVal = new MdmMatchOutcome(vector, score);
        retVal.setMdmRuleCount(appliedRuleCount);
        return retVal;
    }

    private boolean isValidResourceType(String theResourceType, String theFieldComparatorType) {
        return theFieldComparatorType.equalsIgnoreCase("*") || theFieldComparatorType.equalsIgnoreCase(theResourceType);
    }

    @VisibleForTesting
    public void setMdmRulesJson(MdmRulesJson theMdmRulesJson) {
        this.myMdmRulesJson = theMdmRulesJson;
        this.addFieldMatchers();
    }
}

