/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.rules.svc;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.mdm.api.MdmMatchEvaluation;
import ca.uhn.fhir.mdm.rules.json.MdmFieldMatchJson;
import ca.uhn.fhir.mdm.rules.json.MdmMatcherJson;
import ca.uhn.fhir.mdm.rules.json.MdmRulesJson;
import ca.uhn.fhir.mdm.rules.json.MdmSimilarityJson;
import ca.uhn.fhir.mdm.rules.matcher.IMatcherFactory;
import ca.uhn.fhir.mdm.rules.matcher.models.IMdmFieldMatcher;
import ca.uhn.fhir.mdm.rules.matcher.models.MatchTypeEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.FhirTerser;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class MdmResourceFieldMatcher {
    private final FhirContext myFhirContext;
    private final MdmFieldMatchJson myMdmFieldMatchJson;
    private final String myResourceType;
    private final String myResourcePath;
    private final String myFhirPath;
    private final MdmRulesJson myMdmRulesJson;
    private final String myName;
    private final boolean myIsFhirPathExpression;
    private final IMatcherFactory myIMatcherFactory;

    public MdmResourceFieldMatcher(FhirContext theFhirContext, IMatcherFactory theIMatcherFactory, MdmFieldMatchJson theMdmFieldMatchJson, MdmRulesJson theMdmRulesJson) {
        this.myIMatcherFactory = theIMatcherFactory;
        this.myFhirContext = theFhirContext;
        this.myMdmFieldMatchJson = theMdmFieldMatchJson;
        this.myResourceType = theMdmFieldMatchJson.getResourceType();
        this.myResourcePath = theMdmFieldMatchJson.getResourcePath();
        this.myFhirPath = theMdmFieldMatchJson.getFhirPath();
        this.myName = theMdmFieldMatchJson.getName();
        this.myMdmRulesJson = theMdmRulesJson;
        this.myIsFhirPathExpression = this.myFhirPath != null;
    }

    public MdmMatchEvaluation match(IBaseResource theLeftResource, IBaseResource theRightResource) {
        List rightValues;
        List leftValues;
        this.validate(theLeftResource);
        this.validate(theRightResource);
        if (this.myIsFhirPathExpression) {
            IFhirPath fhirPath = this.myFhirContext.newFhirPath();
            leftValues = fhirPath.evaluate((IBase)theLeftResource, this.myFhirPath, IBase.class);
            rightValues = fhirPath.evaluate((IBase)theRightResource, this.myFhirPath, IBase.class);
        } else {
            FhirTerser fhirTerser = this.myFhirContext.newTerser();
            leftValues = fhirTerser.getValues((IBase)theLeftResource, this.myResourcePath, IBase.class);
            rightValues = fhirTerser.getValues((IBase)theRightResource, this.myResourcePath, IBase.class);
        }
        return this.match(leftValues, rightValues);
    }

    private MdmMatchEvaluation match(List<IBase> theLeftValues, List<IBase> theRightValues) {
        MdmMatchEvaluation retval = new MdmMatchEvaluation(false, 0.0);
        boolean isMatchingEmptyFieldValues = theLeftValues.isEmpty() && theRightValues.isEmpty();
        IMdmFieldMatcher matcher = this.getFieldMatcher();
        if (isMatchingEmptyFieldValues && matcher != null && matcher.isMatchingEmptyFields()) {
            return this.match((IBase)null, (IBase)null);
        }
        for (IBase leftValue : theLeftValues) {
            for (IBase rightValue : theRightValues) {
                MdmMatchEvaluation nextMatch = this.match(leftValue, rightValue);
                retval = MdmMatchEvaluation.max(retval, nextMatch);
            }
        }
        return retval;
    }

    private MdmMatchEvaluation match(IBase theLeftValue, IBase theRightValue) {
        IMdmFieldMatcher matcher = this.getFieldMatcher();
        if (matcher != null) {
            boolean isMatches;
            return new MdmMatchEvaluation(isMatches, (isMatches = matcher.matches(theLeftValue, theRightValue, this.myMdmFieldMatchJson.getMatcher())) ? 1.0 : 0.0);
        }
        MdmSimilarityJson similarity = this.myMdmFieldMatchJson.getSimilarity();
        if (similarity != null) {
            return similarity.match(this.myFhirContext, theLeftValue, theRightValue);
        }
        throw new InternalErrorException(Msg.code((int)1522) + "Field Match " + this.myName + " has neither a matcher nor a similarity.");
    }

    private void validate(IBaseResource theResource) {
        String resourceType = this.myFhirContext.getResourceType(theResource);
        Validate.notNull((Object)resourceType, (String)"Resource type may not be null", (Object[])new Object[0]);
        if ("*".equals(this.myResourceType)) {
            boolean isMdmType = this.myMdmRulesJson.getMdmTypes().stream().anyMatch(mdmType -> mdmType.equalsIgnoreCase(resourceType));
            Validate.isTrue((boolean)isMdmType, (String)"Expecting resource type %s, got resource type %s", (Object[])new Object[]{this.myMdmRulesJson.getMdmTypes().stream().collect(Collectors.joining(",")), resourceType});
        } else {
            Validate.isTrue((boolean)this.myResourceType.equals(resourceType), (String)"Expecting resource type %s got resource type %s", (Object[])new Object[]{this.myResourceType, resourceType});
        }
    }

    public String getResourceType() {
        return this.myResourceType;
    }

    public String getResourcePath() {
        return this.myResourcePath;
    }

    public String getName() {
        return this.myName;
    }

    private IMdmFieldMatcher getFieldMatcher() {
        MdmMatcherJson matcherJson = this.myMdmFieldMatchJson.getMatcher();
        MatchTypeEnum matchTypeEnum = null;
        if (matcherJson != null) {
            matchTypeEnum = matcherJson.getAlgorithm();
        }
        if (matchTypeEnum == null) {
            return null;
        }
        return this.myIMatcherFactory.getFieldMatcherForMatchType(matchTypeEnum);
    }
}

