/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.rules.similarity;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.mdm.api.MdmMatchEvaluation;
import ca.uhn.fhir.mdm.rules.similarity.HapiNumericSimilarity;
import ca.uhn.fhir.mdm.rules.similarity.HapiStringSimilarity;
import ca.uhn.fhir.mdm.rules.similarity.IMdmFieldSimilarity;
import info.debatty.java.stringsimilarity.Cosine;
import info.debatty.java.stringsimilarity.Jaccard;
import info.debatty.java.stringsimilarity.JaroWinkler;
import info.debatty.java.stringsimilarity.NormalizedLevenshtein;
import info.debatty.java.stringsimilarity.SorensenDice;
import info.debatty.java.stringsimilarity.interfaces.NormalizedStringSimilarity;
import jakarta.annotation.Nullable;
import org.hl7.fhir.instance.model.api.IBase;

public enum MdmSimilarityEnum {
    JARO_WINKLER(new HapiStringSimilarity((NormalizedStringSimilarity)new JaroWinkler())),
    COSINE(new HapiStringSimilarity((NormalizedStringSimilarity)new Cosine())),
    JACCARD(new HapiStringSimilarity((NormalizedStringSimilarity)new Jaccard())),
    LEVENSCHTEIN(new HapiStringSimilarity((NormalizedStringSimilarity)new NormalizedLevenshtein())),
    SORENSEN_DICE(new HapiStringSimilarity((NormalizedStringSimilarity)new SorensenDice())),
    NUMERIC_JARO_WINKLER(new HapiNumericSimilarity((NormalizedStringSimilarity)new JaroWinkler())),
    NUMERIC_COSINE(new HapiNumericSimilarity((NormalizedStringSimilarity)new Cosine())),
    NUMERIC_JACCARD(new HapiNumericSimilarity((NormalizedStringSimilarity)new Jaccard())),
    NUMERIC_LEVENSCHTEIN(new HapiNumericSimilarity((NormalizedStringSimilarity)new NormalizedLevenshtein())),
    NUMERIC_SORENSEN_DICE(new HapiNumericSimilarity((NormalizedStringSimilarity)new SorensenDice()));

    private final IMdmFieldSimilarity myMdmFieldSimilarity;

    private MdmSimilarityEnum(IMdmFieldSimilarity theMdmFieldSimilarity) {
        this.myMdmFieldSimilarity = theMdmFieldSimilarity;
    }

    public MdmMatchEvaluation match(FhirContext theFhirContext, IBase theLeftBase, IBase theRightBase, boolean theExact, @Nullable Double theThreshold) {
        return this.matchBySimilarity(this.myMdmFieldSimilarity, theFhirContext, theLeftBase, theRightBase, theExact, theThreshold);
    }

    private MdmMatchEvaluation matchBySimilarity(IMdmFieldSimilarity theSimilarity, FhirContext theFhirContext, IBase theLeftBase, IBase theRightBase, boolean theExact, Double theThreshold) {
        double similarityResult = theSimilarity.similarity(theFhirContext, theLeftBase, theRightBase, theExact);
        return new MdmMatchEvaluation(similarityResult >= theThreshold, similarityResult);
    }
}

