/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.rules.similarity;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.mdm.rules.matcher.util.StringMatcherUtils;
import ca.uhn.fhir.mdm.rules.similarity.IMdmFieldSimilarity;
import info.debatty.java.stringsimilarity.interfaces.NormalizedStringSimilarity;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class HapiStringSimilarity
implements IMdmFieldSimilarity {
    protected final NormalizedStringSimilarity myStringSimilarity;

    public HapiStringSimilarity(NormalizedStringSimilarity theStringSimilarity) {
        this.myStringSimilarity = theStringSimilarity;
    }

    @Override
    public double similarity(FhirContext theFhirContext, IBase theLeftBase, IBase theRightBase, boolean theExact) {
        if (theLeftBase instanceof IPrimitiveType && theRightBase instanceof IPrimitiveType) {
            String leftString = StringMatcherUtils.extractString((IPrimitiveType)theLeftBase, theExact);
            String rightString = StringMatcherUtils.extractString((IPrimitiveType)theRightBase, theExact);
            return this.myStringSimilarity.similarity(leftString, rightString);
        }
        return 0.0;
    }
}

