/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.rules.matcher.fieldmatchers;

import ca.uhn.fhir.context.phonetic.IPhoneticEncoder;
import ca.uhn.fhir.context.phonetic.PhoneticEncoderEnum;
import ca.uhn.fhir.mdm.rules.json.MdmMatcherJson;
import ca.uhn.fhir.mdm.rules.matcher.models.IMdmFieldMatcher;
import ca.uhn.fhir.mdm.rules.matcher.util.StringMatcherUtils;
import ca.uhn.fhir.util.PhoneticEncoderUtil;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoneticEncoderMatcher
implements IMdmFieldMatcher {
    private static final Logger ourLog = LoggerFactory.getLogger(PhoneticEncoderMatcher.class);
    private final IPhoneticEncoder myStringEncoder;

    public PhoneticEncoderMatcher(PhoneticEncoderEnum thePhoneticEnum) {
        this.myStringEncoder = PhoneticEncoderUtil.getEncoder((String)thePhoneticEnum.name());
    }

    public boolean matches(String theLeftString, String theRightString) {
        return this.myStringEncoder.encode(theLeftString).equals(this.myStringEncoder.encode(theRightString));
    }

    @Override
    public boolean matches(IBase theLeftBase, IBase theRightBase, MdmMatcherJson theParams) {
        String leftString = StringMatcherUtils.extractString((IPrimitiveType)theLeftBase, theParams.getExact());
        String rightString = StringMatcherUtils.extractString((IPrimitiveType)theRightBase, theParams.getExact());
        return this.matches(leftString, rightString);
    }
}

