/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.rules.matcher.fieldmatchers;

import ca.uhn.fhir.jpa.nickname.INicknameSvc;
import ca.uhn.fhir.mdm.rules.json.MdmMatcherJson;
import ca.uhn.fhir.mdm.rules.matcher.models.IMdmFieldMatcher;
import ca.uhn.fhir.mdm.rules.matcher.util.StringMatcherUtils;
import java.util.Collection;
import java.util.Locale;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class NicknameMatcher
implements IMdmFieldMatcher {
    private final INicknameSvc myNicknameSvc;

    public NicknameMatcher(INicknameSvc theNicknameSvc) {
        this.myNicknameSvc = theNicknameSvc;
    }

    public boolean matches(String theLeftString, String theRightString) {
        String leftString = theLeftString.toLowerCase(Locale.ROOT);
        String rightString = theRightString.toLowerCase(Locale.ROOT);
        Collection leftNames = this.myNicknameSvc.getEquivalentNames(leftString);
        if (leftNames.contains(rightString)) {
            return true;
        }
        Collection rightNames = this.myNicknameSvc.getEquivalentNames(rightString);
        return rightNames.contains(leftString);
    }

    @Override
    public boolean matches(IBase theLeftBase, IBase theRightBase, MdmMatcherJson theParams) {
        if (theLeftBase instanceof IPrimitiveType && theRightBase instanceof IPrimitiveType) {
            String leftString = StringMatcherUtils.extractString((IPrimitiveType)theLeftBase, theParams.getExact());
            String rightString = StringMatcherUtils.extractString((IPrimitiveType)theRightBase, theParams.getExact());
            return this.matches(leftString, rightString);
        }
        return false;
    }
}

