/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.rules.matcher.fieldmatchers;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.mdm.rules.json.MdmMatcherJson;
import ca.uhn.fhir.mdm.rules.matcher.fieldmatchers.MdmNameMatchModeEnum;
import ca.uhn.fhir.mdm.rules.matcher.models.IMdmFieldMatcher;
import ca.uhn.fhir.mdm.util.NameUtil;
import ca.uhn.fhir.util.StringUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;

public class NameMatcher
implements IMdmFieldMatcher {
    private final MdmNameMatchModeEnum myMatchMode;
    private final FhirContext myFhirContext;

    public NameMatcher(FhirContext theFhirContext, MdmNameMatchModeEnum theMatchMode) {
        this.myMatchMode = theMatchMode;
        this.myFhirContext = theFhirContext;
    }

    @Override
    public boolean matches(IBase theLeftBase, IBase theRightBase, MdmMatcherJson theParams) {
        String leftFamilyName = NameUtil.extractFamilyName(this.myFhirContext, theLeftBase);
        String rightFamilyName = NameUtil.extractFamilyName(this.myFhirContext, theRightBase);
        if (StringUtils.isEmpty((CharSequence)leftFamilyName) || StringUtils.isEmpty((CharSequence)rightFamilyName)) {
            return false;
        }
        boolean match = false;
        List<String> leftGivenNames = NameUtil.extractGivenNames(this.myFhirContext, theLeftBase);
        List<String> rightGivenNames = NameUtil.extractGivenNames(this.myFhirContext, theRightBase);
        if (!theParams.getExact()) {
            leftFamilyName = StringUtil.normalizeStringForSearchIndexing((String)leftFamilyName);
            rightFamilyName = StringUtil.normalizeStringForSearchIndexing((String)rightFamilyName);
            leftGivenNames = leftGivenNames.stream().map(StringUtil::normalizeStringForSearchIndexing).collect(Collectors.toList());
            rightGivenNames = rightGivenNames.stream().map(StringUtil::normalizeStringForSearchIndexing).collect(Collectors.toList());
        }
        for (String leftGivenName : leftGivenNames) {
            for (String rightGivenName : rightGivenNames) {
                match |= leftGivenName.equals(rightGivenName) && leftFamilyName.equals(rightFamilyName);
                if (this.myMatchMode != MdmNameMatchModeEnum.ANY_ORDER) continue;
                match |= leftGivenName.equals(rightFamilyName) && leftFamilyName.equals(rightGivenName);
            }
        }
        return match;
    }
}

