/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.rules.matcher.fieldmatchers;

import ca.uhn.fhir.mdm.rules.json.MdmMatcherJson;
import ca.uhn.fhir.mdm.rules.matcher.models.IMdmFieldMatcher;
import ca.uhn.fhir.mdm.util.IdentifierUtil;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.util.CanonicalIdentifier;
import org.hl7.fhir.instance.model.api.IBase;

public class IdentifierMatcher
implements IMdmFieldMatcher {
    private boolean isEmpty(StringDt theValue) {
        if (theValue == null) {
            return true;
        }
        return theValue.isEmpty();
    }

    @Override
    public boolean matches(IBase theLeftBase, IBase theRightBase, MdmMatcherJson theParams) {
        CanonicalIdentifier left = IdentifierUtil.identifierDtFromIdentifier(theLeftBase);
        if (theParams.getIdentifierSystem() != null && !theParams.getIdentifierSystem().equals(left.getSystemElement().getValueAsString())) {
            return false;
        }
        CanonicalIdentifier right = IdentifierUtil.identifierDtFromIdentifier(theRightBase);
        if (this.isEmpty(left.getValueElement()) || this.isEmpty(right.getValueElement())) {
            return false;
        }
        return left.equals((Object)right);
    }
}

