/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.rules.matcher.fieldmatchers;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.mdm.rules.json.MdmMatcherJson;
import ca.uhn.fhir.mdm.rules.matcher.fieldmatchers.DateTimeWrapper;
import ca.uhn.fhir.mdm.rules.matcher.models.IMdmFieldMatcher;
import org.hl7.fhir.instance.model.api.IBase;

public class HapiDateMatcher
implements IMdmFieldMatcher {
    private final FhirContext myFhirContext;

    public HapiDateMatcher(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
    }

    @Override
    public boolean matches(IBase theLeftBase, IBase theRightBase, MdmMatcherJson theParams) {
        String rightString;
        String leftString;
        DateTimeWrapper left = new DateTimeWrapper(this.myFhirContext, theLeftBase);
        DateTimeWrapper right = new DateTimeWrapper(this.myFhirContext, theRightBase);
        int comparison = left.getPrecision().compareTo((Enum)right.getPrecision());
        if (comparison == 0) {
            leftString = left.getValueAsString();
            rightString = right.getValueAsString();
        } else if (comparison > 0) {
            leftString = left.getValueAsStringWithPrecision(right.getPrecision());
            rightString = right.getValueAsString();
        } else {
            rightString = right.getValueAsStringWithPrecision(left.getPrecision());
            leftString = left.getValueAsString();
        }
        return leftString.equals(rightString);
    }
}

