/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.rules.matcher.fieldmatchers;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.r4.model.BaseDateTimeType;
import org.hl7.fhir.r4.model.DateTimeType;

public class DateTimeWrapper {
    private final TemporalPrecisionEnum myPrecision;
    private final String myValueAsString;

    public DateTimeWrapper(FhirContext theFhirContext, IBase theDate) {
        if (theDate instanceof org.hl7.fhir.dstu3.model.BaseDateTimeType) {
            org.hl7.fhir.dstu3.model.BaseDateTimeType dstu3Date = (org.hl7.fhir.dstu3.model.BaseDateTimeType)theDate;
            this.myPrecision = dstu3Date.getPrecision();
            this.myValueAsString = dstu3Date.getValueAsString();
        } else if (theDate instanceof BaseDateTimeType) {
            BaseDateTimeType r4Date = (BaseDateTimeType)theDate;
            this.myPrecision = r4Date.getPrecision();
            this.myValueAsString = r4Date.getValueAsString();
        } else if (theDate instanceof org.hl7.fhir.r5.model.BaseDateTimeType) {
            org.hl7.fhir.r5.model.BaseDateTimeType r5Date = (org.hl7.fhir.r5.model.BaseDateTimeType)theDate;
            this.myPrecision = r5Date.getPrecision();
            this.myValueAsString = r5Date.getValueAsString();
        } else {
            throw new UnsupportedOperationException(Msg.code((int)1520) + "Version not supported: " + theFhirContext.getVersion().getVersion());
        }
    }

    public TemporalPrecisionEnum getPrecision() {
        return this.myPrecision;
    }

    public String getValueAsStringWithPrecision(TemporalPrecisionEnum thePrecision) {
        DateTimeType dateTimeType = new DateTimeType(this.myValueAsString);
        dateTimeType.setPrecision(thePrecision);
        return dateTimeType.getValueAsString();
    }

    public String getValueAsString() {
        return this.myValueAsString;
    }
}

