/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.rules.json;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.rules.json.MdmRulesJson;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class VectorMatchResultMap {
    private final MdmRulesJson myMdmRulesJson;
    private Map<Long, MdmMatchResultEnum> myVectorToMatchResultMap = new HashMap<Long, MdmMatchResultEnum>();
    private Set<Long> myMatchVectors = new HashSet<Long>();
    private Set<Long> myPossibleMatchVectors = new HashSet<Long>();
    private Map<Long, String> myVectorToFieldMatchNamesMap = new HashMap<Long, String>();

    VectorMatchResultMap(MdmRulesJson theMdmRulesJson) {
        this.myMdmRulesJson = theMdmRulesJson;
        this.initMap();
    }

    private void initMap() {
        for (Map.Entry<String, MdmMatchResultEnum> entry : this.myMdmRulesJson.getMatchResultMap().entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Nonnull
    public MdmMatchResultEnum get(Long theMatchVector) {
        return this.myVectorToMatchResultMap.computeIfAbsent(theMatchVector, this::computeMatchResult);
    }

    private MdmMatchResultEnum computeMatchResult(Long theVector) {
        if (this.myMatchVectors.stream().anyMatch(v -> (v & theVector) == v)) {
            return MdmMatchResultEnum.MATCH;
        }
        if (this.myPossibleMatchVectors.stream().anyMatch(v -> (v & theVector) == v)) {
            return MdmMatchResultEnum.POSSIBLE_MATCH;
        }
        return MdmMatchResultEnum.NO_MATCH;
    }

    private void put(String theFieldMatchNames, MdmMatchResultEnum theMatchResult) {
        long vector = this.getVector(theFieldMatchNames);
        this.myVectorToFieldMatchNamesMap.put(vector, theFieldMatchNames);
        this.myVectorToMatchResultMap.put(vector, theMatchResult);
        if (theMatchResult == MdmMatchResultEnum.MATCH) {
            this.myMatchVectors.add(vector);
        } else if (theMatchResult == MdmMatchResultEnum.POSSIBLE_MATCH) {
            this.myPossibleMatchVectors.add(vector);
        }
    }

    public long getVector(String theFieldMatchNames) {
        long retval = 0L;
        for (String fieldMatchName : VectorMatchResultMap.splitFieldMatchNames(theFieldMatchNames)) {
            int index = this.getFieldMatchIndex(fieldMatchName);
            if (index == -1) {
                throw new ConfigurationException(Msg.code((int)1523) + "There is no matchField with name " + fieldMatchName);
            }
            retval |= (long)(1 << index);
        }
        return retval;
    }

    @Nonnull
    static String[] splitFieldMatchNames(String theFieldMatchNames) {
        return theFieldMatchNames.split(",\\s*");
    }

    private int getFieldMatchIndex(String theFieldMatchName) {
        for (int i = 0; i < this.myMdmRulesJson.size(); ++i) {
            if (!this.myMdmRulesJson.get(i).getName().equals(theFieldMatchName)) continue;
            return i;
        }
        return -1;
    }

    public String getFieldMatchNames(long theVector) {
        return this.myVectorToFieldMatchNamesMap.get(theVector);
    }
}

