/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.rules.json;

import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.rules.json.MdmFieldMatchJson;
import ca.uhn.fhir.mdm.rules.json.MdmFilterSearchParamJson;
import ca.uhn.fhir.mdm.rules.json.MdmResourceSearchParamJson;
import ca.uhn.fhir.mdm.rules.json.VectorMatchResultMap;
import ca.uhn.fhir.model.api.IModelJson;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.util.StdConverter;
import com.google.common.annotations.VisibleForTesting;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

@JsonDeserialize(converter=MdmRulesJsonConverter.class)
public class MdmRulesJson
implements IModelJson {
    @JsonProperty(value="version", required=true)
    String myVersion;
    @JsonProperty(value="candidateSearchParams", required=true)
    List<MdmResourceSearchParamJson> myCandidateSearchParams = new ArrayList<MdmResourceSearchParamJson>();
    @JsonProperty(value="candidateFilterSearchParams", required=true)
    List<MdmFilterSearchParamJson> myCandidateFilterSearchParams = new ArrayList<MdmFilterSearchParamJson>();
    @JsonProperty(value="matchFields", required=true)
    List<MdmFieldMatchJson> myMatchFieldJsonList = new ArrayList<MdmFieldMatchJson>();
    @JsonProperty(value="matchResultMap", required=true)
    Map<String, MdmMatchResultEnum> myMatchResultMap = new HashMap<String, MdmMatchResultEnum>();
    @Deprecated
    @JsonProperty(value="eidSystem")
    String myEnterpriseEIDSystem;
    @JsonProperty(value="eidSystems")
    Map<String, String> myEnterpriseEidSystems = new HashMap<String, String>();
    @JsonProperty(value="mdmTypes")
    List<String> myMdmTypes;
    transient VectorMatchResultMap myVectorMatchResultMap;

    public void addMatchField(MdmFieldMatchJson theMatchRuleName) {
        this.myMatchFieldJsonList.add(theMatchRuleName);
    }

    public void addResourceSearchParam(MdmResourceSearchParamJson theSearchParam) {
        this.myCandidateSearchParams.add(theSearchParam);
    }

    public void addFilterSearchParam(MdmFilterSearchParamJson theSearchParam) {
        this.myCandidateFilterSearchParams.add(theSearchParam);
    }

    int size() {
        return this.myMatchFieldJsonList.size();
    }

    MdmFieldMatchJson get(int theIndex) {
        return this.myMatchFieldJsonList.get(theIndex);
    }

    MdmMatchResultEnum getMatchResult(String theFieldMatchNames) {
        return this.myMatchResultMap.get(theFieldMatchNames);
    }

    public MdmMatchResultEnum getMatchResult(Long theMatchVector) {
        return this.myVectorMatchResultMap.get(theMatchVector);
    }

    public void putMatchResult(String theFieldMatchNames, MdmMatchResultEnum theMatchResult) {
        this.myMatchResultMap.put(theFieldMatchNames, theMatchResult);
        this.initialize();
    }

    Map<String, MdmMatchResultEnum> getMatchResultMap() {
        return Collections.unmodifiableMap(this.myMatchResultMap);
    }

    public void initialize() {
        this.myVectorMatchResultMap = new VectorMatchResultMap(this);
    }

    public List<MdmFieldMatchJson> getMatchFields() {
        return Collections.unmodifiableList(this.myMatchFieldJsonList);
    }

    public List<MdmResourceSearchParamJson> getCandidateSearchParams() {
        return Collections.unmodifiableList(this.myCandidateSearchParams);
    }

    public List<MdmFilterSearchParamJson> getCandidateFilterSearchParams() {
        return Collections.unmodifiableList(this.myCandidateFilterSearchParams);
    }

    @Deprecated
    public String getEnterpriseEIDSystem() {
        return this.myEnterpriseEIDSystem;
    }

    @Deprecated
    public void setEnterpriseEIDSystem(String theEnterpriseEIDSystem) {
        this.myEnterpriseEIDSystem = theEnterpriseEIDSystem;
    }

    public void setEnterpriseEIDSystems(Map<String, String> theEnterpriseEIDSystems) {
        this.myEnterpriseEidSystems = theEnterpriseEIDSystems;
    }

    public void addEnterpriseEIDSystem(String theResourceType, String theEidSystem) {
        if (this.myEnterpriseEidSystems == null) {
            this.myEnterpriseEidSystems = new HashMap<String, String>();
        }
        this.myEnterpriseEidSystems.put(theResourceType, theEidSystem);
    }

    public Map<String, String> getEnterpriseEIDSystems() {
        if (this.myEnterpriseEidSystems != null && !this.myEnterpriseEidSystems.isEmpty()) {
            return this.myEnterpriseEidSystems;
        }
        if (!StringUtils.isBlank((CharSequence)this.myEnterpriseEIDSystem)) {
            HashMap<String, String> retVal = new HashMap<String, String>();
            retVal.put("*", this.myEnterpriseEIDSystem);
            return retVal;
        }
        return Collections.emptyMap();
    }

    public String getEnterpriseEIDSystemForResourceType(String theResourceType) {
        Map<String, String> enterpriseEIDSystems = this.getEnterpriseEIDSystems();
        if (enterpriseEIDSystems.containsKey("*")) {
            return enterpriseEIDSystems.get("*");
        }
        return enterpriseEIDSystems.get(theResourceType);
    }

    public String getVersion() {
        return this.myVersion;
    }

    public MdmRulesJson setVersion(String theVersion) {
        this.myVersion = theVersion;
        return this;
    }

    private void validate() {
        Validate.notBlank((CharSequence)this.myVersion, (String)"version may not be blank", (Object[])new Object[0]);
        Map<String, String> enterpriseEIDSystems = this.getEnterpriseEIDSystems();
        if (enterpriseEIDSystems.containsKey("*")) {
            Validate.isTrue((enterpriseEIDSystems.size() == 1 ? 1 : 0) != 0);
        }
    }

    public String getSummary() {
        return this.myCandidateSearchParams.size() + " Candidate Search Params, " + this.myCandidateFilterSearchParams.size() + " Filter Search Params, " + this.myMatchFieldJsonList.size() + " Match Fields, " + this.myMatchResultMap.size() + " Match Result Entries";
    }

    public String getFieldMatchNamesForVector(long theVector) {
        return this.myVectorMatchResultMap.getFieldMatchNames(theVector);
    }

    public String getDetailedFieldMatchResultWithSuccessInformation(long theVector) {
        ArrayList<CallSite> fieldMatchResult = new ArrayList<CallSite>();
        for (int i = 0; i < this.myMatchFieldJsonList.size(); ++i) {
            if ((theVector & (long)(1 << i)) == 0L) {
                fieldMatchResult.add((CallSite)((Object)(this.myMatchFieldJsonList.get(i).getName() + ": NO")));
                continue;
            }
            fieldMatchResult.add((CallSite)((Object)(this.myMatchFieldJsonList.get(i).getName() + ": YES")));
        }
        return String.join((CharSequence)"\n", fieldMatchResult);
    }

    @VisibleForTesting
    VectorMatchResultMap getVectorMatchResultMapForUnitTest() {
        return this.myVectorMatchResultMap;
    }

    public List<String> getMdmTypes() {
        return this.myMdmTypes;
    }

    public void setMdmTypes(List<String> theMdmTypes) {
        this.myMdmTypes = theMdmTypes;
    }

    static class MdmRulesJsonConverter
    extends StdConverter<MdmRulesJson, MdmRulesJson> {
        public MdmRulesJson convert(MdmRulesJson theMdmRulesJson) {
            theMdmRulesJson.validate();
            theMdmRulesJson.initialize();
            return theMdmRulesJson;
        }
    }
}

