/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.rules.config;

import ca.uhn.fhir.mdm.api.IMdmRuleValidator;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.rules.json.MdmRulesJson;
import ca.uhn.fhir.util.JsonUtil;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MdmSettings
implements IMdmSettings {
    public static final int DEFAULT_CANDIDATE_SEARCH_LIMIT = 10000;
    private final IMdmRuleValidator myMdmRuleValidator;
    private boolean myEnabled;
    private final int myConcurrentConsumers = 1;
    private String myScriptText;
    private String mySurvivorshipRules;
    private MdmRulesJson myMdmRules;
    private boolean myPreventEidUpdates;
    private String myGoldenResourcePartitionName;
    private boolean mySearchAllPartitionForMatch = false;
    private boolean myShouldAutoDeleteGoldenResources = true;
    private boolean myPreventMultipleEids;
    private int myCandidateSearchLimit = 10000;

    @Autowired
    public MdmSettings(IMdmRuleValidator theMdmRuleValidator) {
        this.myMdmRuleValidator = theMdmRuleValidator;
    }

    @Override
    public boolean isEnabled() {
        return this.myEnabled;
    }

    public MdmSettings setEnabled(boolean theEnabled) {
        this.myEnabled = theEnabled;
        return this;
    }

    @Override
    public int getConcurrentConsumers() {
        return 1;
    }

    public String getScriptText() {
        return this.myScriptText;
    }

    public MdmSettings setScriptText(String theScriptText) throws IOException {
        this.myScriptText = theScriptText;
        this.setMdmRules((MdmRulesJson)JsonUtil.deserialize((String)theScriptText, MdmRulesJson.class));
        return this;
    }

    @Override
    public MdmRulesJson getMdmRules() {
        return this.myMdmRules;
    }

    @Override
    public boolean isPreventEidUpdates() {
        return this.myPreventEidUpdates;
    }

    public MdmSettings setPreventEidUpdates(boolean thePreventEidUpdates) {
        this.myPreventEidUpdates = thePreventEidUpdates;
        return this;
    }

    public MdmSettings setMdmRules(MdmRulesJson theMdmRules) {
        this.myMdmRuleValidator.validate(theMdmRules);
        this.myMdmRules = theMdmRules;
        return this;
    }

    @Override
    public boolean isPreventMultipleEids() {
        return this.myPreventMultipleEids;
    }

    @Override
    public String getRuleVersion() {
        return this.myMdmRules.getVersion();
    }

    public MdmSettings setPreventMultipleEids(boolean thePreventMultipleEids) {
        this.myPreventMultipleEids = thePreventMultipleEids;
        return this;
    }

    @Override
    public String getSurvivorshipRules() {
        return this.mySurvivorshipRules;
    }

    public void setSurvivorshipRules(String theSurvivorshipRules) {
        this.mySurvivorshipRules = theSurvivorshipRules;
    }

    @Override
    public int getCandidateSearchLimit() {
        return this.myCandidateSearchLimit;
    }

    public void setCandidateSearchLimit(int theCandidateSearchLimit) {
        this.myCandidateSearchLimit = theCandidateSearchLimit;
    }

    @Override
    public String getGoldenResourcePartitionName() {
        return this.myGoldenResourcePartitionName;
    }

    @Override
    public void setGoldenResourcePartitionName(String theGoldenResourcePartitionName) {
        this.myGoldenResourcePartitionName = theGoldenResourcePartitionName;
    }

    @Override
    public boolean getSearchAllPartitionForMatch() {
        return this.mySearchAllPartitionForMatch;
    }

    @Override
    public void setSearchAllPartitionForMatch(boolean theSearchAllPartitionForMatch) {
        this.mySearchAllPartitionForMatch = theSearchAllPartitionForMatch;
    }

    @Override
    public boolean isAutoExpungeGoldenResources() {
        return this.myShouldAutoDeleteGoldenResources;
    }

    @Override
    public void setAutoExpungeGoldenResources(boolean theShouldAutoExpunge) {
        this.myShouldAutoDeleteGoldenResources = theShouldAutoExpunge;
    }
}

