/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.rules.config;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.mdm.api.IMdmRuleValidator;
import ca.uhn.fhir.mdm.rules.json.MdmFieldMatchJson;
import ca.uhn.fhir.mdm.rules.json.MdmFilterSearchParamJson;
import ca.uhn.fhir.mdm.rules.json.MdmResourceSearchParamJson;
import ca.uhn.fhir.mdm.rules.json.MdmRulesJson;
import ca.uhn.fhir.mdm.rules.json.MdmSimilarityJson;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.SearchParameterUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MdmRuleValidator
implements IMdmRuleValidator {
    private static final Logger ourLog = LoggerFactory.getLogger(MdmRuleValidator.class);
    private final FhirContext myFhirContext;
    private final ISearchParamRegistry mySearchParamRetriever;
    private final FhirTerser myTerser;
    private final IFhirPath myFhirPath;

    @Autowired
    public MdmRuleValidator(FhirContext theFhirContext, ISearchParamRegistry theSearchParamRetriever) {
        this.myFhirContext = theFhirContext;
        this.myTerser = this.myFhirContext.newTerser();
        if (this.myFhirContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.DSTU3)) {
            this.myFhirPath = this.myFhirContext.newFhirPath();
        } else {
            ourLog.debug("Skipping FHIRPath validation as DSTU2 does not support FHIR");
            this.myFhirPath = null;
        }
        this.mySearchParamRetriever = theSearchParamRetriever;
    }

    @Override
    public void validate(MdmRulesJson theMdmRules) {
        this.validateMdmTypes(theMdmRules);
        this.validateSearchParams(theMdmRules);
        this.validateMatchFields(theMdmRules);
        this.validateSystemsAreUris(theMdmRules);
        this.validateEidSystemsMatchMdmTypes(theMdmRules);
    }

    private void validateEidSystemsMatchMdmTypes(MdmRulesJson theMdmRules) {
        theMdmRules.getEnterpriseEIDSystems().keySet().forEach(key -> {
            if (!key.equalsIgnoreCase("*") && !theMdmRules.getMdmTypes().contains(key)) {
                throw new ConfigurationException(Msg.code((int)1507) + String.format("There is an eidSystem set for [%s] but that is not one of the mdmTypes. Valid options are [%s].", key, this.buildValidEidKeysMessage(theMdmRules)));
            }
        });
    }

    private String buildValidEidKeysMessage(MdmRulesJson theMdmRulesJson) {
        ArrayList<String> validTypes = new ArrayList<String>(theMdmRulesJson.getMdmTypes());
        validTypes.add("*");
        return String.join((CharSequence)", ", validTypes);
    }

    private void validateSystemsAreUris(MdmRulesJson theMdmRules) {
        theMdmRules.getEnterpriseEIDSystems().entrySet().forEach(entry -> {
            String resourceType = (String)entry.getKey();
            String uri = (String)entry.getValue();
            if (!resourceType.equals("*")) {
                try {
                    this.myFhirContext.getResourceType(resourceType);
                }
                catch (DataFormatException e) {
                    throw new ConfigurationException(Msg.code((int)1508) + String.format("%s is not a valid resource type, but is set in the eidSystems field.", resourceType));
                }
            }
            this.validateIsUri(uri);
        });
    }

    public void validateMdmTypes(MdmRulesJson theMdmRulesJson) {
        ourLog.info("Validating MDM types {}", theMdmRulesJson.getMdmTypes());
        if (theMdmRulesJson.getMdmTypes() == null) {
            throw new ConfigurationException(Msg.code((int)1509) + "mdmTypes must be set to a list of resource types.");
        }
        for (String resourceType : theMdmRulesJson.getMdmTypes()) {
            this.validateTypeHasIdentifier(resourceType);
        }
    }

    public void validateTypeHasIdentifier(String theResourceType) {
        if (this.mySearchParamRetriever.getActiveSearchParam(theResourceType, "identifier") == null) {
            throw new ConfigurationException(Msg.code((int)1510) + "Resource Type " + theResourceType + " is not supported, as it does not have an 'identifier' field, which is necessary for MDM workflow.");
        }
    }

    private void validateSearchParams(MdmRulesJson theMdmRulesJson) {
        ourLog.info("Validating search parameters {}", theMdmRulesJson.getCandidateSearchParams());
        if (theMdmRulesJson.getCandidateSearchParams().isEmpty()) {
            ourLog.warn("No candidate search parameter was found. Defining candidate search parameter is strongly recommended for better performance of MDM");
        }
        for (MdmResourceSearchParamJson searchParams : theMdmRulesJson.getCandidateSearchParams()) {
            searchParams.iterator().forEachRemaining(searchParam -> this.validateSearchParam("candidateSearchParams", searchParams.getResourceType(), (String)searchParam));
        }
        for (MdmFilterSearchParamJson filter : theMdmRulesJson.getCandidateFilterSearchParams()) {
            this.validateSearchParam("candidateFilterSearchParams", filter.getResourceType(), filter.getSearchParam());
        }
    }

    private void validateSearchParam(String theFieldName, String theTheResourceType, String theTheSearchParam) {
        if ("*".equals(theTheResourceType)) {
            this.validateResourceSearchParam(theFieldName, "Patient", theTheSearchParam);
            this.validateResourceSearchParam(theFieldName, "Practitioner", theTheSearchParam);
        } else {
            this.validateResourceSearchParam(theFieldName, theTheResourceType, theTheSearchParam);
        }
    }

    private void validateResourceSearchParam(String theFieldName, String theResourceType, String theSearchParam) {
        String searchParam = SearchParameterUtil.stripModifier((String)theSearchParam);
        if (this.mySearchParamRetriever.getActiveSearchParam(theResourceType, searchParam) == null) {
            throw new ConfigurationException(Msg.code((int)1511) + "Error in " + theFieldName + ": " + theResourceType + " does not have a search parameter called '" + theSearchParam + "'");
        }
    }

    private void validateMatchFields(MdmRulesJson theMdmRulesJson) {
        ourLog.info("Validating match fields {}", theMdmRulesJson.getMatchFields());
        HashSet<String> names = new HashSet<String>();
        for (MdmFieldMatchJson fieldMatch : theMdmRulesJson.getMatchFields()) {
            if (names.contains(fieldMatch.getName())) {
                throw new ConfigurationException(Msg.code((int)1512) + "Two MatchFields have the same name '" + fieldMatch.getName() + "'");
            }
            names.add(fieldMatch.getName());
            if (fieldMatch.getSimilarity() != null) {
                this.validateSimilarity(fieldMatch);
            } else if (fieldMatch.getMatcher() == null) {
                throw new ConfigurationException(Msg.code((int)1513) + "MatchField " + fieldMatch.getName() + " has neither a similarity nor a matcher.  At least one must be present.");
            }
            this.validatePath(theMdmRulesJson.getMdmTypes(), fieldMatch);
        }
    }

    private void validateSimilarity(MdmFieldMatchJson theFieldMatch) {
        MdmSimilarityJson similarity = theFieldMatch.getSimilarity();
        if (similarity.getMatchThreshold() == null) {
            throw new ConfigurationException(Msg.code((int)1514) + "MatchField " + theFieldMatch.getName() + " similarity " + similarity.getAlgorithm() + " requires a matchThreshold");
        }
    }

    private void validatePath(List<String> theMdmTypes, MdmFieldMatchJson theFieldMatch) {
        String resourceType = theFieldMatch.getResourceType();
        if ("*".equals(resourceType)) {
            this.validateFieldPathForAllTypes(theMdmTypes, theFieldMatch);
        } else {
            this.validateFieldPath(theFieldMatch);
        }
    }

    private void validateFieldPathForAllTypes(List<String> theMdmResourceTypes, MdmFieldMatchJson theFieldMatch) {
        for (String resourceType : theMdmResourceTypes) {
            this.validateFieldPathForType(resourceType, theFieldMatch);
        }
    }

    private void validateFieldPathForType(String theResourceType, MdmFieldMatchJson theFieldMatch) {
        ourLog.debug("Validating resource {} for {} ", (Object)theResourceType, (Object)theFieldMatch.getResourcePath());
        if (theFieldMatch.getFhirPath() != null && theFieldMatch.getResourcePath() != null) {
            throw new ConfigurationException(Msg.code((int)1515) + "MatchField [" + theFieldMatch.getName() + "] resourceType [" + theFieldMatch.getResourceType() + "] has defined both a resourcePath and a fhirPath. You must define one of the two.");
        }
        if (theFieldMatch.getResourcePath() == null && theFieldMatch.getFhirPath() == null) {
            throw new ConfigurationException(Msg.code((int)1516) + "MatchField [" + theFieldMatch.getName() + "] resourceType [" + theFieldMatch.getResourceType() + "] has defined neither a resourcePath or a fhirPath. You must define one of the two.");
        }
        if (theFieldMatch.getResourcePath() != null) {
            try {
                RuntimeResourceDefinition resourceDefinition = this.myFhirContext.getResourceDefinition(theResourceType);
                Class implementingClass = resourceDefinition.getImplementingClass();
                String path = theResourceType + "." + theFieldMatch.getResourcePath();
                this.myTerser.getDefinition(implementingClass, path);
            }
            catch (ConfigurationException | DataFormatException | ClassCastException e) {
                throw new ConfigurationException(Msg.code((int)1517) + "MatchField " + theFieldMatch.getName() + " resourceType " + theFieldMatch.getResourceType() + " has invalid path '" + theFieldMatch.getResourcePath() + "'.  " + e.getMessage());
            }
        }
        try {
            if (this.myFhirPath != null) {
                this.myFhirPath.parse(theResourceType + "." + theFieldMatch.getFhirPath());
            } else {
                ourLog.debug("Can't validate FHIRPath expression due to a lack of IFhirPath object.");
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(Msg.code((int)1518) + "MatchField [" + theFieldMatch.getName() + "] resourceType [" + theFieldMatch.getResourceType() + "] has failed FHIRPath evaluation.  " + e.getMessage());
        }
    }

    private void validateFieldPath(MdmFieldMatchJson theFieldMatch) {
        this.validateFieldPathForType(theFieldMatch.getResourceType(), theFieldMatch);
    }

    private void validateIsUri(String theUri) {
        ourLog.info("Validating system URI {}", (Object)theUri);
        try {
            new URI(theUri);
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException(Msg.code((int)1519) + "Enterprise Identifier System (eidSystem) must be a valid URI");
        }
    }
}

