/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.provider;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.mdm.api.IMdmControllerSvc;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.api.IMdmSubmitSvc;
import ca.uhn.fhir.mdm.provider.BaseMdmProvider;
import ca.uhn.fhir.mdm.provider.MdmControllerHelper;
import ca.uhn.fhir.mdm.provider.MdmLinkHistoryProviderDstu3Plus;
import ca.uhn.fhir.mdm.provider.MdmProviderDstu3Plus;
import ca.uhn.fhir.rest.server.provider.ResourceProviderFactory;
import jakarta.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MdmProviderLoader {
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private ResourceProviderFactory myResourceProviderFactory;
    @Autowired
    private MdmControllerHelper myMdmControllerHelper;
    @Autowired
    private IMdmControllerSvc myMdmControllerSvc;
    @Autowired
    private IMdmSubmitSvc myMdmSubmitSvc;
    @Autowired
    private IMdmSettings myMdmSettings;
    @Autowired
    private JpaStorageSettings myStorageSettings;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    private BaseMdmProvider myMdmProvider;
    private MdmLinkHistoryProviderDstu3Plus myMdmHistoryProvider;

    public void loadProvider() {
        switch (this.myFhirContext.getVersion().getVersion()) {
            case DSTU3: 
            case R4: 
            case R5: {
                this.myResourceProviderFactory.addSupplier(() -> new MdmProviderDstu3Plus(this.myFhirContext, this.myMdmControllerSvc, this.myMdmControllerHelper, this.myMdmSubmitSvc, this.myInterceptorBroadcaster, this.myMdmSettings));
                if (!this.myStorageSettings.isNonResourceDbHistoryEnabled()) break;
                this.myResourceProviderFactory.addSupplier(() -> new MdmLinkHistoryProviderDstu3Plus(this.myFhirContext, this.myMdmControllerSvc, this.myInterceptorBroadcaster));
                break;
            }
            default: {
                throw new ConfigurationException(Msg.code((int)1497) + "MDM not supported for FHIR version " + this.myFhirContext.getVersion().getVersion());
            }
        }
    }

    @PreDestroy
    public void unloadProvider() {
        if (this.myMdmProvider != null) {
            this.myResourceProviderFactory.removeSupplier(() -> this.myMdmProvider);
        }
        if (this.myMdmHistoryProvider != null) {
            this.myResourceProviderFactory.removeSupplier(() -> this.myMdmHistoryProvider);
        }
    }
}

