/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.mdm.api.IMdmControllerSvc;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.api.IMdmSubmitSvc;
import ca.uhn.fhir.mdm.api.paging.MdmPageRequest;
import ca.uhn.fhir.mdm.api.params.MdmQuerySearchParameters;
import ca.uhn.fhir.mdm.model.MdmCreateOrUpdateParams;
import ca.uhn.fhir.mdm.model.MdmMergeGoldenResourcesParams;
import ca.uhn.fhir.mdm.model.MdmTransactionContext;
import ca.uhn.fhir.mdm.model.MdmUnduplicateGoldenResourceParams;
import ca.uhn.fhir.mdm.model.mdmevents.MdmLinkJson;
import ca.uhn.fhir.mdm.model.mdmevents.MdmSubmitEvent;
import ca.uhn.fhir.mdm.provider.BaseMdmProvider;
import ca.uhn.fhir.mdm.provider.MdmControllerHelper;
import ca.uhn.fhir.mdm.provider.MdmControllerUtil;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.util.ParametersUtil;
import jakarta.annotation.Nonnull;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;

public class MdmProviderDstu3Plus
extends BaseMdmProvider {
    private static final Logger ourLog = LoggerFactory.getLogger(MdmProviderDstu3Plus.class);
    private static final String PATIENT_RESOURCE = "Patient";
    private static final String PRACTITIONER_RESOURCE = "Practitioner";
    private final IMdmControllerSvc myMdmControllerSvc;
    private final IMdmSubmitSvc myMdmSubmitSvc;
    private final IMdmSettings myMdmSettings;
    private final MdmControllerHelper myMdmControllerHelper;
    private final IInterceptorBroadcaster myInterceptorBroadcaster;
    public static final int DEFAULT_PAGE_SIZE = 20;
    public static final int MAX_PAGE_SIZE = 100;

    public MdmProviderDstu3Plus(FhirContext theFhirContext, IMdmControllerSvc theMdmControllerSvc, MdmControllerHelper theMdmHelper, IMdmSubmitSvc theMdmSubmitSvc, IInterceptorBroadcaster theIInterceptorBroadcaster, IMdmSettings theIMdmSettings) {
        super(theFhirContext);
        this.myMdmControllerSvc = theMdmControllerSvc;
        this.myMdmControllerHelper = theMdmHelper;
        this.myMdmSubmitSvc = theMdmSubmitSvc;
        this.myInterceptorBroadcaster = theIInterceptorBroadcaster;
        this.myMdmSettings = theIMdmSettings;
    }

    @Operation(name="$match", typeName="Patient")
    public IBaseBundle match(@OperationParam(name="resource", min=1, max=1, typeName="Patient") IAnyResource thePatient, RequestDetails theRequestDetails) {
        if (thePatient == null) {
            throw new InvalidRequestException(Msg.code((int)1498) + "resource may not be null");
        }
        return this.myMdmControllerHelper.getMatchesAndPossibleMatchesForResource(thePatient, PATIENT_RESOURCE, theRequestDetails);
    }

    @Operation(name="$mdm-match")
    public IBaseBundle serverMatch(@OperationParam(name="resource", min=1, max=1) IAnyResource theResource, @OperationParam(name="resourceType", min=1, max=1, typeName="string") IPrimitiveType<String> theResourceType, RequestDetails theRequestDetails) {
        if (theResource == null) {
            throw new InvalidRequestException(Msg.code((int)1499) + "resource may not be null");
        }
        return this.myMdmControllerHelper.getMatchesAndPossibleMatchesForResource(theResource, theResourceType.getValueAsString(), theRequestDetails);
    }

    @Operation(name="$mdm-merge-golden-resources")
    public IBaseResource mergeGoldenResources(@OperationParam(name="fromGoldenResourceId", min=1, max=1, typeName="string") IPrimitiveType<String> theFromGoldenResourceId, @OperationParam(name="toGoldenResourceId", min=1, max=1, typeName="string") IPrimitiveType<String> theToGoldenResourceId, @OperationParam(name="resource", max=1) IAnyResource theMergedResource, RequestDetails theRequestDetails) {
        this.validateMergeParameters(theFromGoldenResourceId, theToGoldenResourceId);
        MdmTransactionContext.OperationType operationType = theMergedResource == null ? MdmTransactionContext.OperationType.MERGE_GOLDEN_RESOURCES : MdmTransactionContext.OperationType.MANUAL_MERGE_GOLDEN_RESOURCES;
        MdmTransactionContext txContext = this.createMdmContext(theRequestDetails, operationType, this.getResourceType("fromGoldenResourceId", theFromGoldenResourceId));
        MdmMergeGoldenResourcesParams params = new MdmMergeGoldenResourcesParams();
        params.setFromGoldenResourceId(theFromGoldenResourceId.getValueAsString());
        params.setToGoldenResourceId(theToGoldenResourceId.getValueAsString());
        params.setManuallyMergedResource(theMergedResource);
        params.setMdmTransactionContext(txContext);
        params.setRequestDetails(theRequestDetails);
        return this.myMdmControllerSvc.mergeGoldenResources(params);
    }

    @Operation(name="$mdm-update-link")
    public IBaseResource updateLink(@OperationParam(name="goldenResourceId", min=1, max=1) IPrimitiveType<String> theGoldenResourceId, @OperationParam(name="resourceId", min=1, max=1) IPrimitiveType<String> theResourceId, @OperationParam(name="matchResult", min=1, max=1) IPrimitiveType<String> theMatchResult, ServletRequestDetails theRequestDetails) {
        this.validateUpdateLinkParameters(theGoldenResourceId, theResourceId, theMatchResult);
        MdmCreateOrUpdateParams updateLinkParams = new MdmCreateOrUpdateParams();
        updateLinkParams.setGoldenResourceId(theGoldenResourceId.getValueAsString());
        updateLinkParams.setResourceId((String)theResourceId.getValue());
        updateLinkParams.setMatchResult(MdmControllerUtil.extractMatchResultOrNull((String)theMatchResult.getValue()));
        updateLinkParams.setMdmContext(this.createMdmContext((RequestDetails)theRequestDetails, MdmTransactionContext.OperationType.UPDATE_LINK, this.getResourceType("goldenResourceId", theGoldenResourceId)));
        updateLinkParams.setRequestDetails((RequestDetails)theRequestDetails);
        return this.myMdmControllerSvc.updateLink(updateLinkParams);
    }

    @Operation(name="$mdm-create-link")
    public IBaseResource createLink(@OperationParam(name="goldenResourceId", min=1, max=1) IPrimitiveType<String> theGoldenResourceId, @OperationParam(name="resourceId", min=1, max=1) IPrimitiveType<String> theResourceId, @OperationParam(name="matchResult", min=0, max=1) IPrimitiveType<String> theMatchResult, ServletRequestDetails theRequestDetails) {
        this.validateCreateLinkParameters(theGoldenResourceId, theResourceId, theMatchResult);
        MdmCreateOrUpdateParams params = new MdmCreateOrUpdateParams();
        params.setGoldenResourceId(theGoldenResourceId.getValueAsString());
        params.setResourceId((String)theResourceId.getValue());
        params.setMatchResult(MdmControllerUtil.extractMatchResultOrNull(this.extractStringOrNull(theMatchResult)));
        params.setRequestDetails((RequestDetails)theRequestDetails);
        params.setMdmContext(this.createMdmContext((RequestDetails)theRequestDetails, MdmTransactionContext.OperationType.CREATE_LINK, this.getResourceType("goldenResourceId", theGoldenResourceId)));
        return this.myMdmControllerSvc.createLink(params);
    }

    @Operation(name="$mdm-clear", returnParameters={@OperationParam(name="jobId", typeName="decimal")})
    public IBaseParameters clearMdmLinks(@OperationParam(name="resourceType", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> theResourceNames, @OperationParam(name="batchSize", typeName="decimal", min=0, max=1) IPrimitiveType<BigDecimal> theBatchSize, ServletRequestDetails theRequestDetails) {
        ArrayList<String> resourceNames = new ArrayList<String>();
        if (ObjectUtils.isNotEmpty(theResourceNames)) {
            resourceNames.addAll(theResourceNames.stream().map(IPrimitiveType::getValue).collect(Collectors.toList()));
            this.validateResourceNames(resourceNames);
        } else {
            resourceNames.addAll(this.myMdmSettings.getMdmRules().getMdmTypes());
        }
        return this.myMdmControllerSvc.submitMdmClearJob(resourceNames, theBatchSize, theRequestDetails);
    }

    private void validateResourceNames(List<String> theResourceNames) {
        for (String resourceName : theResourceNames) {
            if (this.myMdmSettings.isSupportedMdmType(resourceName)) continue;
            throw new InvalidRequestException(Msg.code((int)1500) + "$mdm-clear does not support resource type: " + resourceName);
        }
    }

    @Operation(name="$mdm-query-links", idempotent=true)
    public IBaseParameters queryLinks(@OperationParam(name="goldenResourceId", min=0, max=1, typeName="string") IPrimitiveType<String> theGoldenResourceId, @OperationParam(name="resourceId", min=0, max=1, typeName="string") IPrimitiveType<String> theResourceId, @OperationParam(name="matchResult", min=0, max=1, typeName="string") IPrimitiveType<String> theMatchResult, @OperationParam(name="linkSource", min=0, max=1, typeName="string") IPrimitiveType<String> theLinkSource, @Description(value="Results from this method are returned across multiple pages. This parameter controls the offset when fetching a page.") @OperationParam(name="_offset", min=0, max=1, typeName="integer") IPrimitiveType<Integer> theOffset, @Description(value="Results from this method are returned across multiple pages. This parameter controls the size of those pages.") @OperationParam(name="_count", min=0, max=1, typeName="integer") IPrimitiveType<Integer> theCount, @OperationParam(name="_sort", min=0, max=1, typeName="string") IPrimitiveType<String> theSort, ServletRequestDetails theRequestDetails, @OperationParam(name="resourceType", min=0, max=1, typeName="string") IPrimitiveType<String> theResourceType) {
        MdmPageRequest mdmPageRequest = new MdmPageRequest(theOffset, theCount, 20, 100);
        MdmTransactionContext mdmContext = this.createMdmContext((RequestDetails)theRequestDetails, MdmTransactionContext.OperationType.QUERY_LINKS, this.getResourceType("goldenResourceId", theGoldenResourceId, theResourceType));
        MdmQuerySearchParameters mdmQuerySearchParameters = new MdmQuerySearchParameters(mdmPageRequest).setGoldenResourceId(this.extractStringOrNull(theGoldenResourceId)).setSourceId(this.extractStringOrNull(theResourceId)).setLinkSource(this.extractStringOrNull(theLinkSource)).setMatchResult(this.extractStringOrNull(theMatchResult)).setResourceType(this.extractStringOrNull(theResourceType)).setSort(this.extractStringOrNull(theSort));
        Page<MdmLinkJson> mdmLinkJson = this.myMdmControllerSvc.queryLinks(mdmQuerySearchParameters, mdmContext, (RequestDetails)theRequestDetails);
        return this.parametersFromMdmLinks(mdmLinkJson, true, theRequestDetails, mdmPageRequest);
    }

    @Operation(name="$mdm-duplicate-golden-resources", idempotent=true)
    public IBaseParameters getDuplicateGoldenResources(@Description(formalDefinition="Results from this method are returned across multiple pages. This parameter controls the offset when fetching a page.") @OperationParam(name="_offset", min=0, max=1, typeName="integer") IPrimitiveType<Integer> theOffset, @Description(formalDefinition="Results from this method are returned across multiple pages. This parameter controls the size of those pages.") @OperationParam(name="_count", min=0, max=1, typeName="integer") IPrimitiveType<Integer> theCount, ServletRequestDetails theRequestDetails, @Description(formalDefinition="This parameter controls the returned resource type.") @OperationParam(name="resourceType", min=0, max=1, typeName="string") IPrimitiveType<String> theResourceType) {
        MdmPageRequest mdmPageRequest = new MdmPageRequest(theOffset, theCount, 20, 100);
        Page<MdmLinkJson> possibleDuplicates = this.myMdmControllerSvc.getDuplicateGoldenResources(this.createMdmContext((RequestDetails)theRequestDetails, MdmTransactionContext.OperationType.DUPLICATE_GOLDEN_RESOURCES, null), mdmPageRequest, (RequestDetails)theRequestDetails, this.extractStringOrNull(theResourceType));
        return this.parametersFromMdmLinks(possibleDuplicates, false, theRequestDetails, mdmPageRequest);
    }

    @Operation(name="$mdm-not-duplicate")
    public IBaseParameters notDuplicate(@OperationParam(name="goldenResourceId", min=1, max=1, typeName="string") IPrimitiveType<String> theGoldenResourceId, @OperationParam(name="resourceId", min=1, max=1, typeName="string") IPrimitiveType<String> theResourceId, ServletRequestDetails theRequestDetails) {
        this.validateNotDuplicateParameters(theGoldenResourceId, theResourceId);
        MdmUnduplicateGoldenResourceParams params = new MdmUnduplicateGoldenResourceParams();
        params.setRequestDetails((RequestDetails)theRequestDetails);
        params.setGoldenResourceId(theGoldenResourceId.getValueAsString());
        params.setTargetGoldenResourceId(theResourceId.getValueAsString());
        params.setMdmContext(this.createMdmContext((RequestDetails)theRequestDetails, MdmTransactionContext.OperationType.NOT_DUPLICATE, this.getResourceType("goldenResourceId", theGoldenResourceId)));
        this.myMdmControllerSvc.unduplicateGoldenResource(params);
        IBaseParameters retval = ParametersUtil.newInstance((FhirContext)this.myFhirContext);
        ParametersUtil.addParameterToParametersBoolean((FhirContext)this.myFhirContext, (IBaseParameters)retval, (String)"success", (boolean)true);
        return retval;
    }

    @Operation(name="$mdm-submit", idempotent=false, returnParameters={@OperationParam(name="submitted", typeName="integer")})
    public IBaseParameters mdmBatchOnAllSourceResources(@OperationParam(name="resourceType", min=0, max=1, typeName="string") IPrimitiveType<String> theResourceType, @OperationParam(name="criteria", min=0, max=1, typeName="string") IPrimitiveType<String> theCriteria, @OperationParam(name="batchSize", typeName="decimal", min=0, max=1) IPrimitiveType<BigDecimal> theBatchSize, ServletRequestDetails theRequestDetails) {
        IBaseParameters retval;
        String criteria = this.convertStringTypeToString(theCriteria);
        String resourceType = this.convertStringTypeToString(theResourceType);
        if (theRequestDetails.isPreferRespondAsync()) {
            List<String> urls = this.buildUrlsForJob(criteria, resourceType);
            retval = this.myMdmControllerSvc.submitMdmSubmitJob(urls, theBatchSize, theRequestDetails);
        } else {
            long submittedCount = this.synchronousMdmSubmit(resourceType, null, criteria, (RequestDetails)theRequestDetails);
            retval = this.buildMdmOutParametersWithCount(submittedCount);
        }
        return retval;
    }

    @Nonnull
    private List<String> buildUrlsForJob(String criteria, String resourceType) {
        ArrayList<String> urls = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)resourceType)) {
            String theUrl = resourceType + "?" + criteria;
            urls.add(theUrl);
        } else {
            this.myMdmSettings.getMdmRules().getMdmTypes().stream().map(type -> type + "?" + criteria).forEach(urls::add);
        }
        return urls;
    }

    private String convertStringTypeToString(IPrimitiveType<String> theCriteria) {
        return theCriteria == null ? "" : theCriteria.getValueAsString();
    }

    @Operation(name="$mdm-submit", idempotent=false, typeName="Patient", returnParameters={@OperationParam(name="jobId", typeName="integer")})
    public IBaseParameters mdmBatchPatientInstance(@IdParam IIdType theIdParam, RequestDetails theRequest) {
        long submittedCount = this.synchronousMdmSubmit(null, theIdParam, null, theRequest);
        return this.buildMdmOutParametersWithCount(submittedCount);
    }

    @Operation(name="$mdm-submit", idempotent=false, typeName="Patient", returnParameters={@OperationParam(name="jobId", typeName="integer")})
    public IBaseParameters mdmBatchPatientType(@OperationParam(name="criteria", typeName="string") IPrimitiveType<String> theCriteria, @OperationParam(name="batchSize", typeName="decimal", min=0, max=1) IPrimitiveType<BigDecimal> theBatchSize, ServletRequestDetails theRequest) {
        if (theRequest.isPreferRespondAsync()) {
            String theUrl = "Patient?";
            return this.myMdmControllerSvc.submitMdmSubmitJob(Collections.singletonList(theUrl), theBatchSize, theRequest);
        }
        String criteria = this.convertStringTypeToString(theCriteria);
        long submittedCount = this.synchronousMdmSubmit(PATIENT_RESOURCE, null, criteria, (RequestDetails)theRequest);
        return this.buildMdmOutParametersWithCount(submittedCount);
    }

    @Operation(name="$mdm-submit", idempotent=false, typeName="Practitioner", returnParameters={@OperationParam(name="jobId", typeName="integer")})
    public IBaseParameters mdmBatchPractitionerInstance(@IdParam IIdType theIdParam, RequestDetails theRequest) {
        long submittedCount = this.synchronousMdmSubmit(null, theIdParam, null, theRequest);
        return this.buildMdmOutParametersWithCount(submittedCount);
    }

    @Operation(name="$mdm-submit", idempotent=false, typeName="Practitioner", returnParameters={@OperationParam(name="jobId", typeName="integer")})
    public IBaseParameters mdmBatchPractitionerType(@OperationParam(name="criteria", typeName="string") IPrimitiveType<String> theCriteria, @OperationParam(name="batchSize", typeName="decimal", min=0, max=1) IPrimitiveType<BigDecimal> theBatchSize, ServletRequestDetails theRequest) {
        if (theRequest.isPreferRespondAsync()) {
            String theUrl = "Practitioner?";
            return this.myMdmControllerSvc.submitMdmSubmitJob(Collections.singletonList(theUrl), theBatchSize, theRequest);
        }
        String criteria = this.convertStringTypeToString(theCriteria);
        long submittedCount = this.synchronousMdmSubmit(PRACTITIONER_RESOURCE, null, criteria, (RequestDetails)theRequest);
        return this.buildMdmOutParametersWithCount(submittedCount);
    }

    public IBaseParameters buildMdmOutParametersWithCount(long theCount) {
        IBaseParameters retval = ParametersUtil.newInstance((FhirContext)this.myFhirContext);
        ParametersUtil.addParameterToParametersLong((FhirContext)this.myFhirContext, (IBaseParameters)retval, (String)"submitted", (long)theCount);
        return retval;
    }

    private String getResourceType(String theParamName, IPrimitiveType<String> theResourceId) {
        if (theResourceId != null) {
            return this.getResourceType(theParamName, theResourceId.getValueAsString());
        }
        return "Unknown Resource Types";
    }

    private String getResourceType(String theParamName, IPrimitiveType<String> theResourceId, IPrimitiveType theResourceType) {
        return theResourceType != null ? theResourceType.getValueAsString() : this.getResourceType(theParamName, theResourceId);
    }

    private String getResourceType(String theParamName, String theResourceId) {
        if (StringUtils.isEmpty((CharSequence)theResourceId)) {
            return "Unknown Resource Types";
        }
        IdDt idType = MdmControllerUtil.getGoldenIdDtOrThrowException(theParamName, theResourceId);
        return idType.getResourceType();
    }

    private long synchronousMdmSubmit(String theResourceType, IIdType theIdType, String theCriteria, RequestDetails theRequestDetails) {
        long submittedCount = -1L;
        ArrayList<String> urls = new ArrayList<String>();
        submittedCount = theIdType != null ? this.mdmSubmitWithId(theIdType, theRequestDetails, urls) : (StringUtils.isNotBlank((CharSequence)theResourceType) ? this.submitResourceTypeWithCriteria(theResourceType, theCriteria, theRequestDetails, urls) : this.submitAll(theCriteria, theRequestDetails, urls));
        if (this.myInterceptorBroadcaster.hasHooks((IPointcut)Pointcut.MDM_SUBMIT)) {
            MdmSubmitEvent submitEvent = new MdmSubmitEvent();
            submitEvent.setBatchJob(false);
            submitEvent.setUrls(urls);
            HookParams hookParams = new HookParams();
            hookParams.add(RequestDetails.class, (Object)theRequestDetails);
            hookParams.add(MdmSubmitEvent.class, (Object)submitEvent);
            this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.MDM_SUBMIT, hookParams);
        }
        return submittedCount;
    }

    private long mdmSubmitWithId(IIdType theIdType, RequestDetails theRequestDetails, List<String> theUrls) {
        theUrls.add(theIdType.getValue());
        return this.myMdmSubmitSvc.submitSourceResourceToMdm(theIdType, theRequestDetails);
    }

    private long submitResourceTypeWithCriteria(String theResourceType, String theCriteria, RequestDetails theRequestDetails, List<String> theUrls) {
        Object url = theResourceType;
        if (ObjectUtils.isNotEmpty((Object)theCriteria)) {
            url = (String)url + "?" + theCriteria;
        }
        theUrls.add((String)url);
        return this.myMdmSubmitSvc.submitSourceResourceTypeToMdm(theResourceType, theCriteria, theRequestDetails);
    }

    private long submitAll(String theCriteria, RequestDetails theRequestDetails, List<String> theUrls) {
        List<String> resourceTypes = this.myMdmSettings.getMdmRules().getMdmTypes();
        for (String resourceType : resourceTypes) {
            String url = resourceType + (String)(ObjectUtils.isNotEmpty((Object)theCriteria) ? "?" + theCriteria : "");
            theUrls.add(url);
        }
        return this.myMdmSubmitSvc.submitAllSourceTypesToMdm(theCriteria, theRequestDetails);
    }
}

