/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.mdm.api.IMdmControllerSvc;
import ca.uhn.fhir.mdm.api.params.MdmHistorySearchParameters;
import ca.uhn.fhir.mdm.model.mdmevents.MdmHistoryEvent;
import ca.uhn.fhir.mdm.model.mdmevents.MdmLinkWithRevisionJson;
import ca.uhn.fhir.mdm.provider.BaseMdmProvider;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.util.ParametersUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdmLinkHistoryProviderDstu3Plus
extends BaseMdmProvider {
    private static final Logger ourLog = LoggerFactory.getLogger(MdmLinkHistoryProviderDstu3Plus.class);
    private final IMdmControllerSvc myMdmControllerSvc;
    private final IInterceptorBroadcaster myInterceptorBroadcaster;

    public MdmLinkHistoryProviderDstu3Plus(FhirContext theFhirContext, IMdmControllerSvc theMdmControllerSvc, IInterceptorBroadcaster theIInterceptorBroadcaster) {
        super(theFhirContext);
        this.myMdmControllerSvc = theMdmControllerSvc;
        this.myInterceptorBroadcaster = theIInterceptorBroadcaster;
    }

    @Operation(name="$mdm-link-history", idempotent=true)
    public IBaseParameters historyLinks(@Description(value="The id of the Golden Resource (e.g. Golden Patient Resource).") @OperationParam(name="goldenResourceId", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> theMdmGoldenResourceIds, @Description(value="The id of the source resource (e.g. Patient resource).") @OperationParam(name="resourceId", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> theResourceIds, ServletRequestDetails theRequestDetails) {
        this.validateMdmLinkHistoryParameters(theMdmGoldenResourceIds, theResourceIds);
        List<String> goldenResourceIdsToUse = this.convertToStringsIncludingCommaDelimitedIfNotNull(theMdmGoldenResourceIds);
        List<String> resourceIdsToUse = this.convertToStringsIncludingCommaDelimitedIfNotNull(theResourceIds);
        IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)this.myFhirContext);
        MdmHistorySearchParameters mdmHistorySearchParameters = new MdmHistorySearchParameters().setGoldenResourceIds(goldenResourceIdsToUse).setSourceIds(resourceIdsToUse);
        List<MdmLinkWithRevisionJson> mdmLinkRevisionsFromSvc = this.myMdmControllerSvc.queryLinkHistory(mdmHistorySearchParameters, (RequestDetails)theRequestDetails);
        this.parametersFromMdmLinkRevisions(retVal, mdmLinkRevisionsFromSvc);
        if (this.myInterceptorBroadcaster.hasHooks((IPointcut)Pointcut.MDM_POST_LINK_HISTORY)) {
            MdmHistoryEvent historyEvent = new MdmHistoryEvent();
            historyEvent.setMdmLinkRevisions(mdmLinkRevisionsFromSvc);
            if (CollectionUtils.isNotEmpty(theResourceIds)) {
                historyEvent.setSourceIds(theResourceIds.stream().map(IPrimitiveType::getValueAsString).collect(Collectors.toList()));
            }
            if (CollectionUtils.isNotEmpty(theMdmGoldenResourceIds)) {
                historyEvent.setGoldenResourceIds(theMdmGoldenResourceIds.stream().map(IPrimitiveType::getValueAsString).collect(Collectors.toList()));
            }
            HookParams params = new HookParams();
            params.add(RequestDetails.class, (Object)theRequestDetails);
            params.add(MdmHistoryEvent.class, (Object)historyEvent);
            this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.MDM_POST_LINK_HISTORY, params);
        }
        return retVal;
    }
}

