/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.ReadPartitionIdRequestDetails;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.mdm.api.IMdmMatchFinderSvc;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.api.MatchedTarget;
import ca.uhn.fhir.mdm.provider.MdmControllerUtil;
import ca.uhn.fhir.mdm.util.MdmResourceUtil;
import ca.uhn.fhir.mdm.util.MessageHelper;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceVersionConflictException;
import ca.uhn.fhir.util.BundleBuilder;
import ca.uhn.fhir.validation.IResourceLoader;
import jakarta.annotation.Nonnull;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MdmControllerHelper {
    private final FhirContext myFhirContext;
    private final IResourceLoader myResourceLoader;
    private final IMdmSettings myMdmSettings;
    private final MessageHelper myMessageHelper;
    private final IMdmMatchFinderSvc myMdmMatchFinderSvc;
    private final IRequestPartitionHelperSvc myRequestPartitionHelperSvc;

    @Autowired
    public MdmControllerHelper(FhirContext theFhirContext, IResourceLoader theResourceLoader, IMdmMatchFinderSvc theMdmMatchFinderSvc, IMdmSettings theMdmSettings, MessageHelper theMessageHelper, IRequestPartitionHelperSvc theRequestPartitionHelperSvc) {
        this.myFhirContext = theFhirContext;
        this.myResourceLoader = theResourceLoader;
        this.myMdmSettings = theMdmSettings;
        this.myMdmMatchFinderSvc = theMdmMatchFinderSvc;
        this.myMessageHelper = theMessageHelper;
        this.myRequestPartitionHelperSvc = theRequestPartitionHelperSvc;
    }

    public void validateSameVersion(IAnyResource theResource, String theResourceId) {
        String storedId = theResource.getIdElement().getValue();
        if (this.hasVersionIdPart(theResourceId) && !storedId.equals(theResourceId)) {
            throw new ResourceVersionConflictException(Msg.code((int)1501) + "Requested resource " + theResourceId + " is not the latest version.  Latest version is " + storedId);
        }
    }

    private boolean hasVersionIdPart(String theId) {
        return new IdDt(theId).hasVersionIdPart();
    }

    public IAnyResource getLatestGoldenResourceFromIdOrThrowException(String theParamName, String theGoldenResourceId) {
        IdDt resourceId = MdmControllerUtil.getGoldenIdDtOrThrowException(theParamName, theGoldenResourceId);
        IAnyResource iAnyResource = this.loadResource((IIdType)resourceId.toUnqualifiedVersionless());
        if (MdmResourceUtil.isGoldenRecord((IBaseResource)iAnyResource)) {
            return iAnyResource;
        }
        throw new InvalidRequestException(Msg.code((int)1502) + this.myMessageHelper.getMessageForFailedGoldenResourceLoad(theParamName, theGoldenResourceId));
    }

    public IAnyResource getLatestSourceFromIdOrThrowException(String theParamName, String theSourceId) {
        IIdType sourceId = MdmControllerUtil.getSourceIdDtOrThrowException(theParamName, theSourceId);
        return this.loadResource(sourceId.toUnqualifiedVersionless());
    }

    protected IAnyResource loadResource(IIdType theResourceId) {
        Class resourceClass = this.myFhirContext.getResourceDefinition(theResourceId.getResourceType()).getImplementingClass();
        return (IAnyResource)this.myResourceLoader.load(resourceClass, theResourceId);
    }

    public void validateMergeResources(IAnyResource theFromGoldenResource, IAnyResource theToGoldenResource) {
        this.validateIsMdmManaged("fromGoldenResourceId", theFromGoldenResource);
        this.validateIsMdmManaged("toGoldenResourceId", theToGoldenResource);
    }

    public String toJson(IAnyResource theAnyResource) {
        return this.myFhirContext.newJsonParser().encodeResourceToString((IBaseResource)theAnyResource);
    }

    public void validateIsMdmManaged(String theName, IAnyResource theResource) {
        String resourceType = this.myFhirContext.getResourceType((IBaseResource)theResource);
        if (!this.myMdmSettings.isSupportedMdmType(resourceType)) {
            throw new InvalidRequestException(Msg.code((int)1503) + this.myMessageHelper.getMessageForUnsupportedResource(theName, resourceType));
        }
        if (!MdmResourceUtil.isMdmManaged((IBaseResource)theResource)) {
            throw new InvalidRequestException(Msg.code((int)1504) + this.myMessageHelper.getMessageForUnmanagedResource());
        }
    }

    public IBaseBundle getMatchesAndPossibleMatchesForResource(IAnyResource theResource, String theResourceType, RequestDetails theRequestDetails) {
        ReadPartitionIdRequestDetails details = ReadPartitionIdRequestDetails.forSearchType((String)theResourceType, null, null);
        RequestPartitionId requestPartitionId = this.myMdmSettings.getSearchAllPartitionForMatch() ? RequestPartitionId.allPartitions() : this.myRequestPartitionHelperSvc.determineReadPartitionForRequest(theRequestDetails, details);
        List<MatchedTarget> matches = this.myMdmMatchFinderSvc.getMatchedTargets(theResourceType, theResource, requestPartitionId);
        matches.sort(Comparator.comparing(m -> m.getMatchResult().getNormalizedScore()).reversed());
        BundleBuilder builder = new BundleBuilder(this.myFhirContext);
        builder.setBundleField("type", "searchset");
        builder.setBundleField("id", UUID.randomUUID().toString());
        builder.setMetaField("lastUpdated", (IBase)builder.newPrimitive("instant", (Object)new Date()));
        IBaseBundle retVal = builder.getBundle();
        for (MatchedTarget next : matches) {
            boolean shouldKeepThisEntry;
            boolean bl = shouldKeepThisEntry = next.isMatch() || next.isPossibleMatch();
            if (!shouldKeepThisEntry) continue;
            IBase entry = builder.addEntry();
            builder.addToEntry(entry, "resource", (IBase)next.getTarget());
            IBaseBackboneElement search = builder.addSearch(entry);
            this.toBundleEntrySearchComponent(builder, search, next);
        }
        return retVal;
    }

    public IBaseBackboneElement toBundleEntrySearchComponent(BundleBuilder theBuilder, IBaseBackboneElement theSearch, MatchedTarget theMatchedTarget) {
        theBuilder.setSearchField((IBase)theSearch, "mode", "match");
        double score = theMatchedTarget.getMatchResult().getNormalizedScore();
        theBuilder.setSearchField((IBase)theSearch, "score", theBuilder.newPrimitive("decimal", (Object)BigDecimal.valueOf(score)));
        String matchGrade = this.getMatchGrade(theMatchedTarget);
        IBaseDatatype codeType = (IBaseDatatype)this.myFhirContext.getElementDefinition("code").newInstance((Object)matchGrade);
        IBaseExtension searchExtension = theSearch.addExtension();
        searchExtension.setUrl("http://hl7.org/fhir/StructureDefinition/match-grade");
        searchExtension.setValue(codeType);
        return theSearch;
    }

    @Nonnull
    protected String getMatchGrade(MatchedTarget theTheMatchedTarget) {
        String retVal = "probable";
        if (theTheMatchedTarget.isMatch()) {
            retVal = "certain";
        } else if (theTheMatchedTarget.isPossibleMatch()) {
            retVal = "possible";
        }
        return retVal;
    }
}

