/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.api.paging.MdmPageLinkBuilder;
import ca.uhn.fhir.mdm.api.paging.MdmPageLinkTuple;
import ca.uhn.fhir.mdm.api.paging.MdmPageRequest;
import ca.uhn.fhir.mdm.model.MdmTransactionContext;
import ca.uhn.fhir.mdm.model.mdmevents.MdmLinkJson;
import ca.uhn.fhir.mdm.model.mdmevents.MdmLinkWithRevisionJson;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.TransactionLogMessages;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.util.ParametersUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.springframework.data.domain.Page;

public abstract class BaseMdmProvider {
    protected final FhirContext myFhirContext;

    public BaseMdmProvider(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
    }

    protected void validateMergeParameters(IPrimitiveType<String> theFromGoldenResourceId, IPrimitiveType<String> theToGoldenResourceId) {
        this.validateNotNull("fromGoldenResourceId", theFromGoldenResourceId);
        this.validateNotNull("toGoldenResourceId", theToGoldenResourceId);
        if (((String)theFromGoldenResourceId.getValue()).equals(theToGoldenResourceId.getValue())) {
            throw new InvalidRequestException(Msg.code((int)1493) + "fromGoldenResourceId must be different from toGoldenResourceId");
        }
    }

    private void validateNotNull(String theName, IPrimitiveType<String> theString) {
        if (theString == null || theString.getValue() == null) {
            throw new InvalidRequestException(Msg.code((int)1494) + theName + " cannot be null");
        }
    }

    protected void validateMdmLinkHistoryParameters(List<IPrimitiveType<String>> theGoldenResourceIds, List<IPrimitiveType<String>> theSourceIds) {
        this.validateBothCannotBeNullOrEmpty("goldenResourceId", theGoldenResourceIds, "resourceId", theSourceIds);
    }

    private void validateBothCannotBeNullOrEmpty(String theFirstName, List<IPrimitiveType<String>> theFirstList, String theSecondName, List<IPrimitiveType<String>> theSecondList) {
        if ((theFirstList == null || theFirstList.isEmpty()) && (theSecondList == null || theSecondList.isEmpty())) {
            throw new InvalidRequestException(Msg.code((int)2292) + "Please include either [" + theFirstName + "]s, [" + theSecondName + "]s, or both in your search inputs.");
        }
    }

    protected void validateUpdateLinkParameters(IPrimitiveType<String> theGoldenResourceId, IPrimitiveType<String> theResourceId, IPrimitiveType<String> theMatchResult) {
        this.validateNotNull("goldenResourceId", theGoldenResourceId);
        this.validateNotNull("resourceId", theResourceId);
        this.validateNotNull("matchResult", theMatchResult);
        MdmMatchResultEnum matchResult = MdmMatchResultEnum.valueOf((String)theMatchResult.getValue());
        switch (matchResult) {
            case NO_MATCH: 
            case MATCH: {
                break;
            }
            default: {
                throw new InvalidRequestException(Msg.code((int)1495) + "$mdm-update-link illegal matchResult value '" + matchResult + "'.  Must be " + MdmMatchResultEnum.NO_MATCH + " or " + MdmMatchResultEnum.MATCH);
            }
        }
    }

    protected void validateNotDuplicateParameters(IPrimitiveType<String> theGoldenResourceId, IPrimitiveType<String> theResourceId) {
        this.validateNotNull("goldenResourceId", theGoldenResourceId);
        this.validateNotNull("resourceId", theResourceId);
    }

    protected void validateCreateLinkParameters(IPrimitiveType<String> theGoldenResourceId, IPrimitiveType<String> theResourceId, @Nullable IPrimitiveType<String> theMatchResult) {
        this.validateNotNull("goldenResourceId", theGoldenResourceId);
        this.validateNotNull("resourceId", theResourceId);
        if (theMatchResult != null) {
            MdmMatchResultEnum matchResult = MdmMatchResultEnum.valueOf((String)theMatchResult.getValue());
            switch (matchResult) {
                case NO_MATCH: 
                case MATCH: 
                case POSSIBLE_MATCH: {
                    break;
                }
                default: {
                    throw new InvalidRequestException(Msg.code((int)1496) + "$mdm-create-link illegal matchResult value '" + matchResult + "'.  Must be " + MdmMatchResultEnum.NO_MATCH + ", " + MdmMatchResultEnum.MATCH + " or " + MdmMatchResultEnum.POSSIBLE_MATCH);
                }
            }
        }
    }

    protected MdmTransactionContext createMdmContext(RequestDetails theRequestDetails, MdmTransactionContext.OperationType theOperationType, String theResourceType) {
        TransactionLogMessages transactionLogMessages = TransactionLogMessages.createFromTransactionGuid((String)theRequestDetails.getTransactionGuid());
        MdmTransactionContext mdmTransactionContext = new MdmTransactionContext(transactionLogMessages, theOperationType);
        mdmTransactionContext.setResourceType(theResourceType);
        return mdmTransactionContext;
    }

    @Nonnull
    protected List<String> convertToStringsIncludingCommaDelimitedIfNotNull(List<IPrimitiveType<String>> thePrimitiveTypeStrings) {
        if (thePrimitiveTypeStrings == null) {
            return Collections.emptyList();
        }
        return thePrimitiveTypeStrings.stream().map(this::extractStringOrNull).filter(Objects::nonNull).map(input -> Arrays.asList(input.split(","))).flatMap(Collection::stream).collect(Collectors.toUnmodifiableList());
    }

    protected String extractStringOrNull(IPrimitiveType<String> theString) {
        if (theString == null) {
            return null;
        }
        return (String)theString.getValue();
    }

    protected IBaseParameters parametersFromMdmLinks(Page<MdmLinkJson> theMdmLinkStream, boolean theIncludeResultAndSource, ServletRequestDetails theServletRequestDetails, MdmPageRequest thePageRequest) {
        IBaseParameters retval = ParametersUtil.newInstance((FhirContext)this.myFhirContext);
        this.addPagingParameters(retval, theMdmLinkStream, theServletRequestDetails, thePageRequest);
        long numDuplicates = theMdmLinkStream.getTotalElements();
        ParametersUtil.addParameterToParametersLong((FhirContext)this.myFhirContext, (IBaseParameters)retval, (String)"total", (long)numDuplicates);
        theMdmLinkStream.getContent().forEach(mdmLink -> {
            IBase resultPart = ParametersUtil.addParameterToParameters((FhirContext)this.myFhirContext, (IBaseParameters)retval, (String)"link");
            ParametersUtil.addPartString((FhirContext)this.myFhirContext, (IBase)resultPart, (String)"goldenResourceId", (String)mdmLink.getGoldenResourceId());
            ParametersUtil.addPartString((FhirContext)this.myFhirContext, (IBase)resultPart, (String)"sourceResourceId", (String)mdmLink.getSourceId());
            if (theIncludeResultAndSource) {
                ParametersUtil.addPartString((FhirContext)this.myFhirContext, (IBase)resultPart, (String)"matchResult", (String)mdmLink.getMatchResult().name());
                ParametersUtil.addPartString((FhirContext)this.myFhirContext, (IBase)resultPart, (String)"linkSource", (String)mdmLink.getLinkSource().name());
                ParametersUtil.addPartBoolean((FhirContext)this.myFhirContext, (IBase)resultPart, (String)"eidMatch", (Boolean)mdmLink.getEidMatch());
                ParametersUtil.addPartBoolean((FhirContext)this.myFhirContext, (IBase)resultPart, (String)"hadToCreateNewResource", (Boolean)mdmLink.getLinkCreatedNewResource());
                ParametersUtil.addPartDecimal((FhirContext)this.myFhirContext, (IBase)resultPart, (String)"score", (Double)mdmLink.getScore());
                ParametersUtil.addPartDecimal((FhirContext)this.myFhirContext, (IBase)resultPart, (String)"linkCreated", (Double)Double.valueOf(mdmLink.getCreated().getTime()));
                ParametersUtil.addPartDecimal((FhirContext)this.myFhirContext, (IBase)resultPart, (String)"linkUpdated", (Double)Double.valueOf(mdmLink.getUpdated().getTime()));
            }
        });
        return retval;
    }

    protected void parametersFromMdmLinkRevisions(IBaseParameters theRetVal, List<MdmLinkWithRevisionJson> theMdmLinkRevisions) {
        if (theMdmLinkRevisions.isEmpty()) {
            IBase resultPart = ParametersUtil.addParameterToParameters((FhirContext)this.myFhirContext, (IBaseParameters)theRetVal, (String)"historical links not found for query parameters");
            ParametersUtil.addPartString((FhirContext)this.myFhirContext, (IBase)resultPart, (String)"theResults", (String)"historical links not found for query parameters");
        }
        theMdmLinkRevisions.forEach(mdmLinkRevision -> this.parametersFromMdmLinkRevision(theRetVal, (MdmLinkWithRevisionJson)mdmLinkRevision));
    }

    private void parametersFromMdmLinkRevision(IBaseParameters retVal, MdmLinkWithRevisionJson mdmLinkRevision) {
        IBase resultPart = ParametersUtil.addParameterToParameters((FhirContext)this.myFhirContext, (IBaseParameters)retVal, (String)"historical link");
        MdmLinkJson mdmLink = mdmLinkRevision.getMdmLink();
        ParametersUtil.addPartString((FhirContext)this.myFhirContext, (IBase)resultPart, (String)"goldenResourceId", (String)mdmLink.getGoldenResourceId());
        ParametersUtil.addPartString((FhirContext)this.myFhirContext, (IBase)resultPart, (String)"revisionTimestamp", (String)mdmLinkRevision.getRevisionTimestamp().toString());
        ParametersUtil.addPartString((FhirContext)this.myFhirContext, (IBase)resultPart, (String)"sourceResourceId", (String)mdmLink.getSourceId());
        ParametersUtil.addPartString((FhirContext)this.myFhirContext, (IBase)resultPart, (String)"matchResult", (String)mdmLink.getMatchResult().name());
        ParametersUtil.addPartDecimal((FhirContext)this.myFhirContext, (IBase)resultPart, (String)"score", (Double)mdmLink.getScore());
        ParametersUtil.addPartString((FhirContext)this.myFhirContext, (IBase)resultPart, (String)"linkSource", (String)mdmLink.getLinkSource().name());
        ParametersUtil.addPartBoolean((FhirContext)this.myFhirContext, (IBase)resultPart, (String)"eidMatch", (Boolean)mdmLink.getEidMatch());
        ParametersUtil.addPartBoolean((FhirContext)this.myFhirContext, (IBase)resultPart, (String)"hadToCreateNewResource", (Boolean)mdmLink.getLinkCreatedNewResource());
        ParametersUtil.addPartDecimal((FhirContext)this.myFhirContext, (IBase)resultPart, (String)"score", (Double)mdmLink.getScore());
        ParametersUtil.addPartDecimal((FhirContext)this.myFhirContext, (IBase)resultPart, (String)"linkCreated", (Double)Double.valueOf(mdmLink.getCreated().getTime()));
        ParametersUtil.addPartDecimal((FhirContext)this.myFhirContext, (IBase)resultPart, (String)"linkUpdated", (Double)Double.valueOf(mdmLink.getUpdated().getTime()));
    }

    protected void addPagingParameters(IBaseParameters theParameters, Page<MdmLinkJson> theCurrentPage, ServletRequestDetails theServletRequestDetails, MdmPageRequest thePageRequest) {
        MdmPageLinkTuple mdmPageLinkTuple = MdmPageLinkBuilder.buildMdmPageLinks(theServletRequestDetails, theCurrentPage, thePageRequest);
        if (mdmPageLinkTuple.getPreviousLink().isPresent()) {
            ParametersUtil.addParameterToParametersUri((FhirContext)this.myFhirContext, (IBaseParameters)theParameters, (String)"prev", (String)mdmPageLinkTuple.getPreviousLink().get());
        }
        ParametersUtil.addParameterToParametersUri((FhirContext)this.myFhirContext, (IBaseParameters)theParameters, (String)"self", (String)mdmPageLinkTuple.getSelfLink());
        if (mdmPageLinkTuple.getNextLink().isPresent()) {
            ParametersUtil.addParameterToParametersUri((FhirContext)this.myFhirContext, (IBaseParameters)theParameters, (String)"next", (String)mdmPageLinkTuple.getNextLink().get());
        }
    }
}

