/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.model;

import ca.uhn.fhir.mdm.api.IMdmLink;
import ca.uhn.fhir.rest.server.TransactionLogMessages;
import java.util.ArrayList;
import java.util.List;

public class MdmTransactionContext {
    private TransactionLogMessages myTransactionLogMessages;
    private OperationType myRestOperation;
    private String myResourceType;
    private boolean myIsBlockedResource;
    private List<IMdmLink> myMdmLinkEvents = new ArrayList<IMdmLink>();

    public TransactionLogMessages getTransactionLogMessages() {
        return this.myTransactionLogMessages;
    }

    public MdmTransactionContext() {
    }

    public MdmTransactionContext(OperationType theRestOperation) {
        this.myRestOperation = theRestOperation;
    }

    public MdmTransactionContext(TransactionLogMessages theTransactionLogMessages, OperationType theRestOperation) {
        this(theRestOperation);
        this.myTransactionLogMessages = theTransactionLogMessages;
    }

    public MdmTransactionContext(TransactionLogMessages theTransactionLogMessages, OperationType theRestOperation, String theResourceType) {
        this(theTransactionLogMessages, theRestOperation);
        this.setResourceType(theResourceType);
    }

    public void addTransactionLogMessage(String theMessage) {
        if (this.myTransactionLogMessages == null) {
            return;
        }
        TransactionLogMessages.addMessage((TransactionLogMessages)this.myTransactionLogMessages, (String)theMessage);
    }

    public OperationType getRestOperation() {
        return this.myRestOperation;
    }

    public void setTransactionLogMessages(TransactionLogMessages theTransactionLogMessages) {
        this.myTransactionLogMessages = theTransactionLogMessages;
    }

    public void setRestOperation(OperationType theRestOperation) {
        this.myRestOperation = theRestOperation;
    }

    public String getResourceType() {
        return this.myResourceType;
    }

    public void setResourceType(String myResourceType) {
        this.myResourceType = myResourceType;
    }

    public List<IMdmLink> getMdmLinks() {
        return this.myMdmLinkEvents;
    }

    public MdmTransactionContext addMdmLink(IMdmLink theMdmLinkEvent) {
        this.getMdmLinks().add(theMdmLinkEvent);
        return this;
    }

    public void setMdmLinks(List<IMdmLink> theMdmLinkEvents) {
        this.myMdmLinkEvents = theMdmLinkEvents;
    }

    public void setIsBlocked(boolean theIsBlocked) {
        this.myIsBlockedResource = theIsBlocked;
    }

    public boolean getIsBlocked() {
        return this.myIsBlockedResource;
    }

    public static enum OperationType {
        CREATE_RESOURCE,
        UPDATE_RESOURCE,
        SUBMIT_RESOURCE_TO_MDM,
        QUERY_LINKS,
        UPDATE_LINK,
        CREATE_LINK,
        DUPLICATE_GOLDEN_RESOURCES,
        NOT_DUPLICATE,
        MERGE_GOLDEN_RESOURCES,
        MANUAL_MERGE_GOLDEN_RESOURCES;

    }
}

