/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.model;

import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.StringJoiner;

public class MdmPidTuple<T extends IResourcePersistentId> {
    private final T myGoldenPid;
    @Nullable
    private final Integer myGoldenPartitionId;
    private final T mySourcePid;
    @Nullable
    private final Integer mySourcePartitionId;

    private MdmPidTuple(T theGoldenPid, @Nullable Integer theGoldenPartitionId, T theSourcePid, @Nullable Integer theSourcePartitionId) {
        this.myGoldenPid = theGoldenPid;
        this.mySourcePid = theSourcePid;
        this.myGoldenPartitionId = theGoldenPartitionId;
        this.mySourcePartitionId = theSourcePartitionId;
    }

    public static <P extends IResourcePersistentId> MdmPidTuple<P> fromGoldenAndSource(P theGoldenPid, P theSourcePid) {
        return new MdmPidTuple<P>(theGoldenPid, null, theSourcePid, null);
    }

    public static <P extends IResourcePersistentId> MdmPidTuple<P> fromGoldenAndSourceAndPartitionIds(P theGoldenPid, Integer theGoldenPartitionId, P theSourcePid, Integer theSourcePartitionId) {
        return new MdmPidTuple<P>(theGoldenPid, theGoldenPartitionId, theSourcePid, theSourcePartitionId);
    }

    public T getGoldenPid() {
        return this.myGoldenPid;
    }

    @Nullable
    public Integer getGoldenPartitionId() {
        return this.myGoldenPartitionId;
    }

    public T getSourcePid() {
        return this.mySourcePid;
    }

    @Nullable
    public Integer getSourcePartitionId() {
        return this.mySourcePartitionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MdmPidTuple that = (MdmPidTuple)o;
        return Objects.equals(this.myGoldenPid, that.myGoldenPid) && Objects.equals(this.myGoldenPartitionId, that.myGoldenPartitionId) && Objects.equals(this.mySourcePid, that.mySourcePid) && Objects.equals(this.mySourcePartitionId, that.mySourcePartitionId);
    }

    public int hashCode() {
        return Objects.hash(this.myGoldenPid, this.myGoldenPartitionId, this.mySourcePid, this.mySourcePartitionId);
    }

    public String toString() {
        return new StringJoiner(", ", MdmPidTuple.class.getSimpleName() + "[", "]").add("myGoldenPid=" + this.myGoldenPid).add("myGoldenPartitionId=" + this.myGoldenPartitionId).add("mySourcePid=" + this.mySourcePid).add("mySourcePartitionId=" + this.mySourcePartitionId).toString();
    }
}

