/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.model;

import ca.uhn.fhir.mdm.api.MdmLinkSourceEnum;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.model.MdmLinkMetrics;
import ca.uhn.fhir.mdm.model.MdmLinkScoreMetrics;
import ca.uhn.fhir.mdm.model.MdmResourceMetrics;
import ca.uhn.fhir.model.api.IModelJson;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class MdmMetrics
extends MdmResourceMetrics
implements IModelJson {
    @JsonProperty(value="resourceType")
    private String myResourceType;
    @JsonProperty(value="matchResult2linkSource2count")
    private Map<MdmMatchResultEnum, Map<MdmLinkSourceEnum, Long>> myMatchTypeToLinkToCountMap;
    @JsonProperty(value="scoreCounts")
    private Map<String, Long> myScoreCounts;
    @JsonProperty(value="goldenResources")
    private long myGoldenResourcesCount;
    @JsonProperty(value="sourceResources")
    private long mySourceResourcesCount;
    @JsonProperty(value="excludedResources")
    private long myExcludedResources;

    @Override
    public String getResourceType() {
        return this.myResourceType;
    }

    public Map<MdmMatchResultEnum, Map<MdmLinkSourceEnum, Long>> getMatchTypeToLinkToCountMap() {
        if (this.myMatchTypeToLinkToCountMap == null) {
            this.myMatchTypeToLinkToCountMap = new HashMap<MdmMatchResultEnum, Map<MdmLinkSourceEnum, Long>>();
        }
        return this.myMatchTypeToLinkToCountMap;
    }

    public void addMetric(MdmMatchResultEnum theMdmMatchResultEnum, MdmLinkSourceEnum theLinkSourceEnum, long theCount) {
        Map<MdmMatchResultEnum, Map<MdmLinkSourceEnum, Long>> map = this.getMatchTypeToLinkToCountMap();
        if (!map.containsKey((Object)theMdmMatchResultEnum)) {
            map.put(theMdmMatchResultEnum, new HashMap());
        }
        Map<MdmLinkSourceEnum, Long> lsToCountMap = map.get((Object)theMdmMatchResultEnum);
        lsToCountMap.put(theLinkSourceEnum, theCount);
    }

    @Override
    public void setResourceType(String theResourceType) {
        this.myResourceType = theResourceType;
    }

    @Override
    public long getGoldenResourcesCount() {
        return this.myGoldenResourcesCount;
    }

    @Override
    public void setGoldenResourcesCount(long theGoldenResourcesCount) {
        this.myGoldenResourcesCount = theGoldenResourcesCount;
    }

    @Override
    public long getSourceResourcesCount() {
        return this.mySourceResourcesCount;
    }

    @Override
    public void setSourceResourcesCount(long theSourceResourcesCount) {
        this.mySourceResourcesCount = theSourceResourcesCount;
    }

    @Override
    public long getExcludedResources() {
        return this.myExcludedResources;
    }

    @Override
    public void setExcludedResources(long theExcludedResources) {
        this.myExcludedResources = theExcludedResources;
    }

    public Map<String, Long> getScoreCounts() {
        if (this.myScoreCounts == null) {
            this.myScoreCounts = new LinkedHashMap<String, Long>();
        }
        return this.myScoreCounts;
    }

    public void addScore(String theScore, Long theCount) {
        this.getScoreCounts().put(theScore, theCount);
    }

    public static MdmMetrics fromSeperableMetrics(MdmResourceMetrics theMdmResourceMetrics, MdmLinkMetrics theLinkMetrics, MdmLinkScoreMetrics theLinkScoreMetrics) {
        MdmMetrics metrics = new MdmMetrics();
        metrics.setResourceType(theMdmResourceMetrics.getResourceType());
        metrics.setExcludedResources(theMdmResourceMetrics.getExcludedResources());
        metrics.setGoldenResourcesCount(theMdmResourceMetrics.getGoldenResourcesCount());
        metrics.setSourceResourcesCount(theMdmResourceMetrics.getSourceResourcesCount());
        metrics.myMatchTypeToLinkToCountMap = theLinkMetrics.getMatchTypeToLinkToCountMap();
        metrics.myScoreCounts = theLinkScoreMetrics.getScoreCounts();
        return metrics;
    }
}

