/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.model;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.fhirpath.IFhirPath;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r5.model.Identifier;

public class CanonicalEID {
    private String mySystem;
    private String myUse;
    private String myValue;

    public CanonicalEID(String theSystem, String theValue, String theUse) {
        this.mySystem = theSystem;
        this.myUse = theUse;
        this.myValue = theValue;
    }

    private CanonicalEID(IFhirPath theFhirPath, IBase theIBase) {
        List value = theFhirPath.evaluate(theIBase, "value", IPrimitiveType.class);
        List system = theFhirPath.evaluate(theIBase, "system", IPrimitiveType.class);
        List use = theFhirPath.evaluate(theIBase, "use", IPrimitiveType.class);
        this.myUse = use.isEmpty() ? null : ((IPrimitiveType)use.get(0)).getValueAsString();
        this.myValue = value.isEmpty() ? null : ((IPrimitiveType)value.get(0)).getValueAsString();
        this.mySystem = system.isEmpty() ? null : ((IPrimitiveType)system.get(0)).getValueAsString();
    }

    private static String buildEidFhirPath(FhirContext theFhirContext, String theEidSystem, IBaseResource theBaseResource) {
        return theFhirContext.getResourceType(theBaseResource) + ".identifier.where(system='" + theEidSystem + "')";
    }

    public org.hl7.fhir.r4.model.Identifier toR4() {
        return new org.hl7.fhir.r4.model.Identifier().setUse(Identifier.IdentifierUse.fromCode((String)this.myUse)).setSystem(this.mySystem).setValue(this.myValue);
    }

    public Identifier toDSTU3() {
        return new Identifier().setUse(Identifier.IdentifierUse.fromCode((String)this.myUse)).setSystem(this.mySystem).setValue(this.myValue);
    }

    public org.hl7.fhir.r5.model.Identifier toR5() {
        return new org.hl7.fhir.r5.model.Identifier().setUse(Identifier.IdentifierUse.fromCode((String)this.myUse)).setSystem(this.mySystem).setValue(this.myValue);
    }

    public String getSystem() {
        return this.mySystem;
    }

    public String getUse() {
        return this.myUse;
    }

    public String getValue() {
        return this.myValue;
    }

    public void setSystem(String theSystem) {
        this.mySystem = theSystem;
    }

    public void setUse(String theUse) {
        this.myUse = theUse;
    }

    private void setValue(String theValue) {
        this.myValue = theValue;
    }

    public String toString() {
        return this.mySystem + "|" + this.myValue;
    }

    public static List<CanonicalEID> extractFromResource(FhirContext theFhirContext, String theEidSystem, IBaseResource theBaseResource) {
        IFhirPath fhirPath = theFhirContext.newFhirPath();
        String eidPath = CanonicalEID.buildEidFhirPath(theFhirContext, theEidSystem, theBaseResource);
        List evaluate = fhirPath.evaluate((IBase)theBaseResource, eidPath, IBase.class);
        return evaluate.stream().map(ibase -> new CanonicalEID(fhirPath, (IBase)ibase)).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (!(o instanceof CanonicalEID)) {
            return false;
        }
        CanonicalEID otherEid = (CanonicalEID)o;
        return Objects.equals(otherEid.getSystem(), this.getSystem()) && Objects.equals(otherEid.getValue(), this.getValue()) && Objects.equals(otherEid.getUse(), this.getUse());
    }

    public int hashCode() {
        return Objects.hash(this.mySystem, this.myValue, this.myUse);
    }
}

