/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.interceptor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.model.DeleteConflictList;
import ca.uhn.fhir.jpa.api.svc.IDeleteExpungeSvc;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.api.svc.IMdmClearHelperSvc;
import ca.uhn.fhir.jpa.dao.expunge.IExpungeEverythingService;
import ca.uhn.fhir.mdm.api.IMdmLink;
import ca.uhn.fhir.mdm.api.IMdmLinkUpdaterSvc;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.api.IMdmSubmitSvc;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.dao.IMdmLinkDao;
import ca.uhn.fhir.mdm.interceptor.IMdmStorageInterceptor;
import ca.uhn.fhir.mdm.model.CanonicalEID;
import ca.uhn.fhir.mdm.model.MdmCreateOrUpdateParams;
import ca.uhn.fhir.mdm.model.MdmTransactionContext;
import ca.uhn.fhir.mdm.svc.MdmLinkDeleteSvc;
import ca.uhn.fhir.mdm.util.EIDHelper;
import ca.uhn.fhir.mdm.util.MdmResourceUtil;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.TransactionLogMessages;
import ca.uhn.fhir.rest.server.exceptions.ForbiddenOperationException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MdmStorageInterceptor
implements IMdmStorageInterceptor {
    private static final Logger ourLog = LoggerFactory.getLogger(MdmStorageInterceptor.class);
    private static final ThreadLocal<Boolean> ourLinksDeletedBeforehand = ThreadLocal.withInitial(() -> Boolean.FALSE);
    @Autowired
    private IExpungeEverythingService myExpungeEverythingService;
    @Autowired
    private MdmLinkDeleteSvc myMdmLinkDeleteSvc;
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private EIDHelper myEIDHelper;
    @Autowired
    private IMdmSettings myMdmSettings;
    @Autowired
    private IIdHelperService myIdHelperSvc;
    @Autowired
    private IMdmLinkDao myMdmLinkDao;
    @Autowired
    private IMdmSubmitSvc myMdmSubmitSvc;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private IMdmLinkUpdaterSvc mdmLinkUpdaterSvc;
    @Autowired
    private IMdmClearHelperSvc<? extends IResourcePersistentId<?>> myIMdmClearHelperSvc;

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED)
    public void blockManualResourceManipulationOnCreate(IBaseResource theBaseResource, RequestDetails theRequestDetails, ServletRequestDetails theServletRequestDetails) {
        ourLog.debug("Starting pre-storage resource created hook for {}, {}, {}", new Object[]{theBaseResource, theRequestDetails, theServletRequestDetails});
        if (theBaseResource == null) {
            ourLog.warn("Attempting to block golden resource manipulation on a null resource");
            return;
        }
        if (this.myMdmSettings.isPreventMultipleEids()) {
            ourLog.debug("Forbidding multiple EIDs on ", (Object)theBaseResource);
            this.forbidIfHasMultipleEids(theBaseResource);
        }
        if (this.isInternalRequest(theRequestDetails)) {
            ourLog.debug("Internal request - completed processing");
            return;
        }
        this.forbidIfMdmManagedTagIsPresent(theBaseResource);
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED)
    public void blockManualGoldenResourceManipulationOnUpdate(IBaseResource theOldResource, IBaseResource theUpdatedResource, RequestDetails theRequestDetails, ServletRequestDetails theServletRequestDetails) {
        ourLog.debug("Starting pre-storage resource updated hook for {}, {}, {}, {}", new Object[]{theOldResource, theUpdatedResource, theRequestDetails, theServletRequestDetails});
        if (theUpdatedResource == null) {
            ourLog.warn("Attempting to block golden resource manipulation on a null resource");
            return;
        }
        if (this.myMdmSettings.isPreventMultipleEids()) {
            ourLog.debug("Forbidding multiple EIDs on ", (Object)theUpdatedResource);
            this.forbidIfHasMultipleEids(theUpdatedResource);
        }
        if (MdmResourceUtil.isGoldenRecordRedirected(theUpdatedResource)) {
            ourLog.debug("Deleting MDM links to deactivated Golden resource {}", (Object)theUpdatedResource.getIdElement().toUnqualifiedVersionless());
            int deleted = this.myMdmLinkDeleteSvc.deleteNonRedirectWithAnyReferenceTo(theUpdatedResource);
            if (deleted > 0) {
                ourLog.debug("Deleted {} MDM links", (Object)deleted);
            }
        }
        if (this.isInternalRequest(theRequestDetails)) {
            ourLog.debug("Internal request - completed processing");
            return;
        }
        if (theOldResource != null) {
            this.forbidIfMdmManagedTagIsPresent(theOldResource);
            this.forbidModifyingMdmTag(theUpdatedResource, theOldResource);
        }
        if (this.myMdmSettings.isPreventEidUpdates()) {
            this.forbidIfModifyingExternalEidOnTarget(theUpdatedResource, theOldResource);
        }
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_DELETED)
    public void deleteMdmLinks(RequestDetails theRequest, IBaseResource theResource) {
        if (ourLinksDeletedBeforehand.get().booleanValue()) {
            return;
        }
        if (this.myMdmSettings.isSupportedMdmType(this.myFhirContext.getResourceType(theResource))) {
            ArrayList<IMdmLink> possibleMatches;
            IIdType sourceId = theResource.getIdElement().toVersionless();
            IResourcePersistentId sourcePid = this.myIdHelperSvc.getPidOrThrowException(RequestPartitionId.allPartitions(), sourceId);
            List allLinks = this.myMdmLinkDao.findLinksAssociatedWithGoldenResourceOfSourceResourceExcludingNoMatch(sourcePid);
            Map<MdmMatchResultEnum, List<IMdmLink>> linksByMatchResult = allLinks.stream().collect(Collectors.groupingBy(IMdmLink::getMatchResult));
            ArrayList<IMdmLink> matches = linksByMatchResult.containsKey((Object)MdmMatchResultEnum.MATCH) ? linksByMatchResult.get((Object)MdmMatchResultEnum.MATCH) : new ArrayList();
            List<Object> list = possibleMatches = linksByMatchResult.containsKey((Object)MdmMatchResultEnum.POSSIBLE_MATCH) ? linksByMatchResult.get((Object)MdmMatchResultEnum.POSSIBLE_MATCH) : new ArrayList();
            if (this.isDeletingLastMatchedSourceResouce(sourcePid, matches)) {
                IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(theResource);
                IResourcePersistentId goldenPid = this.extractGoldenPid(theResource, (IMdmLink)matches.get(0));
                this.cleanUpPossibleMatches(possibleMatches, dao, goldenPid, theRequest);
                IAnyResource goldenResource = (IAnyResource)dao.readByPid(goldenPid);
                this.myMdmLinkDeleteSvc.deleteWithAnyReferenceTo((IBaseResource)goldenResource);
                this.deleteGoldenResource(goldenPid, sourceId, dao, theRequest);
            }
            this.myMdmLinkDeleteSvc.deleteWithAnyReferenceTo(theResource);
        }
    }

    private void deleteGoldenResource(IResourcePersistentId goldenPid, IIdType theSourceId, IFhirResourceDao<?> theDao, RequestDetails theRequest) {
        MdmStorageInterceptor.setLinksDeletedBeforehand();
        if (this.myMdmSettings.isAutoExpungeGoldenResources()) {
            int numDeleted = this.deleteExpungeGoldenResource(goldenPid);
            if (numDeleted > 0) {
                ourLog.info("Removed {} golden resource(s) with references to {}", (Object)numDeleted, (Object)theSourceId);
            }
        } else {
            String url = theRequest == null ? "" : theRequest.getCompleteUrl();
            theDao.deletePidList(url, Collections.singleton(goldenPid), new DeleteConflictList(), theRequest, new TransactionDetails());
        }
        MdmStorageInterceptor.resetLinksDeletedBeforehand();
    }

    private void cleanUpPossibleMatches(List<IMdmLink> possibleMatches, IFhirResourceDao<?> theDao, IResourcePersistentId theGoldenPid, RequestDetails theRequestDetails) {
        IAnyResource goldenResource = (IAnyResource)theDao.readByPid(theGoldenPid);
        for (IMdmLink possibleMatch : possibleMatches) {
            if (!possibleMatch.getGoldenResourcePersistenceId().equals(theGoldenPid)) continue;
            IBaseResource sourceResource = theDao.readByPid(possibleMatch.getSourcePersistenceId());
            MdmCreateOrUpdateParams params = new MdmCreateOrUpdateParams();
            params.setGoldenResource(goldenResource);
            params.setSourceResource((IAnyResource)sourceResource);
            params.setMatchResult(MdmMatchResultEnum.NO_MATCH);
            MdmTransactionContext mdmContext = this.createMdmContext(MdmTransactionContext.OperationType.UPDATE_LINK, sourceResource.fhirType());
            params.setMdmContext(mdmContext);
            params.setRequestDetails(theRequestDetails);
            this.mdmLinkUpdaterSvc.updateLink(params);
        }
    }

    private IResourcePersistentId extractGoldenPid(IBaseResource theResource, IMdmLink theMdmLink) {
        Object goldenPid = theMdmLink.getGoldenResourcePersistenceId();
        goldenPid = this.myIdHelperSvc.newPidFromStringIdAndResourceName(goldenPid.toString(), theResource.fhirType());
        return goldenPid;
    }

    private boolean isDeletingLastMatchedSourceResouce(IResourcePersistentId theSourcePid, List<IMdmLink> theMatches) {
        return theMatches.size() == 1 && theMatches.get(0).getSourcePersistenceId().equals(theSourcePid);
    }

    private MdmTransactionContext createMdmContext(MdmTransactionContext.OperationType theOperation, String theResourceType) {
        TransactionLogMessages transactionLogMessages = TransactionLogMessages.createNew();
        MdmTransactionContext retVal = new MdmTransactionContext(transactionLogMessages, theOperation);
        retVal.setResourceType(theResourceType);
        return retVal;
    }

    private int deleteExpungeGoldenResource(IResourcePersistentId theGoldenPid) {
        IDeleteExpungeSvc deleteExpungeSvc = this.myIMdmClearHelperSvc.getDeleteExpungeSvc();
        return deleteExpungeSvc.deleteExpunge(new ArrayList<IResourcePersistentId>(Collections.singleton(theGoldenPid)), false, null);
    }

    private void forbidIfModifyingExternalEidOnTarget(IBaseResource theNewResource, IBaseResource theOldResource) {
        List<CanonicalEID> newExternalEids = Collections.emptyList();
        List<CanonicalEID> oldExternalEids = Collections.emptyList();
        if (theNewResource != null) {
            newExternalEids = this.myEIDHelper.getExternalEid(theNewResource);
        }
        if (theOldResource != null) {
            oldExternalEids = this.myEIDHelper.getExternalEid(theOldResource);
        }
        if (oldExternalEids.isEmpty()) {
            return;
        }
        if (!this.myEIDHelper.eidMatchExists(newExternalEids, oldExternalEids)) {
            this.throwBlockEidChange();
        }
    }

    private void throwBlockEidChange() {
        throw new ForbiddenOperationException(Msg.code((int)763) + "While running with EID updates disabled, EIDs may not be updated on source resources");
    }

    private void forbidModifyingMdmTag(IBaseResource theNewResource, IBaseResource theOldResource) {
        if (MdmResourceUtil.isMdmManaged(theNewResource) != MdmResourceUtil.isMdmManaged(theOldResource)) {
            this.throwBlockMdmManagedTagChange();
        }
    }

    private void forbidIfHasMultipleEids(IBaseResource theResource) {
        String resourceType = this.extractResourceType(theResource);
        if (this.myMdmSettings.isSupportedMdmType(resourceType) && this.myEIDHelper.getExternalEid(theResource).size() > 1) {
            this.throwBlockMultipleEids();
        }
    }

    private boolean isInternalRequest(RequestDetails theRequestDetails) {
        return theRequestDetails == null || theRequestDetails instanceof SystemRequestDetails;
    }

    private void forbidIfMdmManagedTagIsPresent(IBaseResource theResource) {
        if (theResource == null) {
            ourLog.warn("Attempting to forbid MDM on a null resource");
            return;
        }
        if (MdmResourceUtil.isMdmManaged(theResource)) {
            this.throwModificationBlockedByMdm();
        }
        if (MdmResourceUtil.hasGoldenRecordSystemTag(theResource)) {
            this.throwModificationBlockedByMdm();
        }
    }

    private void throwBlockMdmManagedTagChange() {
        throw new ForbiddenOperationException(Msg.code((int)764) + "The HAPI-MDM tag on a resource may not be changed once created.");
    }

    private void throwModificationBlockedByMdm() {
        throw new ForbiddenOperationException(Msg.code((int)765) + "Cannot create or modify Resources that are managed by MDM. This resource contains a tag with one of these systems: http://hapifhir.io/fhir/NamingSystem/mdm-record-status or https://hapifhir.org/NamingSystem/managing-mdm-system");
    }

    private void throwBlockMultipleEids() {
        throw new ForbiddenOperationException(Msg.code((int)766) + "While running with multiple EIDs disabled, source resources may have at most one EID.");
    }

    private String extractResourceType(IBaseResource theResource) {
        return this.myFhirContext.getResourceType(theResource);
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_EXPUNGE_EVERYTHING)
    public void expungeAllMdmLinks(AtomicInteger theCounter) {
        ourLog.debug("Expunging all MdmLink records");
        theCounter.addAndGet(this.myExpungeEverythingService.expungeEverythingMdmLinks());
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_EXPUNGE_RESOURCE)
    public void expungeAllMatchedMdmLinks(AtomicInteger theCounter, IBaseResource theResource) {
        ourLog.debug("Expunging MdmLink records with reference to {}", (Object)theResource.getIdElement());
        theCounter.addAndGet(this.myMdmLinkDeleteSvc.deleteWithAnyReferenceTo(theResource));
    }

    public static void setLinksDeletedBeforehand() {
        ourLinksDeletedBeforehand.set(Boolean.TRUE);
    }

    public static void resetLinksDeletedBeforehand() {
        ourLinksDeletedBeforehand.remove();
    }
}

