/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.interceptor;

import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.mdm.api.IMdmLinkExpandSvc;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.TokenParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Interceptor
public class MdmSearchExpandingInterceptor {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    private IRequestPartitionHelperSvc myRequestPartitionHelperSvc;
    @Autowired
    private IMdmLinkExpandSvc myMdmLinkExpandSvc;
    @Autowired
    private JpaStorageSettings myStorageSettings;

    @Hook(value=Pointcut.STORAGE_PRESEARCH_REGISTERED)
    public void hook(RequestDetails theRequestDetails, SearchParameterMap theSearchParameterMap) {
        if (this.myStorageSettings.isAllowMdmExpansion()) {
            RequestDetails requestDetailsToUse = theRequestDetails == null ? new SystemRequestDetails() : theRequestDetails;
            RequestPartitionId requestPartitionId = this.myRequestPartitionHelperSvc.determineReadPartitionForRequestForSearchType(requestDetailsToUse, requestDetailsToUse.getResourceName(), theSearchParameterMap, null);
            for (Map.Entry set : theSearchParameterMap.entrySet()) {
                String paramName = (String)set.getKey();
                List andList = (List)set.getValue();
                for (List orList : andList) {
                    this.expandAnyReferenceParameters(requestPartitionId, paramName, orList);
                }
            }
        }
    }

    private void expandAnyReferenceParameters(RequestPartitionId theRequestPartitionId, String theParamName, List<IQueryParameterType> orList) {
        ArrayList<IQueryParameterType> toRemove = new ArrayList<IQueryParameterType>();
        ArrayList<IQueryParameterType> toAdd = new ArrayList<IQueryParameterType>();
        for (IQueryParameterType iQueryParameterType : orList) {
            if (iQueryParameterType instanceof ReferenceParam) {
                ReferenceParam refParam = (ReferenceParam)iQueryParameterType;
                if (!refParam.isMdmExpand()) continue;
                ourLog.debug("Found a reference parameter to expand: {}", (Object)refParam);
                Set<String> expandedResourceIds = this.myMdmLinkExpandSvc.expandMdmBySourceResourceId(theRequestPartitionId, (IIdType)new IdDt(refParam.getValue()));
                if (expandedResourceIds.isEmpty()) {
                    expandedResourceIds = this.myMdmLinkExpandSvc.expandMdmByGoldenResourceId(theRequestPartitionId, new IdDt(refParam.getValue()));
                }
                if (expandedResourceIds.isEmpty()) continue;
                ourLog.debug("Parameter has been expanded to: {}", (Object)String.join((CharSequence)", ", expandedResourceIds));
                toRemove.add((IQueryParameterType)refParam);
                expandedResourceIds.stream().map(resourceId -> this.addResourceTypeIfNecessary(refParam.getResourceType(), (String)resourceId)).map(ReferenceParam::new).forEach(toAdd::add);
                continue;
            }
            if (!theParamName.equalsIgnoreCase("_id")) continue;
            this.expandIdParameter(theRequestPartitionId, iQueryParameterType, toAdd, toRemove);
        }
        orList.removeAll(toRemove);
        orList.addAll(toAdd);
    }

    private String addResourceTypeIfNecessary(String theResourceType, String theResourceId) {
        if (theResourceId.contains("/")) {
            return theResourceId;
        }
        return theResourceType + "/" + theResourceId;
    }

    private void expandIdParameter(RequestPartitionId theRequestPartitionId, IQueryParameterType theIdParameter, List<IQueryParameterType> theAddList, List<IQueryParameterType> theRemoveList) {
        Creator<IQueryParameterType> creator;
        IdDt id;
        boolean mdmExpand = false;
        if (theIdParameter instanceof TokenParam) {
            TokenParam param = (TokenParam)theIdParameter;
            mdmExpand = param.isMdmExpand();
            id = new IdDt(param.getValue());
            creator = TokenParam::new;
        } else {
            creator = null;
            id = null;
        }
        if (id == null) {
            ourLog.warn("_id parameter of incorrect type. Expected StringParam or TokenParam, but got {}. No expansion will be done!", (Object)theIdParameter.getClass().getSimpleName());
        } else if (mdmExpand) {
            ourLog.debug("_id parameter must be expanded out from: {}", (Object)id.getValue());
            Set<String> expandedResourceIds = this.myMdmLinkExpandSvc.expandMdmBySourceResourceId(theRequestPartitionId, (IIdType)id);
            if (expandedResourceIds.isEmpty()) {
                expandedResourceIds = this.myMdmLinkExpandSvc.expandMdmByGoldenResourceId(theRequestPartitionId, id);
            }
            if (!expandedResourceIds.isEmpty()) {
                ourLog.debug("_id parameter has been expanded to: {}", (Object)String.join((CharSequence)", ", expandedResourceIds));
                theRemoveList.add(theIdParameter);
                expandedResourceIds.stream().map(creator::create).forEach(theAddList::add);
            }
        }
    }

    private static interface Creator<T extends IQueryParameterType> {
        public T create(String var1);
    }
}

