/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.dao;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.mdm.api.IMdmLink;
import ca.uhn.fhir.mdm.api.MdmLinkSourceEnum;
import ca.uhn.fhir.mdm.api.MdmLinkWithRevision;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.api.paging.MdmPageRequest;
import ca.uhn.fhir.mdm.api.params.MdmHistorySearchParameters;
import ca.uhn.fhir.mdm.api.params.MdmQuerySearchParameters;
import ca.uhn.fhir.mdm.model.MdmPidTuple;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IIdType;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.history.Revisions;

public interface IMdmLinkDao<P extends IResourcePersistentId, M extends IMdmLink<P>> {
    public int deleteWithAnyReferenceToPid(P var1);

    public int deleteWithAnyReferenceToPidAndMatchResultNot(P var1, MdmMatchResultEnum var2);

    public List<MdmPidTuple<P>> expandPidsFromGroupPidGivenMatchResult(P var1, MdmMatchResultEnum var2);

    public List<MdmPidTuple<P>> expandPidsBySourcePidAndMatchResult(P var1, MdmMatchResultEnum var2);

    public List<MdmPidTuple<P>> expandPidsByGoldenResourcePidAndMatchResult(P var1, MdmMatchResultEnum var2);

    default public List<M> findLinksAssociatedWithGoldenResourceOfSourceResourceExcludingNoMatch(P theSourcePid) {
        throw new UnsupportedOperationException(Msg.code((int)2428));
    }

    public List<P> findPidByResourceNameAndThreshold(String var1, Date var2, Pageable var3);

    public List<P> findPidByResourceNameAndThresholdAndPartitionId(String var1, Date var2, List<Integer> var3, Pageable var4);

    public List<M> findAllById(List<P> var1);

    public Optional<M> findById(P var1);

    public void deleteAll(List<M> var1);

    public List<M> findAll(Example<M> var1);

    public List<M> findAll();

    public Long count();

    public void deleteAll();

    public M save(M var1);

    public Optional<M> findOne(Example<M> var1);

    public void delete(M var1);

    public M validateMdmLink(IMdmLink var1) throws UnprocessableEntityException;

    @Deprecated
    public Page<M> search(IIdType var1, IIdType var2, MdmMatchResultEnum var3, MdmLinkSourceEnum var4, MdmPageRequest var5, List<Integer> var6);

    public Page<M> search(MdmQuerySearchParameters var1);

    public Optional<M> findBySourcePidAndMatchResult(P var1, MdmMatchResultEnum var2);

    public void deleteLinksWithAnyReferenceToPids(List<P> var1);

    @Deprecated(since="6.5.6", forRemoval=true)
    default public Revisions<Long, M> findHistory(P thePid) {
        throw new UnsupportedOperationException(Msg.code((int)2296) + "Deprecated and not supported in non-JPA");
    }

    default public List<MdmLinkWithRevision<M>> getHistoryForIds(MdmHistorySearchParameters theMdmHistorySearchParameters) {
        throw new UnsupportedOperationException(Msg.code((int)2299) + "not yet implemented");
    }
}

