/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.api.params;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.mdm.api.MdmLinkSourceEnum;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.api.paging.MdmPageRequest;
import ca.uhn.fhir.mdm.provider.MdmControllerUtil;
import ca.uhn.fhir.rest.api.SortOrderEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.internal.util.StringHelper;
import org.hl7.fhir.instance.model.api.IIdType;

public class MdmQuerySearchParameters {
    public static final String GOLDEN_RESOURCE_PID_NAME = "myGoldenResourcePid";
    public static final String SOURCE_PID_NAME = "mySourcePid";
    public static final String MATCH_RESULT_NAME = "myMatchResult";
    public static final String LINK_SOURCE_NAME = "myLinkSource";
    public static final String PARTITION_ID_NAME = "myPartitionId";
    public static final String GOLDEN_RESOURCE_NAME = "myGoldenResource";
    public static final String RESOURCE_TYPE_NAME = "myResourceType";
    public static final String CREATED_NAME = "myCreated";
    public static final String UPDATED_NAME = "myUpdated";
    public static final String SCORE_NAME = "myScore";
    public static final Set<String> ourValidSortParameters = Set.of("myGoldenResourcePid", "mySourcePid", "myMatchResult", "myLinkSource", "myPartitionId", "myGoldenResource", "myResourceType", "myCreated", "myUpdated", "myScore");
    private IIdType myGoldenResourceId;
    private IIdType mySourceId;
    private MdmMatchResultEnum myMatchResult;
    private MdmLinkSourceEnum myLinkSource;
    private MdmPageRequest myPageRequest;
    private List<Integer> myPartitionIds;
    private String myResourceType;
    private final List<SortSpec> mySort = new ArrayList<SortSpec>();

    @Deprecated(since="2023.02.R01", forRemoval=true)
    public MdmQuerySearchParameters() {
    }

    public MdmQuerySearchParameters(MdmPageRequest thePageRequest) {
        this.setPageRequest(thePageRequest);
    }

    @Deprecated(since="2023.02.R01", forRemoval=true)
    public MdmQuerySearchParameters(@Nullable String theGoldenResourceId, @Nullable String theSourceId, @Nullable String theMatchResult, @Nullable String theLinkSource, MdmPageRequest thePageRequest, @Nullable List<Integer> thePartitionIds, @Nullable String theResourceType) {
        this.setGoldenResourceId(theGoldenResourceId);
        this.setSourceId(theSourceId);
        this.setLinkSource(theLinkSource);
        this.setMatchResult(theMatchResult);
        this.setPartitionIds(thePartitionIds);
        this.setPageRequest(thePageRequest);
        this.setResourceType(theResourceType);
    }

    @Deprecated(since="2023.02.R01", forRemoval=true)
    public MdmQuerySearchParameters(@Nullable IIdType theGoldenResourceId, @Nullable IIdType theSourceId, @Nullable MdmMatchResultEnum theMatchResult, @Nullable MdmLinkSourceEnum theLinkSource, MdmPageRequest thePageRequest, @Nullable List<Integer> thePartitionIds, @Nullable String theResourceType) {
        this.setGoldenResourceId(theGoldenResourceId);
        this.setSourceId(theSourceId);
        this.setLinkSource(theLinkSource);
        this.setMatchResult(theMatchResult);
        this.setPartitionIds(thePartitionIds);
        this.setPageRequest(thePageRequest);
        this.setResourceType(theResourceType);
    }

    public IIdType getGoldenResourceId() {
        return this.myGoldenResourceId;
    }

    public MdmQuerySearchParameters setGoldenResourceId(IIdType theGoldenResourceId) {
        this.myGoldenResourceId = theGoldenResourceId;
        return this;
    }

    public MdmQuerySearchParameters setGoldenResourceId(String theGoldenResourceId) {
        this.myGoldenResourceId = MdmControllerUtil.extractGoldenResourceIdDtOrNull("goldenResourceId", theGoldenResourceId);
        return this;
    }

    public IIdType getSourceId() {
        return this.mySourceId;
    }

    public MdmQuerySearchParameters setSourceId(IIdType theSourceId) {
        this.mySourceId = theSourceId;
        return this;
    }

    public MdmQuerySearchParameters setSourceId(String theSourceId) {
        this.mySourceId = MdmControllerUtil.extractSourceIdDtOrNull("resourceId", theSourceId);
        return this;
    }

    public MdmMatchResultEnum getMatchResult() {
        return this.myMatchResult;
    }

    public MdmQuerySearchParameters setMatchResult(MdmMatchResultEnum theMatchResult) {
        this.myMatchResult = theMatchResult;
        return this;
    }

    public MdmQuerySearchParameters setMatchResult(String theMatchResult) {
        this.myMatchResult = MdmControllerUtil.extractMatchResultOrNull(theMatchResult);
        return this;
    }

    public MdmLinkSourceEnum getLinkSource() {
        return this.myLinkSource;
    }

    public MdmQuerySearchParameters setLinkSource(MdmLinkSourceEnum theLinkSource) {
        this.myLinkSource = theLinkSource;
        return this;
    }

    public MdmQuerySearchParameters setLinkSource(String theLinkSource) {
        this.myLinkSource = MdmControllerUtil.extractLinkSourceOrNull(theLinkSource);
        return this;
    }

    public MdmPageRequest getPageRequest() {
        return this.myPageRequest;
    }

    public void setPageRequest(MdmPageRequest thePageRequest) {
        this.myPageRequest = thePageRequest;
    }

    public List<Integer> getPartitionIds() {
        return this.myPartitionIds;
    }

    public MdmQuerySearchParameters setPartitionIds(List<Integer> thePartitionIds) {
        this.myPartitionIds = thePartitionIds;
        return this;
    }

    public String getResourceType() {
        return this.myResourceType;
    }

    public MdmQuerySearchParameters setResourceType(String theResourceType) {
        this.myResourceType = theResourceType;
        return this;
    }

    public List<SortSpec> getSort() {
        return this.mySort;
    }

    public MdmQuerySearchParameters setSort(String theSortString) {
        if (StringHelper.isBlank((String)theSortString)) {
            return this;
        }
        for (String param : theSortString.split(",")) {
            String p = (param.startsWith("-") ? param.substring(1) : param).trim();
            if (!ourValidSortParameters.contains(p)) {
                throw new InvalidRequestException(Msg.code((int)2233) + "Unrecognized sort parameter: " + p + ". Valid parameters are: " + String.join((CharSequence)", ", ourValidSortParameters));
            }
            SortOrderEnum order = param.startsWith("-") ? SortOrderEnum.DESC : SortOrderEnum.ASC;
            this.mySort.add(new SortSpec(p, order));
        }
        return this;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append(GOLDEN_RESOURCE_PID_NAME, (Object)this.myGoldenResourceId).append(SOURCE_PID_NAME, (Object)this.mySourceId).append(MATCH_RESULT_NAME, (Object)this.myMatchResult).append(LINK_SOURCE_NAME, (Object)this.myLinkSource).append(PARTITION_ID_NAME, this.myPartitionIds).append(RESOURCE_TYPE_NAME, (Object)this.myResourceType).append("myPageRequest", (Object)this.myPageRequest).toString();
    }
}

